﻿import React from 'react'
import { TextInput } from 'react-native'
import { useSetRecoilState, useRecoilValue } from 'recoil'
import { LoreEntry } from '../../../shared/data/ai/loreentry'
import { GlobalUserContext } from '../../../shared/globals/globals'
import { LorebookOpen, SelectedStory } from '../../../shared/globals/state'
import { InputSelected } from '../../globals/state'
import {
    LorebookSearch,
    SearchContainer,
    SearchContainerInner,
    SearchText,
    LorebookButton,
} from './lorebooksearch.style'
import { BookIcon, MagGlassIcon } from '../common/icons'
import { LoreSidebarEntry } from './lorebookitems'

export default function LorebookQuickAccess(): JSX.Element {
    const selectedStory = useRecoilValue(SelectedStory)
    const currentStoryContent = GlobalUserContext.storyContentCache.get(selectedStory.id)
    const setLorebookVisible = useSetRecoilState(LorebookOpen)
    const [sidebarSearchValue, setSidebarSearchValue] = React.useState('')

    const setInputSelected = useSetRecoilState(InputSelected)

    let sidebarEntries: LoreEntry[] = []
    if (sidebarSearchValue != '')
        sidebarEntries = [...(currentStoryContent?.lorebook.entries ?? [])]
            .sort((a, b) => {
                return a.displayName.localeCompare(b.displayName)
            })
            .filter((entry: LoreEntry) => {
                if (entry.enabled === false) return false
                let include = false
                include =
                    include ||
                    entry.displayName.toLocaleLowerCase().includes(sidebarSearchValue.toLocaleLowerCase())
                for (const key of entry.keys) {
                    include =
                        include || key.toLocaleLowerCase().includes(sidebarSearchValue.toLocaleLowerCase())
                }
                return include
            })
            .slice(0, 3)

    return (
        <SearchContainer>
            <SearchContainerInner>
                <LorebookSearch>
                    <SearchText
                        value={sidebarSearchValue}
                        onChangeText={(text) => {
                            setSidebarSearchValue(text)
                        }}
                        onFocus={() => setInputSelected(true)}
                        placeholder="Search for an entry"
                    />
                    <MagGlassIcon style={{ height: '14px' }} />
                </LorebookSearch>
                <LorebookButton
                    accessibilityRole="button"
                    onPress={() => {
                        setLorebookVisible(true)
                    }}
                    aria-label="Open Lorebook"
                >
                    <BookIcon style={{ height: '14px' }} />
                </LorebookButton>
            </SearchContainerInner>
            {currentStoryContent ? (
                sidebarEntries.map((entry, index) => {
                    return (
                        <LoreSidebarEntry
                            lore={entry}
                            key={entry.displayName + entry.keys.join('') + index}
                        />
                    )
                })
            ) : (
                <></>
            )}
        </SearchContainer>
    )
}
