﻿import React from 'react'
import { Image, TextInputProps } from 'react-native'
import {
    StyledBar,
    BackButton,
    BackText,
    OtherScreenButton,
    FieldView,
    FieldInput,
    BackArrow,
} from './common.style'
import { HeadingMedium600, BodyMedium600 } from '../../styles/fonts'

export function Bar(props: {
    pushBack(): void
    pushOtherScreen(): void
    otherScreenName: string
}): JSX.Element {
    return (
        <StyledBar>
            <BackButton onPress={() => props.pushBack()}>
                <BackArrow />
                <BackText>Back</BackText>
            </BackButton>
            <OtherScreenButton onPress={() => props.pushOtherScreen()}>
                <HeadingMedium600>{props.otherScreenName}</HeadingMedium600>
            </OtherScreenButton>
        </StyledBar>
    )
}

interface FieldProps extends TextInputProps {
    name: string
}

export function Field(props: FieldProps): JSX.Element {
    return (
        <FieldView>
            <BodyMedium600>{props.name}</BodyMedium600>
            <FieldInput value={props.value} onChangeText={props.onChangeText} {...props} />
        </FieldView>
    )
}
