import styled from 'styled-components/native'

export const Tabs = styled.View`
    flex: 1;
    flex-direction: column;
`

export const TabHeaderList = styled.View<{ padded?: boolean }>`
    flex: 0;
    flex-direction: row;
    justify-content: space-evenly;
    min-height: 48px;
    margin-top: 12px;
    margin-horizontal: ${(props) => (props.padded ? '12px' : '0px')};
    padding-right: 2px;
    background: ${(props) => props.theme.colors.bg0};
`

export const TabHeader = styled.Pressable<{ selected: boolean; narrow?: boolean }>`
    background: ${(props) => (props.selected ? props.theme.colors.bg2 : props.theme.colors.bg0)};
    flex: ${(props) => (props.narrow ? '0.55' : '1')};
    justify-content: center;
    margin-vertical: 2px;
    margin-left: 2px;
    align-items: center;
    outline: 2px solid ${(props) => props.theme.colors.bg0};
`

export const TabHeaderContent = styled.View<{ selected: boolean }>`
    opacity: ${(props) => (props.selected ? '1' : '0.3')};
`

export const TabContent = styled.View`
    flex: 1;
    flex-direction: column;
`

export const Tab = styled.View<{ visible: boolean }>`
    flex: 1;
    display: ${(props) => (props.visible ? 'flex' : 'none')};
`
