﻿import React, { useRef } from 'react'
import { View } from 'react-native'
import { useRecoilState, useRecoilValue, useSetRecoilState } from 'recoil'
import { serialize } from 'serializr'
import { SetterPackage, updateStory } from '../../../../shared/component-logic/optionslogic'
import { getStorage } from '../../../../shared/data/storage/storage'
import { PrefixOptions } from '../../../../shared/data/story/defaultprefixes'
import { StoryMode } from '../../../../shared/data/story/story'
import { DefaultPrefixOption, AIModule } from '../../../../shared/data/story/storysettings'
import { GlobalUserContext } from '../../../../shared/globals/globals'
import { CustomModules, Session, StoryUpdate } from '../../../../shared/globals/state'
import { useReload } from '../../../../shared/hooks/useReload'
import { useModuleOptions } from '../../../hooks/useModuleOptions'
import SelectorModal from '../../modals/selectormodal'
import { DefaultModel } from '../../../../shared/data/request/model'
import { deserialize } from '../../../../shared/util/serialization'
import { toast } from '../../../util/toast'

export default function ModuleSelector(props: {
    selectedStory: string
    presetModalVisible: boolean
    setPresetModalVisible: (visible: boolean) => void
}): JSX.Element {
    const [customModules, setCustomModules] = useRecoilState(CustomModules)
    const session = useRecoilValue(Session)
    const setStoryUpdate = useSetRecoilState(StoryUpdate(props.selectedStory))

    const reload = useReload()

    const currentStory = GlobalUserContext.stories.get(props.selectedStory)
    const currentStoryContent = GlobalUserContext.storyContentCache.get(props.selectedStory)
    const settings = currentStoryContent?.settings
    const genSettings = settings?.parameters
    const selectedPrefix = settings?.prefix ? settings.prefix : DefaultPrefixOption
    const setterPackage: SetterPackage = {
        currentStory: currentStory,
        currentStoryContent: currentStoryContent,
        genSettings: genSettings,
        updateState: setStoryUpdate,
    }

    const prefixOptions = useModuleOptions(
        settings?.prefix ? settings.prefix : DefaultPrefixOption,
        currentStoryContent?.settings.model ?? DefaultModel,
        true
    )
    const combinedPrefixes = [
        ...customModules,
        ...[...PrefixOptions.keys()].map((key) => {
            return {
                id: key,
                mode: PrefixOptions.get(key)?.mode ?? StoryMode.normal,
                name: PrefixOptions.get(key)?.label ?? key,
                description: PrefixOptions.get(key)?.label ?? key,
                image: PrefixOptions.get(key)?.image,
            } as AIModule
        }),
    ]
    if (currentStoryContent?.settings.aiModule) {
        combinedPrefixes.push(currentStoryContent.settings.aiModule)
    }
    const hasStorySpecificPrefix =
        currentStoryContent &&
        currentStoryContent.settings &&
        currentStoryContent.settings.aiModule &&
        !customModules.some((e) => e.id === currentStoryContent?.settings?.aiModule?.id)

    const prefixSaving = useRef(false)
    const saveStorySpecificPrefix = async () => {
        if (prefixSaving.current) return
        try {
            if (!hasStorySpecificPrefix || !currentStoryContent?.settings?.aiModule) return
            prefixSaving.current = true
            const aiModule = deserialize(
                AIModule,
                serialize(AIModule, currentStoryContent?.settings?.aiModule)
            )
            aiModule.remoteId = ''
            if (customModules.some((existingModule) => existingModule.id === aiModule.id)) return
            await getStorage(session).saveModule(aiModule)
            setCustomModules([...customModules, aiModule])
        } catch (error: any) {
            toast(`${error.message ?? error}`)
        } finally {
            prefixSaving.current = false
        }
    }

    //commented out parts for testing purposes
    if (!settings) return <React.Fragment></React.Fragment>

    const setPrefix = (prefix: string) => {
        prefix &&
            updateStory(() => {
                settings.prefix = prefix ? prefix : DefaultPrefixOption
                settings.prefixMode =
                    combinedPrefixes.find((x) => x.id === settings.prefix)?.mode ?? StoryMode.normal
                reload()
            }, setterPackage)
    }

    return (
        <View>
            <SelectorModal data={prefixOptions} selectedID={selectedPrefix} setID={setPrefix} />
        </View>
    )
}
