﻿import { Animated } from 'react-native'
import { SafeAreaView } from 'react-native-safe-area-context'
import styled from 'styled-components/native'
import { noBounceProps } from '../../styles/noBounce'
import { StatsIcon } from '../common/icons'

//The top navigator is 60px high
export const Infobar = styled(SafeAreaView)<{ bordered: boolean }>`
    background: ${(props) => props.theme.colors.bg2};
    border-color: ${(props) => props.theme.colors.bg3};
    border-left-width: ${(props) => (props.bordered ? '1px' : '0')};
    flex-grow: 1;
    flex-direction: column;
    padding-top: 60px;
`

export const Separator = styled.View`
    border-top-width: 1px;
    border-color: ${(props) => props.theme.colors.bg3};
    margin-horizontal: 12px;
    align-self: stretch;
`

export const Footer = styled.View`
    height: 40px;
`

export const StyledStatsIcon = styled(StatsIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    width: 12,
    height: 12,
}))`
    margin-right: 8px;
    z-index: 100;
    width: 100%;
`

export const OuterHoverBar = styled(Animated.View)`
    background: ${(props) => props.theme.colors.bg2};
    width: 100%;
`

export const InnerHoverBar = styled.View`
    background: ${(props) => props.theme.colors.bg2};
    padding-horizontal: 11px;
`

//Applying top and bottom padding to scrollviews breaks them
export const SidebarElementsContainer = styled.ScrollView.attrs(() => noBounceProps)``

export const SidebarPlaceholder = styled.View`
    padding: 20px;
`
