import { TextInputTextInputEventData } from 'react-native'
import { DataOrigin } from '../../../shared/components/editor/glue'
import { Segment } from './model'

export const ignoreDot = (
    rawData: TextInputTextInputEventData,
    restore: () => void
): TextInputTextInputEventData => {
    let data: TextInputTextInputEventData = { ...rawData, range: { ...rawData.range } }
    if (rawData.range.start === 0) {
        if (data.previousText.startsWith('.')) data.previousText = data.previousText.substring(1)
        else return data
        if (data.text.startsWith('.')) data.text = data.text.substring(1)
        else {
            console.log('firstchar has been removed')
            restore()
        }
    } else data.range.start -= 1
    data.range.end -= 1
    return data
}

export const getOrigin = (involvedSegs: Segment[], defaultOrigin: DataOrigin): DataOrigin => {
    const segs = [...involvedSegs]
    const editOrigins = [DataOrigin.ai, DataOrigin.edit]
    const prevIsEdit = editOrigins.includes(segs.shift()?.origin ?? DataOrigin.unknown)
    const nextIsEdit = editOrigins.includes(
        segs.pop()?.origin ?? prevIsEdit ? DataOrigin.edit : DataOrigin.unknown
    )
    return (segs.some((seg) => editOrigins.includes(seg.origin)) && (prevIsEdit || nextIsEdit)) ||
        (prevIsEdit && nextIsEdit)
        ? DataOrigin.edit
        : defaultOrigin
}

export const glueSegments = (oldSegs: Segment[]): Segment[] => {
    const segs = [...oldSegs]
    let firstSeg = segs.shift()
    return segs.reduce(
        (prev: Segment[], current) => {
            const prevSeg = prev.length > 0 ? prev[prev.length - 1] : undefined
            if (
                (!prevSeg && current.data.length > 0) ||
                (prevSeg?.origin !== current.origin && current.data.trim().length > 0)
            ) {
                if (
                    prevSeg &&
                    prevSeg.data[prevSeg.data.length - 1] === ' ' &&
                    !current.data.startsWith(' ')
                ) {
                    prevSeg.data = prevSeg.data.substring(0, prevSeg.data.length - 1)
                    current.data = ' ' + current.data
                }
                prev.push(current)
            } else if (prevSeg) prevSeg.data += current.data
            return prev
        },
        firstSeg && firstSeg.data.length > 0 ? [firstSeg] : []
    )
}
