﻿//for use by Editor Cards

export const processNumericInput = (
    val: string,
    negativeAllowed: boolean,
    minVal: number | undefined,
    maxVal: number | undefined,
    setValue: (val: number) => void,
    setInputValue: (val: string) => void,
    step?: number,
    preventDecimal?: boolean
) => {
    const negative = negativeAllowed
    const decimal = !preventDecimal
    let regex = 0
    if (negative && decimal) {
        regex = 0
    } else if (negative && !decimal) {
        regex = 2
    } else if (!negative && !decimal) {
        regex = 3
    } else {
        regex = 1
    }

    let value = val.replace(EXCLUDE_REGEX[regex], '')
    const pattern = REGEX[regex]
    const matches = value.match(pattern)
    if (matches) {
        value = matches[0]
    }
    let num = Number.parseFloat(value)

    if (Number.isNaN(num)) {
        num = 0
    }
    if (step) {
        num -= num % step
    }

    num = Math.max(minVal ?? Number.NEGATIVE_INFINITY, Math.min(maxVal ?? Number.POSITIVE_INFINITY, num))
    if (value.endsWith('.') || value === '' || value === '-') {
        setInputValue(value)
    } else {
        setInputValue(value)
    }
    setValue(num)
}

export const EXCLUDE_REGEX = [
    /[^\d-.]+/g, // Non Decimal Number Characters
    /[^\d.]+/g, // Non Positive Decimal Number Characters
    /[^\d-]+/g, // Non Integer Characters
    /\D+/g, // Non Positive Integer Characters
]
export const REGEX = [
    /(-)?(\d+)(\.\d*)?/g, // Decimal Numbers
    /(\d+)(\.\d*)?/g, // Positive Decimal Numbers
    /(-)?(\d+)/g, // Integers
    /(\d+)/g, // Positive Integers
]

export function round(num: number, digits: number = 2) {
    return Math.round((num + Number.EPSILON) * Math.pow(10, digits)) / Math.pow(10, digits)
}
