﻿import Icon from 'react-native-vector-icons/MaterialIcons'
import styled, { css } from 'styled-components/native'

//contains header, description, and children
export const EditorCard = styled.View<{ small?: boolean }>`
    ${(props) =>
        !props.small &&
        css`
            padding-top: 17px;
            padding-horizontal: 12px;
        `}
`

export const EditorCardContainer = styled.View``

//contains title and hint
export const EditorCardHeader = styled.View`
    flex-direction: row;
    justify-content: space-between;
`

export const EditorCardTitle = styled.View<{ small?: boolean }>``

export const EditorCardHint = styled.View`
    align-self: center;
    opacity: 0.5;
`

export const EditorCardHintPressable = styled.TouchableOpacity.attrs(() => ({
    activeOpacity: 1.0,
    hitSlop: { top: 10, bottom: 10, left: 5, right: 5 },
}))`
    align-self: center;
    opacity: 0.8;
    z-index: 200;
`

export const EditorCardDescription = styled.View`
    padding-bottom: 10px;
    opacity: 0.6;
`

export const EditorCardTooltipIcon = styled(Icon).attrs(() => ({
    size: 20,
    name: 'help-outline',
}))`
    color: ${(props) => props.theme.colors.textMain};
    opacity: 0.3;
`

export const SliderCounterText = styled.Text<{ focused: boolean }>`
    color: ${(props) => (props.focused ? props.theme.colors.textHeadings : props.theme.colors.textMain)};
    font-weight: 700;
`
