import styled, { css } from 'styled-components/native'
import { BodyLarge700M } from '../../styles/fonts'

export const ButtonBase = css`
    border-radius: 3px;
    padding: 12px;
    flex-direction: row;
    align-items: center;
    align-self: stretch;
`

export const Button = styled.Pressable<{
    color?: string
    deCentered?: boolean
    disabled?: boolean
}>`
    ${ButtonBase}
    background-color: ${(props) => props.color ?? props.theme.colors.bg1};
    justify-content: ${(props) => (props.deCentered ? 'space-between' : 'center')};
    opacity: ${(props) => (props.disabled ? '0.5' : '1')};
`

//Note: TouchableHighlight components cannot take more than one child component.
export const HighlightButton = styled.TouchableHighlight.attrs((props) => ({
    underlayColor: props.theme.colors.textMain,
}))<{
    color?: string
    deCentered?: boolean
    disabled?: boolean
}>`
    ${ButtonBase}
    background-color: ${(props) => props.color ?? props.theme.colors.bg1};
    justify-content: ${(props) => (props.deCentered ? 'space-between' : 'center')};
    opacity: ${(props) => (props.disabled ? '0.5' : '1')};
`

export const SubmitButton = styled(HighlightButton)`
    background-color: ${(props) => props.theme.colors.textHeadings};
    margin-top: 20px;
`

export const SubmitButtonText = styled.Text`
    ${BodyLarge700M};
    color: ${(props) => props.theme.colors.bg0};
    align-self: center;
`

export const RegularButton = styled(HighlightButton).attrs((props) => ({
    underlayColor: props.theme.colors.bg3,
}))`
    background-color: ${(props) => props.theme.colors.bg2};
    margin-top: 20px;
`

export const RegularButtonText = styled.Text`
    ${BodyLarge700M};
    align-self: center;
`

export const GoldenButtonText = styled.Text`
    ${BodyLarge700M};
    color: ${(props) => props.theme.colors.textHeadings};
    align-self: center;
`

export const SubtleButton = styled.TouchableOpacity`
    justify-content: center;
    align-items: center;
    flex-direction: row;
    margin: 10px;
    padding: 12px;
    opacity: 0.5;
`

export const SubtleButtonText = styled.Text`
    ${BodyLarge700M};
    align-self: center;
`

export const AlternateSubmitButton = styled(SubmitButton)`
    margin-top: 10px;
    margin-bottom: 5px;
`

export const AlternateSubtleButton = styled(SubtleButton)`
    margin-top: 10px;
    margin-bottom: 5px;
`

export const WarningButton = styled(Button).attrs((props) => ({
    underlayColor: props.theme.colors.textMain,
    opacity: !props.disabled ? 1 : 0.5,
}))`
    background-color: ${(props) => props.theme.colors.warning};
    padding: 12px;
    margin-top: 10px;
`

export const BorderedButton = styled(Button)`
    border: 1px solid ${(props) => props.theme.colors.bg3};
`

export const LightColorButton = styled(Button)`
    background-color: ${(props) => props.theme.colors.bg3};
`
