--- Sexbound.Util Module.
-- @module Sexbound.Util
-- @author Locuturus
-- @license GNU General Public License v3.0
Sexbound = Sexbound or {}
Sexbound.Util = {}

--- Send a Radio Message to every player in the world.
-- @param messageId
-- @param unique
-- @param text
Sexbound.Util.broadcastRadioMessage = function(messageId, unique, text)
    for _,entityId in ipairs(world.players() or {}) do
        world.sendEntityMessage(entityId, "queueRadioMessage", {
            messageId = messageId,
            unique = unique,
            text = text
        })
    end
end

--- Returns a properly formatted replace image directive for specified table of hex color codes.
-- @param colors A table of hex color codes
-- @usage Sexbound.Util.colorMapToReplaceDirective({["ff0000"] = "0000ff", ["00ff00"] = "ff0000", ["0000ff"] = "00ff00"})
Sexbound.Util.colorMapToReplaceDirective = function(colors)
    if not colors or type(colors) ~= "table" then
        return ""
    end

    local directives = {}

    for k, v in pairs(colors) do
        table.insert(directives, tostring(k) .. "=" .. tostring(v))
    end

    return "?replace;" .. table.concat(directives, ";")
end

--- Returns an entity's world position when it is found with the specified unique ID. Otherwise, false is returned.
-- @param uniqueId A Unique ID as a string
-- @usage local position = Sexbound.Util.findEntityWithUid("sexbound")
Sexbound.Util.findEntityWithUid = function(uniqueId)
    if world.findUniqueEntity(uniqueId):result() then return true end -- waits for async result

    return false
end

Sexbound.Util.imageExists = function(filename)
    if type(filename) ~= "string" or string.len(filename) == 0 then
        return false
    end

    -- Assume a 64 x 64 image is a missing sprite AKA. (/assetmissing.png)
    local imageSize = root.imageSize(filename)

    -- Return the default part image when an image asset is presumed to be missing
    return (imageSize[1] ~= 64 and imageSize[2] ~= 64)
end

--- Returns a parsed version number.
-- @param version
Sexbound.Util.parseVersion = function(version)
    version = version:gsub('[xX]', '0') -- Replace x with 0

    return string.match(version, '^([<>=]*)(%d+).(%d+).(%d+)$')
end

--- Returns a string where all specified arguments have been joined by specified character symbol.
-- @param symbol An ASCII character
-- @param[opt] string1 A string
-- @param[optchain] string2 A string
-- @usage Sexbound.Util.join("-", "sex", "bound")
-- @usage Sexbound.Util.join(" ", "powering", "sex", "in", "starbound")
Sexbound.Util.join = function(symbol, ...)
    return table.concat({...}, symbol or ",")
end

--- Returns a parsed version number.
-- @param version
-- @usage Sexbound.Util.parseVersion(">=5.0.0")
Sexbound.Util.parseVersion = function(version)
    version = version:gsub('[xX]', '0') -- Replace x with 0
    return string.match(version, '^([<>=]*)(%d+).(%d+).(%d+)$')
end

--- Swaps two specified elements in an array.
-- @param array a Table.
-- @param index1
-- @param index2
Sexbound.Util.swap = function(array, index1, index2)
    array[index1], array[index2] = array[index2], array[index1]
end

---Returns a when result is true, otherwise returns b.
-- @param result Boolean value.
-- @param a Any value
-- @param b Any value
-- @usage local val = Sexbound.Util.ternary(1 < 2, "Success", "Failure")
Sexbound.Util.ternary = function(result, a, b)
    if result then
        return a
    else
        return b
    end
end

---Disables tile protection based on position.
-- @param position Table value.
Sexbound.Util.tileProtectionDisable = function(position)
    if type(world.dungeonId) ~= "function" then
        return nil
    end
    if type(world.setTileProtection) ~= "function" then
        return nil
    end

    local dungeonId, protected = world.dungeonId(position), world.isTileProtected(position)

    -- Disable tile protection
    if protected and dungeonId then
        world.setTileProtection(dungeonId, false)

        return dungeonId
    end

    return nil
end

---Enables tile protection based on position.
-- @param dungeonId Table value.
Sexbound.Util.tileProtectionEnable = function(dungeonId)
    if dungeonId ~= nil then
        world.setTileProtection(dungeonId, true)
    end
end
