--- BabyFactory Class Module.
-- @classmod BabyFactory
-- @author Locuturus
-- @license GNU General Public License v3.0
BabyFactory = {}
BabyFactory_mt = {
    __index = BabyFactory
}

--- Instantiates a new instance of BabyFactory.
-- @param parent
-- @param config
function BabyFactory:new(parent)
    local _self = setmetatable({
        _parent = parent
    }, BabyFactory_mt)

    return _self
end

function BabyFactory:make()
    local actor = self:getParent():getParent()

    local baby = {
        birthGender = self:createRandomBirthGender(),
        birthTime = self:createRandomBirthTime(),
        motherName = actor:getIdentity("name"),
        motherId = actor:getEntityId(),
        motherUuid = actor:getUniqueId(),
        motherType = actor:getEntityType()
    }

    baby.birthDate, baby.dayCount = self:createRandomBirthDate()

    baby.birthWorldTime = baby.birthDate + baby.birthTime

    local secondsInOneDay = 86000
    baby.birthOSTime = os.time() + (baby.dayCount * secondsInOneDay) + (baby.birthTime * secondsInOneDay)

    return baby
end

--- Returns a random birth gender.
-- @return birthGender
function BabyFactory:createRandomBirthGender()
    -- Futanari?

    return util.randomChoice({"male", "female"})
end

--- Returns a random birth date and day count.
-- @return birthDate, dayCount
function BabyFactory:createRandomBirthDate()
    local config = self:getParent():getConfig()

    local trimesterCount = util.randomIntInRange(config.trimesterCount or 3)
    local trimesterLength = config.trimesterLength or {5, 8}

    local dayCount = 0

    for i = 1, trimesterCount do
        dayCount = dayCount + util.randomIntInRange(trimesterLength)
    end

    return (world.day() + dayCount), dayCount
end

--- Returns a random birth time
-- @return birthTime
function BabyFactory:createRandomBirthTime()
    return util.randomInRange({0.0, 1.0})
end

--- Returns a reference to the parent object
function BabyFactory:getParent()
    return self._parent
end