if not SXB_RUN_TESTS then
    require "/scripts/sexbound/plugins/climax/scriptedclimax/scenariobase.lua"
end

Sexbound.ScriptedClimax.Scenario1 = Sexbound.ScriptedClimax:new()
Sexbound.ScriptedClimax.Scenario1_mt = {
    __index = Sexbound.ScriptedClimax.Scenario1
}

function Sexbound.ScriptedClimax.Scenario1:new(parent)
    local _self = setmetatable({}, Sexbound.ScriptedClimax.Scenario1_mt)

    _self:init(parent)

    return _self
end

function Sexbound.ScriptedClimax.Scenario1:reset()

end

function Sexbound.ScriptedClimax.Scenario1:run(dt)
    self:getParent():addTimer("scriptedclimax", dt)

    self:getParent():addTimer("shoot", dt)

    -- if self:getParent():getTimer("scriptedclimax") >= 15 and self:getParent():getTimer("shoot") >=
        -- self:getParent():getCooldown() then
        -- if (self:getParent():getParent():getSpecies() == "novakid") then self:spawnExplosion() end
    -- end

    if self:getParent():getTimer("scriptedclimax") >= 10 and self:getParent():getTimer("shoot") >=
        self:getParent():getCooldown() then
        self:getParent():shoot()
    end

    if self:getParent():getTimer("scriptedclimax") >= 30 then
        self:getParent():endScriptedClimax()
    end
end

function Sexbound.ScriptedClimax.Scenario1:start()
    local parent = self._parent
    local main = parent:getRoot()

    main._overrideSustainedInterval = 30
    main._overrideMinTempo = 1
    main._overrideMaxTempo = 10

    parent:getConfig().shotCooldown = vec2.mul(parent:getConfig().shotCooldown, 0.5)
end

function Sexbound.ScriptedClimax.Scenario1:stop()
    local parent = self._parent
    local main = parent:getRoot()

    main._overrideSustainedInterval = nil
    main._overrideMinTempo = nil
    main._overrideMaxTempo = nil

    parent:getConfig().shotCooldown = vec2.mul(parent:getConfig().shotCooldown, 2)
end

function Sexbound.ScriptedClimax.Scenario1:spawnExplosion()
    local spawnPosition = entity.position()
    spawnPosition = vec2.add(spawnPosition, {0, 2})

    world.spawnProjectile("burningexplosion", spawnPosition, self:getParent():getParent():getEntityId(), nil, false, {
        actionOnReap = {
            ["1"] = {
                action = "config",
                file = "/projectiles/explosions/burningexplosion/burningexplosion.config"
            }
        }
    })
end
