require "/scripts/sexbound/override/common/subgender.lua"

Sexbound.Player.SubGender = Sexbound.Common.SubGender:new()
Sexbound.Player.SubGender_mt = {
    __index = Sexbound.Player.SubGender
}

function Sexbound.Player.SubGender:new(parent)
    return setmetatable({
        _parent = parent
    }, Sexbound.Player.SubGender_mt)
end

function Sexbound.Player.SubGender:handleSxbSubGenderChange(args)
    local sxbSubGenderName = args

    self:setSxbSubGender(sxbSubGenderName)

    self:notifyPlayerAboutSubGenderChange(sxbSubGenderName)

    return self:getSxbSubGender()
end

function Sexbound.Player.SubGender:notifyPlayerAboutSubGenderChange(sxbSubGenderName)
    local text = self:generateTextNotification(sxbSubGenderName)

    if text == nil then
        return
    end

    world.sendEntityMessage(player.id(), "queueRadioMessage", {
        messageId = "SubGender:Change",
        unique = false,
        text = text
    })
end

function Sexbound.Player.SubGender:generateTextNotification(sxbSubGenderName)
    if sxbSubGenderName == nil then
        return "You've reverted back to your default gender."
    end

    if sxbSubGenderName == "futanari" then
        return "What's this? It seems your body is rapidly generating new cellular material in your pelvis region."
    end
end
