if not SXB_RUN_TESTS then
    require "/scripts/sexbound/override/common/pregnant.lua"
end

Sexbound.Player.Pregnant = Sexbound.Common.Pregnant:new()
Sexbound.Player.Pregnant_mt = {
    __index = Sexbound.Player.Pregnant
}

function Sexbound.Player.Pregnant:new(parent)
    local _self = setmetatable({
        _parent = parent
    }, Sexbound.Player.Pregnant_mt)

    _self:init(parent)

    return _self
end

function Sexbound.Player.Pregnant:update(dt)
    if self._isGivingBirth == true then
        return
    end

    local babyReadyIndex = self:findReadyBabyIndex()

    if babyReadyIndex == nil then
        return
    end

    self:handleGiveBirth(babyReadyIndex)
end

function Sexbound.Player.Pregnant:abortPregnancy()
    Sexbound.Common.Pregnant.abortPregnancy(self)

    self:notifyPlayerAboutAbortionViaRadioMessage()
end

function Sexbound.Player.Pregnant:fetchAbortionNotificationMessage()
    local notifications = self:getParent():getNotifications() or {}
    notifications.plugins = notifications.plugins or {}
    notifications.plugins.pregnant = notifications.plugins.pregnant or {}

    return notifications.plugins.pregnant.abortionMessage1
end

function Sexbound.Player.Pregnant:notifyPlayerAboutAbortionViaRadioMessage()
    local message = self:fetchAbortionNotificationMessage()

    world.sendEntityMessage(entity.id(), "queueRadioMessage", {
        messageId = "sexbound_abortion",
        unique = false,
        text = message
    })
end

function Sexbound.Player.Pregnant:loadGiveBirthConfirmationConfig()
    if self._giveBirthConfirmationConfig then
        return self._giveBirthConfirmationConfig
    end
    self._giveBirthConfirmationConfig = root.assetJson("/interface/sexbound/confirmation/givebirth.config")
    return self._giveBirthConfirmationConfig
end

function Sexbound.Player.Pregnant:handleGiveBirth(index)
    self:dataFilter()

    if index == nil or not storage.sexbound.pregnant[index] then
        return
    end

    self._isGivingBirth = true

    promises:add(player.confirm(self:loadGiveBirthConfirmationConfig()), function(choice)
        self._isGivingBirth = false

        local babyConfig = storage.sexbound.pregnant[index]

        if choice then
            self:giveBirth(babyConfig)
            storage.sexbound.pregnant[index] = nil
            self:refreshStatusEffects()
        end

        babyConfig.birthWorldTime = world.day() + 1
        babyConfig.birthOSTime = os.time() + 3600
    end)
end
