require "/scripts/sexbound/override/common/identity.lua"

Sexbound.Player.Identity = Sexbound.Common.Identity:new()
Sexbound.Player.Identity_mt = {
    __index = Sexbound.Player.Identity
}

function Sexbound.Player.Identity:new(parent)
    local _self = setmetatable({
        _parent = parent
    }, Sexbound.Player.Identity_mt)

    _self:init(parent)

    return _self
end

--- Returns a table consisting of identifying information about the entity.
-- @param portraitData
function Sexbound.Player.Identity:build(target, portraitData)
    local identity = {
        gender = player.gender() or "male",
        species = player.species() or "human",
        name = world.entityName(entity.id()) or "",
        bodyDirectives = "",
        emoteDirectives = "",
        facialHairDirectives = "",
        facialHairFolder = "",
        facialHairGroup = "",
        facialHairType = "",
        facialMaskDirectives = "",
        facialMaskFolder = "",
        facialMaskGroup = "",
        facialMaskType = "",
        hairFolder = "hair",
        hairGroup = "hair",
        hairType = "1",
        hairDirectives = ""
    }

    identity = self:addCustomProperties(identity)

    util.each(world.entityPortrait(player.id(), "full"), function(k, v)
        -- Attempt to find facial mask
        if identity.facialMaskGroup ~= nil and identity.facialMaskGroup ~= "" and
            string.find(v.image, "/" .. identity.facialMaskGroup) ~= nil then
            identity.facialMaskFolder, identity.facialMaskType =
                string.match(v.image, '^.*/(' .. identity.facialMaskGroup .. '.*)/(.*)%.png:.-$')
            identity.facialMaskDirectives = self:filterReplace(v.image)
        end

        -- Attempt to find facial hair
        if identity.facialHairGroup ~= nil and identity.facialHairGroup ~= "" and
            string.find(v.image, "/" .. identity.facialHairGroup) ~= nil then
            identity.facialHairFolder, identity.facialHairType =
                string.match(v.image, '^.*/(' .. identity.facialHairGroup .. '.*)/(.*)%.png:.-$')
            identity.facialHairDirectives = self:filterReplace(v.image)
        end

        -- Attempt to find body identity
        if (string.find(v.image, "body.png") ~= nil) then
            identity.bodyDirectives = string.match(v.image, '%?replace.*')
        end

        -- Attempt to find emote identity
        if (string.find(v.image, "emote.png") ~= nil) then
            identity.emoteDirectives = self:filterReplace(v.image)
        end

        -- Attempt to find hair identity
        if (string.find(v.image, "/hair") ~= nil) then
            identity.hairFolder, identity.hairType = string.match(v.image, '^.*/(hair.*)/(.*)%.png:.-$')

            identity.hairDirectives = self:filterReplace(v.image)
        end
    end)

    return identity
end
