Sexbound.Common.SubGender = {}
Sexbound.Common.SubGender_mt = {
    __index = Sexbound.Common.SubGender
}

function Sexbound.Common.SubGender:new(parent)
    local _self = setmetatable({
        _parent = parent
    }, Sexbound.Common.SubGender_mt)

    if type(storage.sexbound.identity) ~= "table" then
        storage.sexbound.identity = {}
    end

    if _self:getSxbSubGender() == nil then
        _self:trySettingSubGenderFromStatusProperty()
    end

    _self:initMessageHandlers()

    return _self
end

function Sexbound.Common.SubGender:trySettingSubGenderFromStatusProperty()
    if status.statusProperty("sxbSubGender") ~= "default" then
        storage.sexbound.identity.sxbSubGender = status.statusProperty("sxbSubGender")
    end
end

function Sexbound.Common.SubGender:initMessageHandlers()
    message.setHandler("Sexbound:SubGender:Change", function(_, _, args)
        return self:handleSxbSubGenderChange(args)
    end)
end

function Sexbound.Common.SubGender:handleSxbSubGenderChange(args)
    local sxbSubGenderName = args
    self:setSxbSubGender(sxbSubGenderName)
    return self:getSxbSubGender()
end

function Sexbound.Common.SubGender:getSxbSubGender()
    return storage.sexbound.identity.sxbSubGender
end

function Sexbound.Common.SubGender:setSxbSubGender(sxbSubGenderName)
    self:updateSxbSubGenderMultiplier(sxbSubGenderName)

    storage.sexbound.identity.sxbSubGender = sxbSubGenderName

    status.statusProperty("sxbSubGender", sxbSubGenderName)
end

function Sexbound.Common.SubGender:updateSxbSubGenderMultiplier(sxbSubGenderName)
    local multipler = storage.sexbound.identity.sxbSubGenderMultiplier or 1

    if sxbSubGenderName == self:getSxbSubGender() then
        multipler = multipler + 1
    else
        multipler = 1
    end

    storage.sexbound.identity.sxbSubGenderMultiplier = multipler
end
