Sexbound.Common.Statistics = {}
Sexbound.Common.Statistics_mt = {
    __index = Sexbound.Common.Statistics
}

function Sexbound.Common.Statistics:new()
    return setmetatable({}, Sexbound.Common.Statistics_mt)
end

function Sexbound.Common.Statistics:init(parent)
    self._parent = parent
    storage.sexbound.statistics = storage.sexbound.statistics or {}
    self:initMessageHandlers()
end

function Sexbound.Common.Statistics:initMessageHandlers()
    message.setHandler("Sexbound:Statistics:Add", function(_, _, args)
        return self:handleAddStatistic(args)
    end)
end

function Sexbound.Common.Statistics:handleAddStatistic(args)
    return self:addStatistic(args.name, args.amount)
end

function Sexbound.Common.Statistics:addStatistic(name, amount)
    local statistics = copy(storage.sexbound.statistics)
    statistics[name] = (statistics[name] or 0) + amount
    storage.sexbound.statistics = statistics
    return storage.sexbound.statistics[name]
end

function Sexbound.Common.Statistics:getStatistic(name)
    return storage.sexbound.statistics[name]
end

function Sexbound.Common.Statistics:getStatistics()
    return storage.sexbound.statistics
end
