Sexbound.Common.Arousal = {}
Sexbound.Common.Arousal_mt = { __index = Sexbound.Common.Arousal }

--- Instantiates this class
function Sexbound.Common.Arousal:new()
    return setmetatable({
        _resourceName = "arousal"
    }, Sexbound.Common.Arousal_mt)
end

--- Initializes this instance
-- @param parent
function Sexbound.Common.Arousal:init(parent)
    self._parent = parent
    self._defaultConfig = { regenRates = { default = -0.33, havingSex = 1.0 } }
    self._config = config.getParameter("arousalConfig", self._defaultConfig)
    self._maxAmount = status.stat("maxArousal")
    self._regenRate = self._config.regenRates.default
    self:initMessageHandlers()
end

--- Updates this instance
-- @param dt
function Sexbound.Common.Arousal:update(dt)
    self:try(function()
        self:addAmount(self._regenRate * dt)
    end)
end

--- Sets value of Arousal resource to 0
-- @return a boolean value
function Sexbound.Common.Arousal:instaMin()
    local result = false
    self:try(function()
        self:setAmount(0)
        result = true
    end)
    return result
end

--- Sets value of Arousal resource to entity's defined maxArousal stat
-- @return a boolean value
function Sexbound.Common.Arousal:instaMax()
    local result = false
    self:try(function()
        self:setAmount(self._maxAmount)
        result = true
    end)
    return result
end

--- Reduces the value of this entity's arousal resource by specified percentage
-- @param percentage a decimal number. e.g. 0.1
-- @return a decimal number
function Sexbound.Common.Arousal:reduce(percentage)
    self:try(function()
        local maximumAmount = self:getMaxAmount()
        local currentAmount = self:getAmount() - (maximumAmount * percentage)
        self:setAmount(math.max(currentAmount, 0))
        return self:getAmount()
    end)
end

--- Returns boolean value to signify whether or not the arousal resource exists
-- @return a boolean value
function Sexbound.Common.Arousal:isResourceDefined()
    return status.isResource(self._resourceName)
end

--- Adds an amount to this entity's arousal resource
-- @param amount a decimal number
function Sexbound.Common.Arousal:addAmount(amount)
    status.modifyResource(self._resourceName, amount)
end

--- Returns the value of this entity's arousal resource
-- @return a decimal number
function Sexbound.Common.Arousal:getAmount()
    return status.resource(self._resourceName)
end

--- Sets an amount to this entity's arousal resource
-- @param amount a decimal number
function Sexbound.Common.Arousal:setAmount(amount)
    status.setResource(self._resourceName, amount)
end

--- Returns the value of this entity's maximum arousal resource stat
-- @return a decimal number
function Sexbound.Common.Arousal:getMaxAmount()
    return self._maxAmount
end

--- Returns a reference to the configuration of this class instance
-- @return a table
function Sexbound.Common.Arousal:getConfig()
    return self._config
end

--- Returns a reference to the parent of this class instance
-- @return a table
function Sexbound.Common.Arousal:getParent()
    return self._parent
end

--- Returns the value of this entity's regen rate for the arousal resource
-- @return a decimal number
function Sexbound.Common.Arousal:getRegenRate()
    return self._regenRate
end

--- Sets the value of this entity's regen rate as specified name key
-- @param name e.g. default, havingSex
function Sexbound.Common.Arousal:setRegenRate(name)
    self._regenRate = self._config.regenRates[name]
end

-- [Helper] Initializes message handlers
function Sexbound.Common.Arousal:initMessageHandlers()
    -- Legacy message handler: sexbound-max-arousal
    message.setHandler("sexbound-max-arousal", function(_, _, args)
        return self:instaMax()
    end)
    message.setHandler("Sexbound:Arousal:Max", function(_, _, args)
        return self:instaMax()
    end)
    message.setHandler("Sexbound:Arousal:Min", function(_, _, args)
        return self:instaMin()
    end)
    message.setHandler("Sexbound:Arousal:Reduce", function(_, _, args)
        return self:reduce(args.amount)
    end)
end

-- [Helper] Convience function to check existence of arousal resource before callback
-- @param callback
-- @return a boolean value
function Sexbound.Common.Arousal:try(callback)
    if not self:isResourceDefined() then return false end
    return callback()
end

-- [Deprecated] Returns a reference to the configuration of this class instance
-- @return a table
function Sexbound.Common.Arousal:config()
    return self:getConfig()
end

-- [Deprecated] Returns the value of this entity's regen rate for the arousal resource
-- @return a decimal number
function Sexbound.Common.Arousal:regenRate()
    return self:getRegenRate()
end
