--- Sexbound.Common Module.
-- @module Sexbound.Common
require "/scripts/messageutil.lua"
require "/scripts/util.lua"
require "/scripts/vec2.lua"
require "/scripts/sexbound/util.lua"
require "/scripts/stateMachine.lua"

Sexbound = Sexbound or {}
Sexbound.Common = {}
Sexbound.Common_mt = {
    __index = Sexbound.Common
}

function Sexbound.Common:new()
    return setmetatable({
        _configFilePath = "/sexbound.config",
        _notificationsFilePath = "/dialog/sexbound/<langcode>/notifications.config"
    }, Sexbound.Common_mt)
end

function Sexbound.Common:init(parent, entityType)
    storage.sexbound = storage.sexbound or {}

    self._parent = parent
    self._config = self:loadConfig()
    self._notifications = self:loadNotifications()

    self:loadSubscripts(entityType)

    status.setStatusProperty("sexbound_birthday", status.statusProperty("sexbound_birthday", "default"))
end

function Sexbound.Common:announceBirth()
    local plugins = self._notifications.plugins or {}
    local pregnant = plugins.pregnant or {}
    local message = pregnant.birthMessage1 or ""

    local birthData = storage.sexbound.birthData or {}
    local motherUuid = birthData.motherUuid

    local babyName = world.entityName(entity.id()) or "UNKNOWN"
    babyName = "^green;" .. babyName .. "^reset;"

    local babyGender = world.entityGender(entity.id())

    if babyGender == "male" then
        babyGender = "^blue;boy^reset;"
    end

    if babyGender == "female" then
        babyGender = "^pink;girl^reset;"
    end

    message = util.replaceTag(message, "babyname", babyName)

    message = util.replaceTag(message, "babygender", babyGender)

    if birthData.motherType == "player" and motherUuid then
        world.sendEntityMessage(motherUuid, "queueRadioMessage", {
            messageId = "Sexbound_Event:Birth",
            unique = false,
            text = message
        })
    end

    local motherName = birthData.motherName or "UNKNOWN"
    motherName = "^green;" .. motherName .. "^reset;"

    message = pregnant.birthMessage2 or ""
    message = util.replaceTag(message, "name", motherName)
    message = util.replaceTag(message, "babyname", babyName)
    message = util.replaceTag(message, "babygender", babyGender)

    for _, playerId in ipairs(world.players()) do
        if world.entityUniqueId(playerId) ~= motherUuid then
            world.sendEntityMessage(playerId, "queueRadioMessage", {
                messageId = "Sexbound_Event:Birth",
                unique = false,
                text = message
            })
        end
    end

    return true
end

function Sexbound.Common:loadConfig()
    local _, _config = xpcall(function()
        return root.assetJson(self._configFilePath)
    end, function(err)
        sb.logError("Failed to load Sexbound configuration: " .. self._configFilePath)
    end)

    return _config
end

function Sexbound.Common:loadNotifications()
    -- local _supportedLanguages = self._config.supportedLanguages or {}
    -- local _language = _supportedLanguages[self._config.defaultLanguage or "english"] or {}
    local _filePath = util.replaceTag(self._notificationsFilePath, "langcode", "en")

    local _, _notifications = xpcall(function()
        return root.assetJson(_filePath)
    end, function(err)
        sb.logError("Failed to load notifications configuration: " .. _filePath)
    end)

    return _notifications
end

function Sexbound.Common:loadSubscripts(entityType)
    local _override = self._config.override[entityType] or {}
    local _overrideDir = _override.overrideDir or "/scripts/sexbound/override"

    util.each(_override.scripts, function(_, _script)
        _script = util.replaceTag(_script, "overrideDir", _overrideDir)
        _script = util.replaceTag(_script, "entityGroup", entityType)

        require(_script)
    end)
end

function Sexbound.Common:failedTransformation()
    world.sendEntityMessage(entity.id(), "applyStatusEffect", "sexbound_obstructed")
end

function Sexbound.Common:restorePreviousStorage()
    local _statusPropertyName = "sexbound_previous_storage"

    if ("table" == type(status.statusProperty(_statusPropertyName))) then
        storage = util.mergeTable(storage, status.statusProperty(_statusPropertyName, {}))

        status.setStatusProperty(_statusPropertyName, "default")
    end
end

-- Getters/Setters
function Sexbound.Common:getConfig()
    return self._config
end
function Sexbound.Common:getParent()
    return self._parent
end
function Sexbound.Common:getNotifications()
    return self._notifications
end
