--- Sexbound.Positions Class Module.
-- @classmod Sexbound.Positions
-- @author Locuturus
-- @license GNU General Public License v3.0
Sexbound.Positions = {}
Sexbound.Positions_mt = {
    __index = Sexbound.Positions
}

if not SXB_RUN_TESTS then
    require("/scripts/sexbound/lib/sexbound/position.lua")
end

---Returns a reference to a new instance of this class.
-- @param parent
function Sexbound.Positions:new(parent)
    local _self = setmetatable({
        _index = 1,
        _logPrefix = "POSI",
        _parent = parent,
        _positionCount = 0,
        _positions = {}
    }, Sexbound.Positions_mt)

    Sexbound.Messenger.get("main"):addBroadcastRecipient(_self)

    _self._log = Sexbound.Log:new(_self._logPrefix, _self._parent:getConfig())
    _self:loadConfig(_self._parent:getConfig())
    _self:loadPositions(_self._parent:getConfig())
    _self:initMessageHandler()

    return _self
end

function Sexbound.Positions:initMessageHandler()
    message.setHandler("Sexbound:Actor:SwitchPosition", function(_, _, args)
        local stateMachine = self:getParent():getStateMachine()

        if not stateMachine:isClimaxing() and not stateMachine:isReseting() then
            self:switchPosition(args.positionId)
            return true
        end

        return false
    end)
end

--- Loads and returns positions config.
function Sexbound.Positions:loadConfig(sexboundConfig)
    local _, _config = xpcall(function()
        return root.assetJson(sexboundConfig.position.configFile or "/positions/positions.config")
    end, function(error)
        self:getLog():error("Unable to load positions config file!")
    end)

    self._config = _config or {}
end

--- Returns loaded Sex Positions as a table.
function Sexbound.Positions:loadPositions(sexboundConfig)
    for _, v in ipairs(sexboundConfig.position.sex or {}) do
        local _, _config = nil, nil

        _, _config = xpcall(function()
            return root.assetJson(self._config[v].configFile or "/positions/standing.config")
        end, function(error)
            self:getLog():error("Unable to load position config file: " .. self._config[v].configFile)
        end)

        _, _config = xpcall(function()
            if _config and _config.base and self._config[_config.base] then
                _config = util.mergeTable(root.assetJson(self._config[_config.base].configFile), _config)
            end

            return _config
        end, function(error)
            self:getLog():error("Unable to merge with base position config file: " ..
                                    self._config[_config.base].configFile)
        end)

        if type(_config) == "table" then
            table.insert(self._positions, Sexbound.Position:new(_config))

            self._positionCount = self._positionCount + 1
        end
    end
end

function Sexbound.Positions:nextPosition()
    self._index = self._index + 1

    self:switchPosition(self._index)
end

function Sexbound.Positions:previousPosition()
    self._index = self._index - 1

    self:switchPosition(self._index)
end

function Sexbound.Positions:resetIndex()
    self._index = 1
end

--- Switches to the specified position.
-- @param index
function Sexbound.Positions:switchPosition(index)
    self._index = util.wrap(index, 1, self._positionCount)

    local actors = {}
    for _, actor in ipairs(self._parent._actors) do
        table.insert(actors, {
            name = actor:getName(),
            uniqueId = actor:getUniqueId()
        })
    end

    Sexbound.Messenger.get("main"):broadcast(self, "Sexbound:Event:Create", {
        eventName = "POSITION_SWITCHED",
        eventArgs = {
            actors = actors,
            position_name = self:getCurrentPosition():getConfig().name
        }
    })

    local stateMachine = self:getParent():getStateMachine()
    local stateName = stateMachine:stateDesc()

    if not stateName or stateName == "nullState" then
        return
    end

    local animationState = self:getCurrentPosition():getAnimationState(stateName)

    stateName = animationState:getStateName()

    -- Set new animation state to match the position.
    animator.setAnimationState("props", stateName, true)
    animator.setAnimationState("actors", stateName, true)

    self:getParent():resetAllActors()

    -- Send undelayed broadcast
    Sexbound.Messenger.get("main"):broadcast(
        self,
        "Sexbound:Positions:SwitchPosition",
        self:getCurrentPosition(),
        false
    )
end

function Sexbound.Positions:switchRandomSexPosition()
    local randomIndex = util.randomIntInRange({1, self._positionCount})

    self:switchPosition(randomIndex)
end

--- Returns a reference to the Positions Configuration.
function Sexbound.Positions:getConfig()
    return self._config
end

function Sexbound.Positions:getLog()
    return self._log
end

function Sexbound.Positions:getLogPrefix()
    return self._logPrefix
end

function Sexbound.Positions:getIndex()
    return self._index
end

--- Returns a reference to the Current Position.
function Sexbound.Positions:getCurrentPosition()
    return self._positions[self._index]
end

function Sexbound.Positions:getParent()
    return self._parent
end

--- Returns a reference to the Positions.
function Sexbound.Positions:getPositions()
    return self._positions
end
