--- Sexbound.Position Class Module.
-- @classmod Sexbound.Position
-- @author Locuturus
-- @license GNU General Public License v3.0
Sexbound.Position = {}
Sexbound.Position_mt = {
    __index = Sexbound.Position
}

if not SXB_RUN_TESTS then
    require("/scripts/sexbound/lib/sexbound/position/animationstate.lua")
end

---Returns a reference to a new instance of this class.
-- @param positionConfig
function Sexbound.Position:new(positionConfig)
    local _self = setmetatable({
        _config = positionConfig
    }, Sexbound.Position_mt)

    _self._animationStates = Sexbound.Position.AnimationState:new(_self, _self._config.animationState)

    return _self
end

--- Returns the animation state for the specied state machine state.
-- @param stateName
function Sexbound.Position:getAnimationState(stateName)
    if stateName then
        return self._animationStates:getStates()[stateName]
    end

    return self._animationStates:getStates()
end

--- Returns a reference to this instance's position config.
function Sexbound.Position:getConfig()
    return self._config
end

--- Returns this position's button image path as a string.
function Sexbound.Position:getButton()
    local configPath = self:getConfig().button or "/interface/sexbound/sexui/submodule/positions/buttons.config:default"

    local buttonsConfig = util.split(configPath, ":")

    local _, result = xpcall(function()
        return root.assetJson(buttonsConfig[1])[buttonsConfig[2]]
    end, function(err)
        sb.logError("Unable to load position button.")
    end)

    return result
end

function Sexbound.Position:getClimaxConfig(role, gender)
    local climaxConfig = self._config.climaxConfig or {}

    if nil ~= role then
        climaxConfig = climaxConfig[role] or {}
    end
    if nil ~= gender then
        climaxConfig = climaxConfig[gender] or {}
    end

    return climaxConfig
end

function Sexbound.Position:getClimaxParticleName(role, gender)
    local climaxConfig = self._config.climaxConfig or {}

    if nil ~= role then
        climaxConfig = climaxConfig[role] or {}
    end
    if nil ~= gender then
        climaxConfig = climaxConfig[gender] or {}
    end

    return climaxConfig.particleName
end

function Sexbound.Position:getClimaxProjectileName(role, gender)
    local climaxConfig = self._config.climaxConfig or {}

    if nil ~= role then
        climaxConfig = climaxConfig[role] or {}
    end
    if nil ~= gender then
        climaxConfig = climaxConfig[gender] or {}
    end

    return climaxConfig.projectileName
end

function Sexbound.Position:getConstantScale(index)
    local constantScale = self._config.constantScale or {}

    if index == nil then
        return constantScale
    end

    return constantScale[index]
end

function Sexbound.Position:getContainerOverlay(index)
    local containerOverlay = self._config.containerOverlay or {}

    if index == nil then
        return containerOverlay
    end

    return containerOverlay[index]
end

--- Returns a reference to this instance's dialog config.
-- @param species
-- @param default
function Sexbound.Position:getDialog(species, default)
    local dialog = self:getConfig().dialog or {}

    if species then
        return dialog[species] or default
    end

    return self:getConfig().dialog
end

--- Returns the friendly name of this instance.
function Sexbound.Position:getFriendlyName()
    return self:getConfig().friendlyName
end

--- Returns the maxAllowedActors of this instance.
function Sexbound.Position:getMaxAllowedActors()
    return self:getConfig().maxAllowedActors
end

--- Returns the minRequiredActors of this instance.
function Sexbound.Position:getMinRequiredActors()
    return self:getConfig().minRequiredActors
end

--- Returns the name of this instance.
function Sexbound.Position:getName()
    return self:getConfig().name
end
