require "/interface/sexbound/sexui/submodule.lua"

SexUI.POV = SexUI.Submodule.new()
SexUI.POV_mt = {
    __index = SexUI.POV
}

require "/interface/sexbound/sexui/submodule/pov/part.lua"

--- Instantiates a new instance
-- @param parant the parent instance
-- @param config a table of config options
function SexUI.POV.new(parent, config)
    local self = setmetatable({
        animationCycle = config.animationCycle or 1,
        animationRate = 1,
        animationTimer = 0,
        frameCount = config.frameCount or 5,
        frameIndex = 1,
        frameName = "",
        parts = {},
        penetrationType = 1
    }, SexUI.POV_mt)

    self:init(parent, config)
    self.canvas = widget.bindCanvas("pov")
    return self
end

--- Renders the animation parts managed by this instance
function SexUI.POV:render()
    self.canvas:clear()

    if isEmpty(self.parts) then
        return
    end

    local frame = self.frameName .. "." .. self.frameIndex

    self.canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
    self.parts.actor1Body:render(self.canvas, frame)
    self.parts.actor1Genital:render(self.canvas, frame)
    self.parts.actor2Body:render(self.canvas, frame)
    self.parts.actor1LHand:render(self.canvas, frame)
    self.parts.actor1RHand:render(self.canvas, frame)
    self.parts.actor1BodyOverlay:render(self.canvas, frame)
    self.canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
    -- self.canvas:drawImage(self._config.recordFXImage, {0,0}, 1.0, "white", false)
end

--- Updates this instance
-- @param dt
function SexUI.POV:update(dt)
    self.animationTimer = self.animationTimer + dt

    local cycle = self.animationCycle / self.animationRate
    self.frameIndex = util.clamp(math.ceil(self.animationTimer / cycle * self.frameCount), 1, self.frameCount)

    if (self.animationTimer >= cycle) then
        self.animationTimer = 0
    end
end

--- Updates animation parts for each actor
-- @param a table of actors
function SexUI.POV:updateParts(actors)
    self.parts = {}
    self.partDirectives = {}

    if isEmpty(actors or {}) or #actors <= 1 then
        return
    end

    self:updatePenetrationType(actors)
    self:updatePartsForActor1(actors[1])
    self:updatePartsForActor2(actors[2])

    if not self.parts.actor1Body:checkImageExists() or not self.parts.actor2Body:checkImageExists() then
        self.parts = {}
        self.partDirectives = {}
        self.frameName = ""
        return
    end

    self.frameName = actors[1].frameName
end

--- Updates animation parts for Actor1
-- @param actor an actor table
function SexUI.POV:updatePartsForActor1(actor)
    self.actor1HandLVariantIndex = 1
    self.actor1HandRVariantIndex = 1

    actor.gender = actor.bodyType
    self.parts.actor1Body = SexUI.POV.Part.new(actor, "body")
    self.parts.actor1BodyOverlay = SexUI.POV.Part.new(actor, "body_overlay")
    self.parts.actor1LHand = SexUI.POV.Part.new(actor, "hand_l_variant" .. self.actor1HandLVariantIndex)
    self.parts.actor1RHand = SexUI.POV.Part.new(actor, "hand_r_variant" .. self.actor1HandRVariantIndex)

    actor.gender = actor.genitalType
    self.parts.actor1Genital = SexUI.POV.Part.new(actor, "genital")
end

--- Updates animation parts for Actor 2
-- @param actor an actor table
function SexUI.POV:updatePartsForActor2(actor)
    actor.gender = actor.bodyType
    self.parts.actor2Body = SexUI.POV.Part.new(actor, "body_penetration" .. self.penetrationType)
end

--- Updates the penetration type according to the genital type of actor 1 and 2
-- @param actors a table of actors
function SexUI.POV:updatePenetrationType(actors)
    -- genital type 0 = male; genital type 1 = female
    if actors[1].genitalType == 1 then
        self.penetrationType = 1
        return
    end
    if actors[1].genitalType == 0 and actors[2].genitalType == 1 then
        self.penetrationType = 2
        return
    end
    if actors[1].genitalType == 1 and actors[2].genitalType == 1 then
        self.penetrationType = 3
        return
    end
    self.penetrationType = 1
end

--- Sets animation rate to the specified value
-- @param animationRate a decimal number
function SexUI.POV:setAnimationRate(animationRate)
    self.animationRate = animationRate
end

--- Returns a reference to the UI canvas
function SexUI.POV:getCanvas()
    return self.canvas
end
