require "/interface/sexbound/sexui/submodule.lua"

SexUI.Positions = SexUI.Submodule.new()
SexUI.Positions_mt = { __index = SexUI.Positions }

--- Instantiantes a new instance.
-- @param config
function SexUI.Positions.new(parent, _config)
  local _self = setmetatable({}, SexUI.Positions_mt)

  _self:init(parent, _config)
  _self._canvas = widget.bindCanvas("positions")
  return _self
end

function SexUI.Positions:render()
  self._canvas:clear()

  -- Draw the background image for 'positions'.
  self._canvas:drawImage(self._config.backgroundImage, {129,129}, 1.0, self._config.color, true)

  self:renderButtons(self._canvas)
end

function SexUI.Positions:update(dt)
  self:updateAlphaForAllImages(self:getParent()._globalAlpha)
end

function SexUI.Positions:updateAlphaForAllImages(alpha)
  self._config.color[4] = math.min(self._config.fadeInAlpha, alpha)
  self._config.colorButtons[4] = alpha
end
