require("/interface/sexbound/common/custombutton.lua")

SexUI.Submodule = {}
SexUI.Submodule_mt = {
    __index = SexUI.Submodule
}

--- Instantiantes a new instance.
-- @param config
function SexUI.Submodule.new()
    return setmetatable({}, SexUI.Submodule_mt)
end

function SexUI.Submodule:init(...)
    local args = {...}

    self._parent = args[1]

    self._config = args[2]

    for index, button in ipairs(self._config.buttons) do
        self._parent._buttons[button.key or index] = CustomButton.new(button)
    end
end

function SexUI.Submodule:renderButtons(canvas)
    canvas = canvas or self._canvas

    self:getParent():forEachButton(function(_, button)
        -- Draw hover image first
        if button.isHovered and button:hoverImage() then
            canvas:drawImage(button:hoverImage(), button:hoverImagePosition() or {129, 129}, 1.0, {255, 255, 255, 128},
                true)
        end

        if button:enabled() then
            if button:value() and button:image() then
                canvas:drawImage(button:image() .. button:directives(), button:imagePosition(), 1.0,
                    self._config.colorButtons, true)
            elseif button:altImage() then
                canvas:drawImage(button:altImage() .. button:directives(), button:imagePosition(), 1.0,
                    self._config.colorButtons, true)
            end
        else
            if button:disabledImage() then
                canvas:drawImage(button:disabledImage() .. button:directives(), button:imagePosition(), 1.0,
                    self._config.colorButtons, true)
            end
        end

        -- Draw debug lines when enabled
        if self:getParent()._debug then
            button:drawPoly(canvas)
            button:drawBoundingBox(canvas)
        end
    end)
end

function SexUI.Submodule:update(dt)

end

function SexUI.Submodule:render()

end

function SexUI.Submodule:updateAlphaForAllImages(alphaValue)

end

function SexUI.Submodule:getConfig()
    return self._config
end

function SexUI.Submodule:getParent()
    return self._parent
end
