Customizer = {}
Customizer_mt = { __index = Customizer }

require "/interface/sexbound/customizer/customizergeneral.lua"
require "/interface/sexbound/customizer/customizeraddonmods.lua"
require "/interface/sexbound/customizer/customizerstatistics.lua"
require "/interface/sexbound/customizer/customizercredits.lua"

--- Instantiantes a new instance.
-- @param config
function Customizer.new()
  local self = setmetatable({
    tabs = {}
  }, Customizer_mt)

  return self
end

--- Init. all underlying classes
function Customizer:init()
  for _,button in ipairs(config.getParameter("gui.selectTab.buttons")) do
    local controller = Customizer[button.data.className]:new()

    if controller then
      table.insert(self.tabs, {
        name       = button.data.className,
        controller = controller
      })
    end
  end

  for _,tab in ipairs(self.tabs) do
    tab.controller:init()
  end
end

function Customizer:update(dt)
  for _,tab in ipairs(self.tabs) do
    tab.controller:update(dt)
  end
end

function Customizer:broadcast(message)
  for _,tab in ipairs(self.tabs) do
    tab.controller:handleMessage(message)
  end
end