require "/scripts/stateMachine.lua"

--- AphroditesStatue Class Module.
-- @classmod AphroditesStatue
-- @author Loxodon
AphroditesStatue = {}
AphroditesStatue_mt = {__index = AphroditesStatue}

function AphroditesStatue:new()
  local self = setmetatable({
    _dialog = config.getParameter("dialog"),
    _dialogCooldown = config.getParameter("dialogCooldown"),
    _isSummoned = false,
    _isFinished = false,
    _states = { "idleState", "enterSummonState", "exitSummonState" },
    _timer = 0,
    _blabberTimer = 0
  }, AphroditesStatue_mt)
  
  return self
end

function AphroditesStatue:init()
  self._timer = self._dialogCooldown
  self._dialogIndex = 1
  self._nextDialog = self._dialog[self._dialogIndex]

  self._stateDefinitions = {
    idleState = {
      enter = function()
        if not self._isSummoned then
          return {}
        end
      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._isSummoned then
          return true
        end
      end
    },
    
    enterSummonState = {
      enter = function()
        if self._isSummoned and not self._isFinished then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        -- animator.burstParticleEmitter("poof")
        
        self:enablePlatform()
        
        self:spawnAphrodite()
        
        animator.setAnimationState("main",  "off", true)
        
        animator.setAnimationState("actor", "on", true)
      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._isFinished then
          return true
        end
        
        self:processDialog(dt)
      end
    },
    
    exitSummonState = {
      enter = function()
        if self._isSummoned and self._isFinished then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.setAnimationState("actor", "off", true)
        
        if self.aphroditeId then
          world.callScriptedEntity(self.aphroditeId, "status.removeEphemeralEffect", "aphrodite_stun")
          world.callScriptedEntity(self.aphroditeId, "status.removeEphemeralEffect", "aphrodite_invisible")
          
          world.sendEntityMessage(self.aphroditeId, "notify", {type = "exitSummon"})
        end
      end,
      
      update = function(dt, stateData)
        -- Just loop forever
      end
    }
  }
  
  self._stateMachine = stateMachine.create(self._states, self._stateDefinitions)
end

function AphroditesStatue:update(dt)
  self._stateMachine.update(dt)
  
  if animator.animationState("actorEmote") == "blabber" then
    self._blabberTimer = self._blabberTimer + dt
    
    if self._blabberTimer >= 3 then
      animator.setAnimationState("actorEmote", "none")
      
      self._blabberTimer = 0
    end
  end
end

function AphroditesStatue:enablePlatform()
  local enableCollision = config.getParameter("enableCollision")
  
  if enableCollision then
    physics.setCollisionEnabled(enableCollision, true)
  end
end

function AphroditesStatue:processDialog(dt)
  self._timer = self._timer + dt

  if self._timer >= self._dialogCooldown then
    object.say(self._nextDialog)
    
    animator.setAnimationState("actorEmote", "blabber", true)
    
    self._blabberTimer = 0
    
    if self._dialogIndex == #self._dialog then
      self._isFinished = true
    else
      self._dialogIndex = self._dialogIndex + 1
    end
    
    self._nextDialog = self._dialog[self._dialogIndex]

    self._timer = 0
  end
end

function AphroditesStatue:spawnAphrodite()
  local spawnPosition = entity.position()

  spawnPosition[2] = spawnPosition[2] + 5
  
  self.aphroditeId = world.spawnNpc(spawnPosition, "human", "aphroditegogo", 5.0, nil, {
    scriptConfig = {
      handmaidenConfig = storage.handmaidenConfig
    }
  })
  
  if self.aphroditeId then
    world.callScriptedEntity(self.aphroditeId, "status.addEphemeralEffect", "aphrodite_stun")
    world.callScriptedEntity(self.aphroditeId, "status.addEphemeralEffect", "aphrodite_invisible")
    world.callScriptedEntity(self.aphroditeId, "status.addEphemeralEffect", "beamin")
  end
end

function init()
  self.A = AphroditesStatue:new()

  self.A:init()
  
  object.setInteractive(config.getParameter("interactive"))
  
  message.setHandler("summon", function(_,_,args)
    summon(args)
  end)
end

function update(dt)
  self.A:update(dt)
end

-- Only used for testing
function onInteraction(args)
  summon(args)
end

function summon(args)
  self.A._isSummoned = true
  
  storage.handmaidenConfig = {
    isPregnant = args.isPregnant
  }
end