require "/scripts/stateMachine.lua"

--- CrystalHidden Class Module.
-- @classmod Platform
-- @author Loxodon
CrystalHidden = {}
CrystalHidden_mt = {__index = CrystalHidden}

function CrystalHidden:new()
  local self = setmetatable({
    _states = { "closedState", "closeState", "openedState", "openState" }
  }, CrystalHidden_mt)
  
  return self
end

function CrystalHidden:init()
  self:initMessageHandlers()

  -- object.setInteractive(true)

  self._status = "closed"

  self._stateDefinitions = {
    closedState = {
      enter = function()
        if self._status == "closed" then
          return {}
        end
      end,
      
      enteringState = function(stateData)

      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "closed" then
          return true
        end
      end
    },
    
    closeState = {
      enter = function()
        if self._status == "closing" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.setAnimationState("main", "close", true)
      end,
      
      update = function(dt, stateData)
        if animator.animationState("main") == "closed" then
          self._status = "closed"
        end
      
        -- Exit condition
        if self._status ~= "closing" then
          return true
        end
      end
    },
    
    openedState = {
      enter = function()
        if self._status == "opened" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        local position = entity.position()
        
        position[2] = position[2] + 1
      
        local dungeonId = world.dungeonId(position)

        local params = {
          holeId = entity.id()
        }
        
        if world.isTileProtected(position) then
          world.setTileProtection(dungeonId, false)
          
          world.placeObject("aphroditespowercrystal", position, 1, params)
          
          world.setTileProtection(dungeonId, true)
        else
          world.placeObject("aphroditespowercrystal", position, 1, params)
        end
      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "opened" then
          return true
        end
      end
    },
    
    openState = {
      enter = function()
        if self._status == "opening" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.setAnimationState("main", "open", true)
      end,
      
      update = function(dt, stateData)
        if animator.animationState("main") == "opened" then
          self._status = "opened"
        end
      
        -- Exit condition
        if self._status ~= "opening" then
          return true
        end
      end
    }
  }
  
  self._stateMachine = stateMachine.create(self._states, self._stateDefinitions)
end

function CrystalHidden:initMessageHandlers()
  message.setHandler("close", function(_,_,args)
    self._status = "closing"
  end)

  message.setHandler("open", function(_,_,args)
    self._status = "opening"
  end)
end

function CrystalHidden:handleOnInteraction(args)
  
end

function CrystalHidden:update(dt)
  self._stateMachine.update(dt)
end

function CrystalHidden:setStatus(name)
  self._status = name
end

-- Object hooks

function init()
  self.C = CrystalHidden:new()
  
  self.C:init()
end

function update(dt)
  self.C:update(dt)
end

function onInteraction(args)
  self.C:handleOnInteraction(args)
end