require "/scripts/util.lua"

function init()
  self.maxHealth = config.getParameter("health")
  
  self.currentHealth = self.maxHealth

  self.hueShift = config.getParameter("maxHueShift")
end

function die()
  local holeId = config.getParameter("holeId")

  if holeId then
    world.sendEntityMessage(holeId, "close")
  end
  
  world.sendEntityMessage("aphroditesdancetable", "destroypowercrystal")
end

function update(dt)
  if self.currentHealth ~= object.health() then
    self.currentHealth = object.health()

    animator.setGlobalTag("crystalColor", "?hueshift=" .. util.lerp(1 - self.currentHealth / self.maxHealth, 0, self.hueShift))
  end
end

function getHealthPercentage()
  return object.health() / self.maxHealth
end