--- Platform Class Module.
-- @classmod Platform
-- @author Loxodon
Platform = {}
Platform_mt = {__index = Platform}

function Platform:new()
  local self = setmetatable({
    _upperLimit = 6,
    _lowerLimit = 0,
    _pos = 0,
    _lowerSpeed = 2,
    _raiseSpeed = 2,
    _states = { "loweredState", "raisedState", "loweringState", "raisingState" }
  }, Platform_mt)
  
  return self
end

function Platform:init()
  self._status = "lowered"

  self._stateDefinitions = {
    loweredState = {
      enter = function()
        if self._status == "lowered" then
          return {}
        end
      end,
      
      enteringState = function(stateData)

      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "lowered" then
          return true
        end
      end
    },
    
    loweringState = {
      enter = function()
        if self._status == "lowering" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.playSound("platformLoop", -1)
      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "lowering" then
          return true
        end
        
        if self._pos > self._lowerLimit then
          self:lower(dt)
        else
          self._status = "lowered"
        end
      end,
      
      leavingState = function(stateData)
        animator.stopAllSounds("platformLoop")
      end
    },
    
    raisedState = {
      enter = function()
        if self._status == "raised" then
          return {}
        end
      end,
      
      enteringState = function(stateData)

      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "raised" then
          return true
        end
      end
    },
    
    raisingState = {
      enter = function()
        if self._status == "raising" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.playSound("platformLoop", -1)
      end,
      
      update = function(dt, stateData)
        -- Exit condition
        if self._status ~= "raising" then
          return true
        end
        
        if self._pos < self._upperLimit then
          self:raise(dt)
        else
          self._status = "raised"
        end
      end,
      
      leavingState = function(stateData)
        animator.stopAllSounds("platformLoop")
      end
    }
  }
  
  self._stateMachine = stateMachine.create(self._states, self._stateDefinitions)
end

function Platform:update(dt)
  self._stateMachine.update(dt)
end

function Platform:lower(dt)
  local amount = -self._lowerSpeed * dt
  
  self._pos = self._pos + amount
  
  animator.translateTransformationGroup("platform", {0, amount})
end

function Platform:raise(dt)
  local amount = self._raiseSpeed * dt
  
  self._pos = self._pos + amount
  
  animator.translateTransformationGroup("platform", {0, amount})
end

function Platform:getPosition()
  return self._pos
end

function Platform:setStatus(name)
  self._status = name
end