require "/scripts/util.lua"

--- Platform Class Module.
-- @classmod Platform
-- @author Loxodon
Flamethrower = {}
Flamethrower_mt = {__index = Flamethrower}

function Flamethrower:new( parent )
  local self = setmetatable({
    _entityId = entity.id(),
    _parent = parent,
    _states = { "offState", "onState" },
    _status = "off",
    _timers = {}
  }, Flamethrower_mt)
  
  return self
end

function Flamethrower:init()
  self:setTimer("flame", 0)

  self._stateDefinitions = {
    offState = {
      enter = function()
        if self._status == "off" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.setGlobalTag("fauxActorFrameName", "rock")
      
        animator.setAnimationState("flamethrower", "off")
        
        animator.stopAllSounds("fireLoop")
        
        animator.playSound("fireEnd")
      end,
      
      update = function(dt, stateData)
        -- Exit condidtion
        if self._status ~= "off" then
          return true
        end
      end
    },
    
    onState = {
      enter = function()
        if self._status == "on" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        animator.setGlobalTag("fauxActorFrameName", "flamethrower")
      
        animator.setAnimationState("flamethrower", "on")
        
        animator.playSound("fireStart")
      
        animator.playSound("fireLoop", -1)
      end,
      
      update = function(dt, stateData)
        -- Exit condidtion
        if self._status ~= "on" then
          return true
        end
        
        -- Update on state here
        self:trySpawnFlameProjectile(dt)
      end
    }
  }
  
  self._stateMachine = stateMachine.create(self._states, self._stateDefinitions)
end

function Flamethrower:update(dt)
  self._stateMachine.update(dt)
end

function Flamethrower:trySpawnFlameProjectile(dt)
  self:addToTimer("flame", dt)
  
  local position = object.toAbsolutePosition(animator.partPoint("flamethrowerSpawnPoint", "offset"))

  if self:getTimer("flame") >= 0.02 then
    world.spawnProjectile("aphroditeflamethrower", position, self._entityId, self._parent:aimVector(0.05))
  
    self:setTimer("flame", 0)
  end
end

function Flamethrower:addToTimer(name, amount)
  self._timers[name] = self._timers[name] + amount
end

function Flamethrower:setTimer(name, value)
  self._timers[name] = value
end

function Flamethrower:getTimer(name)
  return self._timers[name]
end

function Flamethrower:getStatus()
  return self._status
end

function Flamethrower:setStatus(name)
  self._status = name
end