require "/scripts/vec2.lua"
require "/scripts/util.lua"

--- Platform Class Module.
-- @classmod Platform
-- @author Loxodon
Arena = {}
Arena_mt = {__index = Arena}

function Arena:new( parent )
  local self = setmetatable({
    _config = root.assetJson(config.getParameter("arenaConfig")),
    _difficulty = 1,
    _attackType = 1,
    _nextAction = 1,
    _parent = parent,
    _states = { "wait", "attackSeq1" },
    _timers = {}
  }, Arena_mt)
  
  self._actionDef = self._config.actions
  
  return self
end

function Arena:init()
  self:setTimer("action", 0)

  self._status = "wait"

  self._stateDefinitions = {
    wait = {
      enter = function()
        if self._status == "wait" then
          return {}
        end
      end,
      
      update = function(dt, stateData)
        -- Exit condidtion
        if self._status ~= "wait" then
          return true
        end
      end
    },
    
    attackSeq1 = {
      enter = function()
        if self._status == "attack" then
          return {}
        end
      end,
      
      enteringState = function(stateData)
        self:chooseNextAction()
      end,
      
      update = function(dt, stateData)
        -- Exit condidtion
        if self._status ~= "attack" then
          return true
        end
        
        self:addTimer("action", dt)
        
        local next = self._actionDef[self._difficulty][self._attackType][self._nextAction]
        
        if self:getTimer("action") >= next.atTime then
          self:runActions(next)
        end
      end
    }
  }
  
  self._stateMachine = stateMachine.create(self._states, self._stateDefinitions)
end

function Arena:attack(args)
  local params = {
    actionOnReap = {
      [1] = {
        action = "config",
        file   = "/projectiles/explosions/aphroditeshrapnel/aphroditeshrapnel.config"
      }
    },
    damageTeam = { 
      type = "enemy",
      team = 2
    }
  }
  
  local absPosition = vec2.add(entity.position(), args[1])
  
  -- world.spawnProjectile(util.randomChoice(self._config.projectiles), args[1], entity.id(), vec2.rotate({1, 0}, util.toRadians(270)), false, params) -- Shoot down always
  
  world.spawnProjectile(util.randomChoice(self._config.projectiles), absPosition, entity.id(), vec2.rotate({1, 0}, util.toRadians(270)), false) -- Things affected by gravity delay falling slightly
end

function Arena:chooseNextAction()
  if self._nextAction ~= #self._actionDef[self._difficulty][self._attackType] then
    self._nextAction = math.min(self._nextAction + 1, #self._actionDef[self._difficulty][self._attackType])
  else
    self._nextAction = 1
    self:setTimer("action", 0)
    self._difficulty = util.randomIntInRange({1, self._parent._stage})
    self._attackType = util.randomIntInRange({1, #self._actionDef[self._difficulty]})
  end
end

function Arena:runActions(next)
  for _,action in ipairs(next.actions) do
    self[action.name](self, action.args)
  end
  
  self:chooseNextAction()
end

function Arena:update(dt)
  self._stateMachine.update(dt)
end

function Arena:addTimer(name, amount)
  self._timers[name] = self._timers[name] + amount
end

function Arena:setTimer(name, value)
  self._timers[name] = value
end

function Arena:getTimer(name)
  return self._timers[name]
end

function Arena:setStatus(name)
  self._status = name
end