require('/scripts/util.lua')

function init()
  self.spawnItemNames = config.getParameter("spawnItemNames", {})
  self.requirePlayerWithinRadius = config.getParameter("requirePlayerWithinRadius", 20)
  self.timeout = config.getParameter("spawnTimeout", 120)

  self.timer = self.timeout
end

function update(dt)
  if isEmpty(world.playerQuery(entity.position(), self.requirePlayerWithinRadius)) then return end

  self.timer = self.timer + dt

  if self.timer < self.timeout then return end

  self.timer = 0

  tryAddingItemToContainer()
end

function tryAddingItemToContainer()
  local nextItem = util.randomChoice(self.spawnItemNames)

  local item = { name = nextItem, parameters = {}, count = 1 }

  if not world.containerItemsCanFit(entity.id(), item) then return end

  world.containerAddItems(entity.id(), item)
end