require "/scripts/sexbound/v2/api.lua"
require "/scripts/util.lua"
require "/scripts/messageutil.lua"

function init()
  self.myPromises = PromiseKeeper.new()

  Sexbound.API.init()
  
  local sitPositions  = config.getParameter("sexboundConfig.sitPositions",  {{0,0},{0,0}})
  
  local nodePositions = config.getParameter("sexboundConfig.nodePositions", {{0,0},{0,0}})
  
  Sexbound.API.Nodes.addNode(nodePositions[1], sitPositions[1]) -- Add Node #1
  Sexbound.API.Nodes.addNode(nodePositions[2], sitPositions[2]) -- Add Node #2
  
  message.setHandler("summon", function(_,_,args) 
    world.sendEntityMessage("aphroditesstatue", "summon", {isPregnant = storage.isPregnant})
  end)
end

function update(dt)
  self.myPromises:update()

  Sexbound.API.update(dt)
end

function onInteraction(args)
  -- Check if player has started or completed the 'summonaphrodite' quest
  if args.sourceId then
    self.myPromises:add(world.sendEntityMessage(args.sourceId, "Aphrodite:hasQuest", {name = "summonaphrodite"}), function(result)
      if result then world.sendEntityMessage("handmaiden", "notify", {type = "sexbound.becomeAroused"}) end
    end)
  end
  
  animator.setAnimationState("indicator", "off", true)
  
  return Sexbound.API.handleInteract(args)
end

function uninit()
  Sexbound.API.uninit()
end
