require "/scripts/vec2.lua"
require "/scripts/util.lua"

TeleportAphroditesRetreat = WeaponAbility:new()

function TeleportAphroditesRetreat:init()
  self.elementalType = self.elementalType or self.weapon.elementalType

  self.stances = config.getParameter("stances")

  self.weapon:setStance(self.stances.idle)

  self.weapon.onLeaveAbility = function()
    self:reset()
  end
end

function TeleportAphroditesRetreat:update(dt, fireMode, shiftHeld)
  WeaponAbility.update(self, dt, fireMode, shiftHeld)

  if self.fireMode == (self.activatingFireMode or self.abilitySlot)
    and not self.weapon.currentAbility
    and not world.lineTileCollision(mcontroller.position(), self:firePosition())
    and not status.resourceLocked("energy") then

    self:setState(self.charge)
  end
end

function TeleportAphroditesRetreat:charge()
  self.weapon:setStance(self.stances.charge)

  animator.playSound(self.elementalType.."charge")
  animator.setAnimationState("charge", "charge")
  animator.setParticleEmitterActive(self.elementalType .. "charge", true)

  local chargeTimer = self.stances.charge.duration
  while chargeTimer > 0 and self.fireMode == (self.activatingFireMode or self.abilitySlot) do
    chargeTimer = chargeTimer - self.dt

    mcontroller.controlModifiers({runningSuppressed=true})

    status.setResourcePercentage("energyRegenBlock", 1.0)

    coroutine.yield()
  end

  animator.stopAllSounds(self.elementalType.."charge")

  if chargeTimer <= 0 then
    self:setState(self.charged)
  else
    animator.playSound(self.elementalType.."discharge")
    self:setState(self.cooldown)
  end
end

function TeleportAphroditesRetreat:charged()
  self.weapon:setStance(self.stances.charged)

  animator.playSound(self.elementalType.."fullcharge")
  animator.playSound(self.elementalType.."chargedloop", -1)
  animator.setParticleEmitterActive(self.elementalType .. "charge", true)

  animator.stopAllSounds(self.elementalType.."chargedloop")

  self:setState(self.discharge)
end

function TeleportAphroditesRetreat:discharge()
  self.weapon:setStance(self.stances.discharge)
  
  player.warp("instanceworld:aphroditesretreat", "beam")
  
  self:setState(self.cooldown)
end

function TeleportAphroditesRetreat:cooldown()
  self.weapon:setStance(self.stances.cooldown)

  animator.setAnimationState("charge", "discharge")

  util.wait(self.stances.cooldown.duration, function()

  end)
end

function TeleportAphroditesRetreat:firePosition()
  return vec2.add(mcontroller.position(), activeItem.handPosition(animator.partPoint("stone", "focalPoint")))
end

function TeleportAphroditesRetreat:reset()
  self.weapon:setStance(self.stances.idle)
  animator.stopAllSounds(self.elementalType.."chargedloop")
  animator.stopAllSounds(self.elementalType.."fullcharge")
  animator.setAnimationState("charge", "idle")
  animator.setParticleEmitterActive(self.elementalType .. "charge", false)
  activeItem.setScriptedAnimationParameter("lightning", {})
end

function TeleportAphroditesRetreat:uninit()
  self:reset()
end
