# Store the general chapters inside an array for easy manipulation
define base_chapter_list = [
    "chapter_1", "chapter_2", "chapter_3", "chapter_4", "chapter_5",
    "chapter_6", "chapter_7", "chapter_8", "chapter_9", "chapter_10", "chapter_11"
]

define ending_routes = {
    4: ["chapter_11D", "chapter_12D", "chapter_12_5D", "chapter_13D", "chapter_14D"],
    3: ["chapter_11C", "chapter_12C", "chapter_12_5C", "chapter_13C", "chapter_14C"],
    2: ["chapter_11B", "chapter_12B", "chapter_13B", "chapter_14B"],
    1: ["chapter_11A", "chapter_12A", "chapter_12_5D", "chapter_13A", "chapter_14A"]
}

# The working list the game references to determine the chapters to use. Ending chapters are added to this list when determined.
default chapter_list = base_chapter_list.copy()

# Default vars reset when a new game starts, so no biggie.

# Anon/Fang
default anonscore = 0
default fangscore = 0
default wingStory = False

# Chapter variables
default chapter_list_length = get_chapter_list_length()
default chapter_list_index = 0 # Index number for the current position of the chapter_list array
default current_chapter = chapter_list[chapter_list_index] # Store the name of the label as a string

# What ending we're on
default ending_route_number = None # A value of None signals to get_ending() to determine the value based off anon/fang scores when it is called
default ending_chapters_determined = False