define chapter_tuple = [
    (_("1. First Day of School"), "chapter_1"),
    (_("2. Meeting the Band"), "chapter_2"),
    (_("3. Band Practice"), "chapter_3"),
    (_("4. Music Class"), "chapter_4"),
    (_("5. Gardening Club / Heart to Heart"), "chapter_5"), # This is supposed to be split in 2 chapters, but maybe making tons of save files stop working would be too much to ask
    (_("6. Not a Date"), "chapter_6"),
    (_("7. Concert Day"), "chapter_7"),
    (_("8. Study Session"), "chapter_8"),
    (_("9. VVURM DRAMA"), "chapter_9"),
    (_("10. Confession"), "chapter_10"),
    (_("11. Naser drama"), "chapter_11")
]

define ending_1_tuple = [
    (_("11.5. Announcing a Plan"), "lPromAnnouncement"), # this is supposed to be ch 12 (13, accounting for ch 5), but it somehow got counted as part of 11 internally
    (_("12. Let's all go to the Museum"), "chapter_12A"),
    (_("13. Prom is Complicated"), "chapter_12_5D"),
    (_("14. Bowling for Volcano High"), "chapter_14A")
]

define ending_2_tuple = [
    (_("11.5. Announcing Nothing Important"), "lPromAnnouncement"),
    (_("12. Let's all go to a Concert"), "chapter_12B"),
    (_("13. Prom is For Suckers"), "chapter_13B"),
    (_("14. Anon and the Infinite Sadness"), "chapter_14B")
]

define ending_3_tuple = [
    (_("11.5. Announcing a Date"), "lPromAnnouncement"),
    (_("12. Let's all go Camping"), "chapter_12C"),
    (_("13. Prom is Surprising"), "chapter_12_5C"),
    (_("14. Volcano Highschool Musical"), "chapter_14C")
]

define ending_4_tuple = [
    (_("11.5. Announcing a Show"), "lPromAnnouncement"),
    (_("12. Let's all go to the Aquarium"), "chapter_12D"),
    (_("13. Prom is Memorable"), "chapter_12_5D"),
    (_("14. Fast Times at Volcano High"), "chapter_14D")
]


label chapter_select:
    $ quick_menu = False # Hides bottom quick menu UI

    stop ambient
    stop ambient1
    stop ambient2
    stop ambient3
    stop sound
    stop music
    stop music1
    stop music2
    scene black

    camera:
        yanchor 0.0 xanchor 0.0 rotate None zoom 1.0 xpos 0.0 ypos 0.0
        matrixcolor None

    with Dissolve(0.25)

    jump chapter_select_go_back # Technically we don't need to explicitly jump to the label just below here, but doing so anyway for clarity

label chapter_select_go_back:

    # Reset story vars. Not that it terribly matters, but just in case it avoids bugs.
    python:
        anonscore = 0
        fangscore = 0
        wingStory = False

        chapter_list = base_chapter_list.copy()
        chapter_list_index = 0
        chapter_list_length = get_chapter_list_length()
        ending_route_number = None
        ending_chapters_determined = False
        current_chapter = chapter_list[chapter_list_index]

    menu:
        "What ending do you want to lock to?"

        "Ending 1":
            $ ending_route_number = 1
        "Ending 2":
            $ ending_route_number = 2
        "Ending 3":
            $ ending_route_number = 3
        "Ending 4":
            $ ending_route_number = 4
        "Exit to main menu":
            scene black with Dissolve(0.25)
            return
    
    window auto hide

    $ chapter_select()


init python:

    # Some of this would be much easier to do if we could just reorganize how the chapters are laid out, but breaking translations is way more of a hassle to fix

    def chapter_select():
        global current_chapter, quick_menu, ending_route_number, chapter_list_index, chapter_list, ending_chapters_determined, chapter_list_length

        selected_label = display_chapter_choices() # Returns a label of the chapter to jump to
        
        setup_ending(ending_route_number) # Add ending chapters to chapter control list

        # Find the index position of the selected chapter
        try:
            chapter_list_index = chapter_list.index(selected_label)
        except ValueError: # This crashes the game otherwise since it wouldn't find the correct chapter
    
            # Make an exception for the 11A/B/C/D chapters, since we're technically supposed to start at the lPromAnnouncement label
            # Stank as fuck
            if selected_label == "lPromAnnouncement":
                chapter_list_index = 10
                current_chapter = "chapter_11"

                toggle_debug()
                quick_menu = True

                renpy.call("lPromAnnouncement")
            else:
                print("No such chapter exists!")
                MainMenu(confirm=False) () # Exits to the main menu

        current_chapter = selected_label

        # Start playing the game
        toggle_debug()
        quick_menu = True # Restores the bottom quick menu UI

        renpy.call(current_chapter)
    
    def display_chapter_choices():
        # Vars for displaying the choices
        ending_tuples = {
            1: ending_1_tuple,
            2: ending_2_tuple,
            3: ending_3_tuple,
            4: ending_4_tuple
        }

        final_chapter_tuple = chapter_tuple + ending_tuples[ending_route_number] # Chapter list to select from

        current_page = 0
        chapters_per_page = 6

        # The range of choices to display
        start_index = 0
        end_index = chapters_per_page

        while True:
            # Displays the choices
            selected_label = renpy.display_menu(final_chapter_tuple[start_index:end_index] + [(_("Next Page"), "chapter_select_next_page"), (_("Go Back"), "chapter_select_go_back")])

            if selected_label == "chapter_select_next_page":
                # If we're at the last page, wrap around to the first
                current_page = 0 if end_index == len(final_chapter_tuple) else (current_page + 1)
                
                start_index = chapters_per_page * current_page
                end_index = min(start_index + chapters_per_page, len(final_chapter_tuple))

            # Exit to ending selection
            elif selected_label == "chapter_select_go_back":
                renpy.jump("chapter_select_go_back")

            # We've selected a chapter
            else:
                return selected_label