# Mod Menu screen ############################################################
##
## Handles jumping to the mods scripts
## Could be more lean but if this is going to one of last time I touch the UI,
## then fine by me
##
#similar to quick_button funcs
screen mod_menu_button(filename, label, function):
    button:
        xmaximum 600
        ymaximum 129
        action function
        if 'Back' in label or 'Return' in label or 'Quit' in label or 'Main Menu' in label:
            activate_sound "audio/ui/uiBack.wav"
        else:
            activate_sound "audio/ui/uiClick.wav"
        fixed:
            add filename xalign 0.5 yalign 0.5 zoom 0.9
            text label xalign 0.5 yalign 0.5 xanchor 0.5 size 34

# arr is [{
#    'Name': string (name that appears on the button)
#    'Label': string (jump label)
# }, { .. } ]
# Reuse the same image string and keep things 'neat'.
screen mod_menu_buttons(filename, arr):
    for x in arr:
        use mod_menu_button(filename, x['Name'], Start(x['Label']) )

screen mod_menu():

    tag menu

    style_prefix "main_menu"

    add gui.main_menu_background

    frame:
        xsize 420
        yfill True
        background "gui/overlay/main_menu.png"

#side_yfill True
    vbox:
        xpos 1940
        yalign 0.03
        if persistent.splashtype == 1:
            add "gui/sneedgame.png"
        else:
            add "gui/snootgame.png"

    viewport:
        # this could be better but its ok for now
        xpos 1885-540
        xmaximum 540
        ymaximum 0.8
        ypos 200
        yinitial 0
        if len(mod_menu_access) > 5: # Hides the scrollbar when not needed. Ideally nobody would install more than one mod at the same time, but oh well
            scrollbars "vertical"
        mousewheel True
        draggable True
        pagekeys True

        
        if len(mod_menu_access) != 0:
            vbox:
                use mod_menu_button("gui/button/menubuttons/template_idle.png", _("Return"), ShowMenu("main_menu"))
                spacing 18
                use mod_menu_buttons("gui/button/menubuttons/template_idle.png", mod_menu_access )
        else:
            use mod_menu_button("gui/button/menubuttons/template_idle.png", _("Return"), ShowMenu("main_menu"))
            text _("You have no mods! \nInstall some in:\n\"[moddir]\""):
                style_prefix "navigation"
                size 45
                text_align 0.5
                outlines [(3, "#445ABB", absolute(0), absolute(0))]
                at truecenter

#############################
# Stuff for mods in android #
#############################

init python:
    
    import os

    if renpy.android and not config.developer:

        moddir = os.path.join(os.environ["ANDROID_PUBLIC"], "game")

        try:
            # We have to create both the 'game' and 'mods' folder for android.
            os.mkdir(moddir)
            os.mkdir(os.path.join(moddir, "mods"))
        except:
            pass

    else:
        moddir = ".../game"

    moddir += "/mods/"