init 2 python:

    import json

    # CONST PARAMS
    GALLERY_COLS = 4
    PREFERRED_WIDTH = 432 #px (1920 * 0.225)
    PREFERRED_HEIGHT = 243 #px (1080 * 0.225)
    PREFERRED_ASPECT_RATIO = 16.0/9.0 # 1.7777..
    DEFAULT_WIDTH_SCALE_RATIO = round(float(PREFERRED_WIDTH) / float(1920), 4)
    DEFAULT_HEIGHT_SCALE_RATIO = round(float(PREFERRED_HEIGHT) / float(1080), 4)
    NOT_UNLOCKED_COVER = im.FactorScale("gui/gallery/unlocked_cg_button_cover.png", DEFAULT_WIDTH_SCALE_RATIO, DEFAULT_HEIGHT_SCALE_RATIO)
    CG_PATHS = []
    #path: folder, name: shows up in gallery, eval: runs eval() on string

    """
    Data structure that holds the data for each cg and button
    item is name, cg is the image definition
    { item: str; cg: Displayable; }
    (reference in this init python, actually used in screens)
    """

    gallery_dic = {} 

    # Makes a scaled down cg button
    def cg_(fname, w):
        scale = PREFERRED_WIDTH / w
        if type(fname) is str:
            image = im.FactorScale(fname, scale, scale, True)
            return image
        else:
            return Transform(fname, zoom=scale)

    # For testing purposes, unlocks all images in the gallery (And by extension the bonus chapters)
    def unlock_all():
        for key in gallery_dic.keys():
            for image in gallery_dic[key]:
                renpy.mark_image_seen(image["item"])

    # Reads /images/cgs dir for all image files
    # Populates galleryItems
    # () -> None

    def jsonloadandpop():

        fp = renpy.open_file('src/gallery_dataset.json')
        data = json.load(fp)

        list_img = renpy.list_images()

        for tab in data['tabs']:

            tab_name =  _(tab['tab_name'])
            _eval = None
            if 'eval' in tab.keys():
                _eval = tab['eval']

            CG_PATHS.append({'name': tab_name, 'eval': _eval})
            gallery_dic[tab_name] = []
            #gallery_dataset

            if 'items' in tab.keys():
                for image in tab['items']:
                    name = image["name"]
                    cg = image["image"]

                    rcg = renpy.get_registered_image(cg)

                    item = {
                        "item": name,
                        "image": rcg,
                        "cg": cg_(rcg, 1920),
                    }

                    gallery_dic[tab_name].append(item)

        pass

    jsonloadandpop()

    gallery_dic['Animations'] = [{
        "item": 'fang tail',
        "image": 'images/animations/fang tail thumbnail.webp',
        "cg": 'images/animations/fang tail thumbnail.webp',
    }]
    renpy.image("fang tail", Movie(loop=True,play='images/animations/fang tail.webm')) # Since we are hard-coding might as well.
    pass

# Bullshit for the scrollbar to reset back to the beggining. Bless the renpy Discord :pray:
default adjust = ui.adjustment()

"""
CG Gallery screen - A screen that shows the image gallery
Built-in Gallery Object has terrible defaults, so I just wrote my own stuff
"""
screen cg_gallery(origin = 'CG'):

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")

    # Bg for frame
    add gui.main_menu_background
    # Frame
    add gui.game_menu_background

    tag menu

    python:

        empty_spaces = gallery_rows = item_counter = 0
        gallery_items = gallery_dic[origin]
        items = len(gallery_items)
        gallery_rows = (items / GALLERY_COLS) + 1
        empty_spaces = GALLERY_COLS - (items % GALLERY_COLS)

    vbox id "vbx":
        transform:
            zoom 0.95
            hbox:
                style_prefix "navigation"
                xalign 0.5

                spacing gui.navigation_spacing

                for cp in CG_PATHS:
                    if cp['name'] == origin:
                        textbutton _(cp['name']) text_color gui.selected_color text_xalign 0.5
                    else:
                        if cp['eval'] is None:
                            textbutton _(cp['name']) text_color gui.idle_color text_hover_color gui.hover_color activate_sound "audio/ui/uiClick.wav" action (ShowMenu('cg_gallery', cp['name']),SetField(adjust, 'value', 0)) text_xalign 0.5
                        elif eval(cp['eval']):
                            textbutton _(cp['name']) text_color gui.idle_color text_hover_color gui.hover_color activate_sound "audio/ui/uiClick.wav" action (ShowMenu('cg_gallery', cp['name']),SetField(adjust, 'value', 0))  text_xalign 0.5
                        else:
                            textbutton _(cp['name']) text_xalign 0.5

                textbutton _("Return") activate_sound "audio/ui/uiBack.wav" action ShowMenu('main_menu') text_xalign 0.5

        transform:
            zoom 0.95
            xcenter 0.525
            ycenter 0.525

            vpgrid id "vpg":
                if gallery_rows>=4:
                    scrollbars "vertical"
                mousewheel True
                draggable True
                pagekeys True
                xfill True
                yadjustment adjust

                xcenter 0.5

                spacing 20

                cols GALLERY_COLS

                for item in gallery_items:

                    use flag_button(item, origin)

                for i in range(0, empty_spaces):
                    null height 20

"""
if/else flow control & extra parameters for Buttons
"""
screen flag_button(item, origin):

    $ flag = renpy.seen_image(item['item'])

    if flag:
        button:
            if item in gallery_dic['Animations']:
                action ShowMenu('view_movie', item, ShowMenu('cg_gallery', origin))
            else:
                action ShowMenu('view_image', item, ShowMenu('cg_gallery',origin))
            xcenter 0.5 ycenter 0.5
            vbox:
                yminimum PREFERRED_HEIGHT xminimum PREFERRED_WIDTH
                add item["cg"] fit 'contain' xcenter 0.5 ycenter 0.5 size (PREFERRED_WIDTH, PREFERRED_HEIGHT)
    else:
        vbox:
            ymaximum PREFERRED_HEIGHT
            xcenter 0.5 ycenter 0.5
            add NOT_UNLOCKED_COVER

screen view_movie(item, _origin):
    tag menu
    key "game_menu" action [Hide('view_movie'), _origin ]
    key "button_alternate" action [Hide('view_movie'), _origin ]
    add item['item']
    if renpy.variant("small"):
        hbox:
            style_prefix "quick"
            xalign 0.5
            yalign 0.975
            use quick_buttons("gui/button/uioptionbuttons/template_idle.png",
                [
                    [ "Return", _origin ]
                ] )

"""
view_image, Loads the image in fullscreen with viewport control.
"""
screen view_image(item, _origin):
    tag menu
    key "game_menu" action (Hide('view_image'), _origin)
    key "button_alternate" action (Hide('view_image'), _origin)

    viewport id "vie":
        #Ren'Py isn't smart enough to not edgescroll while pressed,
        #so we'll have to disable this for mobile
        if renpy.variant("pc"):
            edgescroll (300, 1800)
        draggable True
        arrowkeys True
        pagekeys True
        xfill False
        yfill False
        add item['image'] zoom 1.0 anchor (0.55, 0.55)

    #Reuse quick buttons. Ren'Py handles touch input lazy, it doesn't have
    #double finger pinch zoom, it translates taps as mouse events - have to use
    #buttons
    if renpy.variant("small"):
        hbox:
            style_prefix "quick"
            xalign 0.5
            yalign 0.975
            use quick_buttons("gui/button/uioptionbuttons/template_idle.png",
                [
                    [ "Return", _origin ]
                ] )

