To normal users installing multiple mods: It's recommended to only have one mod folder installed in the mods directory in case two mods have duplicate `green_fang_story` label, otherwise the game will error out if mods conflict each other, this includes not only labels but images & sound too.

The game loads an alternate storyline.rpy, this allows you to control the flow of the game's storytelling
Examples include:
- You want to inject more stuff inbetween chapters, maybe you hate time skip writing
- You want to have more of an after story kind of ordeal, for example expanding Ending 2
- You want to replace the entire story route
You can still call the vanilla game's chapters like the intro (call chapter_1) for example but you might want to either copy the vanilla scripts and mix in your edits to have full control

You will need to learn bit of Ren'Py & bit of actual Python anyways but you don't have to think too hard in learning anything new other than familiarizing with this game's script.rpy's already defined Character objects and images, you can freely ignore most of the UI and so on for the inexperienced but passionate artist and/or writer.

Textbox limitation: ~300 characters / four lines, the maximum in the vanilla game's script is around roughly ~278 and that only barely overflows to four lines, so <200 characters / three lines of text should be fine.

--- Ideal file structure of your mod ---
    In the root of the mods folder:
    folder_of_your_mod_name
        - name_of_storyline.rpy
        -> asset_folder
            - asset.png
        -> script_folder
            - script.rpy

	name_of_storyline.rpy
```
init python:
    # Modding Support variables
    # All mod rpy files must have title of their mod (this shows up on a button)
    # and finally the label that controls the flow of dialogue

    mod_menu_access += [{
        'Name': "Mod Name",
        'Label': "mod_storyline"
    }];

image template_sample = Image("mods/folder_of_your_mod_name/asset_folder/asset.png")

label mod_storyline:
    call chapter_1_new
```

	script_folder/script.rpy
```
label chapter_1_new:
    show template_sample at scenter
    "Sample Text"

    hide template_sample
    play music 'audio/OST/Those Other Two Weirdos.ogg'
    show anon neutral flip at aright with dissolve
    A "Sample Text"

    return
```

The funny thing is I don't even like 'fanfictions' to begin with but this mod support allows these 'fanfictions', ironic.
