# Mod Menu screen ############################################################
##
## Handles jumping to the mods scripts
## Could be more lean but if this is going to one of last time I touch the UI,
## then fine by me
##
#similar to quick_button funcs
screen mod_menu_button(filename, label, function):
    button:
        xmaximum 600
        ymaximum 129
        action function
        if 'Back' in label or 'Return' in label or 'Quit' in label or 'Main Menu' in label:
            activate_sound "audio/ui/snd_ui_back.wav"
        else:
            activate_sound "audio/ui/snd_ui_click.wav"
        fixed:
            add filename xalign 0.5 yalign 0.5 yzoom 1.2 xzoom 1.4
            text label xalign 0.5 yalign 0.5 size 34

# arr is [{
#    'Name': string (name that appears on the button)
#    'Label': string (jump label)
# }, { .. } ]
# Reuse the same image string and keep things 'neat'.
screen mod_menu_buttons(filename, arr):
    for x in arr:
        use mod_menu_button(filename, x['Name'], Start(x['Label']) )

transform tf_modmenu_slide:
    xoffset 600
    linear 0.25 xoffset 0

screen mod_menu():

    tag menu

    style_prefix "main_menu"

    add gui.main_menu_background
    add "gui/title_overlay.png"
    add "gui/overlay/sidemenu.png" at tf_modmenu_slide

#side_yfill True
    #vbox:
    #    xpos 1940
    #    yalign 0.03
    #    if persistent.splashtype == 1:
    #        add "gui/sneedgame.png"
    #    else:
    #        add "gui/snootgame.png"

    viewport at tf_modmenu_slide:
        yinitial 0
        xpos 1885-540
        ypos 200
        xmaximum 540
        ymaximum 1080 - 200

        if len(mod_menu_access) > 5: # Hides the scrollbar when not needed. Ideally nobody would install more than one mod at the same time, but oh well
            scrollbars "vertical"
        mousewheel True
        draggable True
        pagekeys True
        
        if len(mod_menu_access) != 0:
            vbox:
                #use mod_menu_button("gui/button/menubuttons/menu_button.png", _("Return"), ShowMenu("main_menu"))
                #spacing 18
                use mod_menu_buttons("gui/button/menubuttons/menu_button.png", mod_menu_access )
        else:
            xpos 1885-480
            ypos 450
            #use mod_menu_button("gui/button/menubuttons/menu_button.png", _("Return"), ShowMenu("main_menu"))
            text _("You have no mods! \nInstall some in:\n\"[moddir]\""):
                style_prefix "navigation"
                size 45
                text_align 0.5
                xalign 0.5 yalign 0.5
                outlines [(3, "#342F6C", absolute(0), absolute(0))]
    use extrasnavigation

#############################
# Stuff for mods in android #
#############################

init python:
    
    import os

    if renpy.android and not config.developer:

        moddir = os.path.join(os.environ["ANDROID_PUBLIC"], "game")

        try:
            # We have to create both the 'game' and 'mods' folder for android.
            os.mkdir(moddir)
            os.mkdir(os.path.join(moddir, "mods"))
        except:
            pass

    else:
        moddir = ".../game"

    moddir += "/mods/"