# TODO: Make some custom tags for Kinetic Text Tags like shaking letters as if they got hit

#
#   Basic moveset
#

# Moving in
transform moveindown(x=0.5, y=0.0, m=0.2, t=0.75):
    subpixel True
    xpos x
    ypos y - m
    easein_cubic t ypos y

transform moveinup(x=0.5, y=0.0, m=0.2, t=0.75):
    subpixel True
    xpos x
    ypos y + m
    easein_cubic t ypos y

transform moveinleft(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y
    xpos x + m
    easein_cubic t xpos x

transform moveinright(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y
    xpos x - m
    easein_cubic t xpos x


# These are meant to be used without a dissolve transition, but will need a safeguard in case the user advances text too quickly
transform moveindown_a(x=0.5, y=0.0, m=0.2, t=0.75):
    subpixel True
    xpos x
    ypos y - m
    alpha 0
    parallel:
        easein_cubic t ypos y
    parallel:
        easein_cubic min(0.5, t) alpha 1

transform moveinup_a(x=0.5, y=0.0, m=0.2, t=0.75):
    subpixel True
    xpos x
    ypos y + m
    parallel:
        easein_cubic t ypos y
    parallel:
        easein_cubic min(0.5, t) alpha 1

transform moveinleft_a(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y
    xpos x + m
    alpha 0
    parallel:
        easein_cubic t xpos x
    parallel:
        easein_cubic min(0.5, t) alpha 1

transform moveinright_a(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y
    xpos x - m
    alpha 0
    parallel:
        easein_cubic t xpos x
    parallel:
        easein_cubic min(0.5, t) alpha 1


# Moving out
transform moveoutdown(y=0.0, m=0.1, t=0.5):
    subpixel True
    on hide:
        parallel:
            easeout_cubic t ypos y + m
        parallel:
            time t - 0.5
            easeout_cubic min(0.5, t) alpha 0

transform moveoutup(y=0.0, m=0.1, t=0.5):
    subpixel True
    on hide:
        parallel:
            easeout_cubic t ypos y - m
        parallel:
            time t - 0.5
            easeout_cubic min(0.5, t) alpha 0

transform moveoutleft(x=0.5, m=0.15, t=0.75):
    subpixel True
    on hide:
        parallel:
            easeout_cubic t xpos x - m
        parallel:
            time t - 0.5
            easeout_cubic min(0.5, t) alpha 0

transform moveoutright(x=0.5, m=0.15, t=0.75):
    subpixel True
    on hide:
        parallel:
            easeout_cubic t xpos x + m
        parallel:
            time t - 0.5
            easeout_quad min(0.5, t) alpha 0


# Moving out, but doesn't rely on the hide event so you can do more stuff with it, like
# turning a character around while they exit the scene

transform moveoutleft_cs(x=0.5, m=0.15, t=1):
    subpixel True
    parallel:
        on hide:
            easeout_cubic min(0.5, t) alpha 0
    parallel:
        easeout_cubic t xpos x - m

transform moveoutright_cs(x=0.5, m=0.15, t=1):
    subpixel True
    parallel:
        on hide:
            easeout_cubic min(0.5, t) alpha 0
    parallel:
        easeout_cubic t xpos x + m




transform movex(x=0.5, t=1):
    subpixel True
    easein_cubic t xpos x

transform movey(y=0.0, t=1):
    subpixel True
    easein_cubic t ypos y

transform movexy(x=0.5, y=0.0, t=1):
    subpixel True
    easein_cubic t xpos x ypos y

transform easemovex(x=0.5, t=1):
    subpixel True
    ease_cubic t xpos x

transform easemovey(y=0.5, t=1):
    subpixel True
    ease_cubic t ypos y

transform easemovexy(x=0.5, y=0.0, t=1):
    subpixel True
    ease_cubic t xpos x ypos y

transform backmovex(x=0.5, t=0.75):
    subpixel True
    easein_back t xpos x

transform backmovey(y=0.5, t=0.75):
    subpixel True
    easein_back t ypos y

transform backmovexy(x=0.5, y=0.0, t=0.75):
    subpixel True
    easein_back t xpos x ypos y

transform elasticmovex(x=0.5, t=1):
    subpixel True
    easein_elastic t xpos x

transform elasticmovey(y=0.5, t=1):
    subpixel True
    easein_elastic t ypos y

transform elasticmovexy(x=0.5, y=0.0, t=1):
    subpixel True
    easein_elastic t xpos x ypos y



#Just in case you have a transform that gets interrupted when advancing too quickly. 
transform resetalpha(a=1):
    alpha a
transform setx(x=0.5):
    xpos x
transform sety(y=0.0):
    ypos y
transform setxy(x=0.0, y=0.0):
    xpos x ypos y
transform resetmovex(x=0.5):
    alpha 1 xpos x
transform resetmovey(y=0.0):
    alpha 1 ypos y
transform resetmovexy(x=0.0, y=0.0):
    alpha 1 xpos x ypos y

#
#   EFFECT MOVE TRANSFORMS
#


# y is current ypos, d is delay between jumps (the first jump is instant), h is height of jump, t is length of jump arcs
transform jumpingloop(y=0.0, t=0.7, h=0.1):
    subpixel True
    easein_cubic (t/2) ypos y - h
    easeout_cubic (t/2) ypos y
    repeat

# y is current ypos, r is the amount of repeated jumps, d is delay between jumps (the first jump is instant), h is height of jump, t is length of jump arcs
transform jumping(y=0.0, r=1, t=0.7, h=0.1):
    subpixel True
    easein_cubic (t/2) ypos y - h
    easeout_cubic (t/2) ypos y
    repeat r

# Same as above, but shorter jump for easy calling
transform hop(y=0.0, r=1, t=0.4, h=0.04):
    subpixel True
    easein_cubic (t/2) ypos y - h
    easeout_cubic (t/2) ypos y
    repeat r - 1

transform nudgeup(y=0.0, t=0.4, s=1.0):
    subpixel True
    ease_cubic (t*0.25) ypos y + (0.01 * s)
    easein_cubic (t*0.25) ypos y - (0.01 * s)
    easein_cubic (t*0.5) ypos y

# Inverted version of the above
transform nudgeupinv(y=0.0, t=0.4, s=1.0):
    subpixel True
    ease_cubic (t*0.25) ypos y - (0.01 * s)
    easein_cubic (t*0.25) ypos y + (0.01 * s)
    easein_cubic (t*0.5) ypos y

# x is the current cpos, w is the strength, t is how fast it is
transform hitx(x=0.5, i=1, s=1):
    subpixel True
    linear (0.038*s) xpos x - (0.01*i)
    linear (0.038*s) xpos x + (0.005*i)
    linear (0.038*s) xpos x - (0.0033*i)
    linear (0.038*s) xpos x + (0.0025*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.00166*i)
    linear (0.038*s) xpos x - (0.00125*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.000833*i)
    linear (0.038*s) xpos x

transform hity(y=0.0, i=1, s=1):
    subpixel True
    linear (0.038*s) ypos y - (0.015*i)
    linear (0.038*s) ypos y + (0.0075*i)
    linear (0.038*s) ypos y - (0.005*i)
    linear (0.038*s) ypos y + (0.00375*i)
    linear (0.038*s) ypos y - (0.003*i)
    linear (0.038*s) ypos y + (0.0025*i)
    linear (0.038*s) ypos y - (0.001875*i)
    linear (0.038*s) ypos y + (0.0015*i)
    linear (0.038*s) ypos y - (0.00125*i)
    linear (0.038*s) ypos y

transform hit(x=0.5, i=1, t=1):
    easein_quad t * 0.05 xpos x - (0.025 * i)
    easein_elastic t - (t * 0.05) xpos x

# X is current xpos, w is strength, t is fast
transform vibratex(x=0.5, i=1.0, s=1.0):
    subpixel True
    linear (0.03*s) xpos x - (0.0007 * i)
    linear (0.03*s) xpos x + (0.0007 * i)
    repeat
# Y is current ypos, w is strength, t is fast
transform vibratey(y=0.0, i=1.0, s=1.0):
    subpixel True
    linear (0.03*s) ypos y - (0.0015 * i)
    linear (0.03*s) ypos y + (0.0015 * i)
    repeat

# x is the current xpos, r is the amount of times the growl is repeated, w is the strength, t is how fast it goes
transform growl1x(x=0.5, i=1, s=1):
    subpixel True
    linear (0.038*s) xpos x - (0.0005*i)
    linear (0.038*s) xpos x + (0.0005*i)
    linear (0.038*s) xpos x - (0.0006*i)
    linear (0.038*s) xpos x + (0.0006*i)
    linear (0.038*s) xpos x - (0.00075*i)
    linear (0.038*s) xpos x + (0.00075*i)
    linear (0.038*s) xpos x - (0.001*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0012*i)
    linear (0.038*s) xpos x - (0.0015*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.002*i)
    linear (0.038*s) xpos x - (0.003*i)
    linear (0.038*s) xpos x + (0.003*i)
    linear (0.038*s) xpos x - (0.006*i)
    linear (0.038*s) xpos x + (0.006*i)
    linear (0.038*s) xpos x - (0.003*i)
    linear (0.038*s) xpos x + (0.003*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.002*i)
    linear (0.038*s) xpos x - (0.0015*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0012*i)
    linear (0.038*s) xpos x - (0.001*i)
    linear (0.038*s) xpos x + (0.001*i)
    block:
        linear (0.038*s) xpos x - (0.0007*i)
        linear (0.038*s) xpos x + (0.0007*i)
        repeat

transform growl2x(x=0.5, d=0.0, i=1, s=1):
    subpixel True
    linear (0.038*s) xpos x - (0.0005*i)
    linear (0.038*s) xpos x + (0.0005*i)
    linear (0.038*s) xpos x - (0.0006*i)
    linear (0.038*s) xpos x + (0.0006*i)
    linear (0.038*s) xpos x - (0.00075*i)
    linear (0.038*s) xpos x + (0.00075*i)
    linear (0.038*s) xpos x - (0.001*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0012*i)
    linear (0.038*s) xpos x - (0.0015*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.002*i)
    linear (0.038*s) xpos x - (0.003*i)
    linear (0.038*s) xpos x + (0.003*i)
    linear (0.038*s) xpos x - (0.006*i)
    linear (0.038*s) xpos x + (0.006*i)
    linear (0.038*s) xpos x - (0.003*i)
    linear (0.038*s) xpos x + (0.003*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.002*i)
    linear (0.038*s) xpos x - (0.0015*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0012*i)
    linear (0.038*s) xpos x - (0.001*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.00075*i)
    linear (0.038*s) xpos x + (0.00075*i)
    linear (0.038*s) xpos x - (0.0006*i)
    linear (0.038*s) xpos x + (0.0006*i)
    linear (0.038*s) xpos x - (0.0005*i)
    linear (0.038*s) xpos x + (0.0005*i)
    linear (0.038*s) xpos x
    pause d
    repeat

transform growl1y(y=0.0, i=1, s=1):
    subpixel True
    linear (0.038*s) ypos y - (0.000833*i)
    linear (0.038*s) ypos y + (0.000833*i)
    linear (0.038*s) ypos y - (0.001*i)
    linear (0.038*s) ypos y + (0.001*i)
    linear (0.038*s) ypos y - (0.00125*i)
    linear (0.038*s) ypos y + (0.00125*i)
    linear (0.038*s) ypos y - (0.00166*i)
    linear (0.038*s) ypos y + (0.00166*i)
    linear (0.038*s) ypos y - (0.002*i)
    linear (0.038*s) ypos y + (0.002*i)
    linear (0.038*s) ypos y - (0.0025*i)
    linear (0.038*s) ypos y + (0.0025*i)
    linear (0.038*s) ypos y - (0.0033*i)
    linear (0.038*s) ypos y + (0.0033*i)
    linear (0.038*s) ypos y - (0.005*i)
    linear (0.038*s) ypos y + (0.005*i)
    linear (0.038*s) ypos y - (0.01*i)
    linear (0.038*s) ypos y + (0.01*i)
    linear (0.038*s) ypos y - (0.005*i)
    linear (0.038*s) ypos y + (0.005*i)
    linear (0.038*s) ypos y - (0.0033*i)
    linear (0.038*s) ypos y + (0.0033*i)
    linear (0.038*s) ypos y - (0.0025*i)
    linear (0.038*s) ypos y + (0.0025*i)
    linear (0.038*s) ypos y - (0.002*i)
    linear (0.038*s) ypos y + (0.002*i)
    block:
        linear (0.038*s) ypos y - (0.00166*i)
        linear (0.038*s) ypos y + (0.00166*i)
        repeat

transform growl2y(y=0.0, d=0.0, i=1, s=1):
    subpixel True
    linear (0.038*s) ypos y - (0.000833*i)
    linear (0.038*s) ypos y + (0.000833*i)
    linear (0.038*s) ypos y - (0.001*i)
    linear (0.038*s) ypos y + (0.001*i)
    linear (0.038*s) ypos y - (0.00125*i)
    linear (0.038*s) ypos y + (0.00125*i)
    linear (0.038*s) ypos y - (0.00166*i)
    linear (0.038*s) ypos y + (0.00166*i)
    linear (0.038*s) ypos y - (0.002*i)
    linear (0.038*s) ypos y + (0.002*i)
    linear (0.038*s) ypos y - (0.0025*i)
    linear (0.038*s) ypos y + (0.0025*i)
    linear (0.038*s) ypos y - (0.0033*i)
    linear (0.038*s) ypos y + (0.0033*i)
    linear (0.038*s) ypos y - (0.005*i)
    linear (0.038*s) ypos y + (0.005*i)
    linear (0.038*s) ypos y - (0.01*i)
    linear (0.038*s) ypos y + (0.01*i)
    linear (0.038*s) ypos y - (0.005*i)
    linear (0.038*s) ypos y + (0.005*i)
    linear (0.038*s) ypos y - (0.0033*i)
    linear (0.038*s) ypos y + (0.0033*i)
    linear (0.038*s) ypos y - (0.0025*i)
    linear (0.038*s) ypos y + (0.0025*i)
    linear (0.038*s) ypos y - (0.002*i)
    linear (0.038*s) ypos y + (0.002*i)
    linear (0.038*s) ypos y - (0.00166*i)
    linear (0.038*s) ypos y + (0.00166*i)
    linear (0.038*s) ypos y - (0.00125*i)
    linear (0.038*s) ypos y + (0.00125*i)
    linear (0.038*s) ypos y - (0.001*i)
    linear (0.038*s) ypos y + (0.001*i)
    linear (0.038*s) ypos y - (0.000833*i)
    linear (0.038*s) ypos y + (0.000833*i)
    linear (0.038*s) ypos y
    pause d
    repeat

transform shudder(x=0.5, i=1, s=1):
    subpixel True
    linear (0.038*s) xpos x - (0.0005*i)
    linear (0.038*s) xpos x + (0.0006*i)
    linear (0.038*s) xpos x - (0.00075*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.003*i)
    linear (0.038*s) xpos x - (0.002*i)
    linear (0.038*s) xpos x + (0.002*i)
    linear (0.038*s) xpos x - (0.0015*i)
    linear (0.038*s) xpos x + (0.0015*i)
    linear (0.038*s) xpos x - (0.0012*i)
    linear (0.038*s) xpos x + (0.0012*i)
    linear (0.038*s) xpos x - (0.001*i)
    linear (0.038*s) xpos x + (0.001*i)
    linear (0.038*s) xpos x - (0.00075*i)
    linear (0.038*s) xpos x + (0.00075*i)
    linear (0.038*s) xpos x - (0.0006*i)
    linear (0.038*s) xpos x + (0.0006*i)
    linear (0.038*s) xpos x - (0.0005*i)
    linear (0.038*s) xpos x + (0.0005*i)
    linear (0.038*s) xpos x


# x is the current xpos, m is the distance to slide, t is the how fast it goes
transform slideinplace1(x=0.5, m=0.025, t=1):
    subpixel True
    ease_quad t/2 xpos x + m
    ease_quad t/2 xpos x - m
    repeat

transform slideinplace2(x=0.5, m=0.025, t=1.5):
    easein_cubic t/2 xpos x + m
    easein_cubic t/2 xpos x - m
    repeat

transform bob(y=0.0, m=0.025, t=1):
    subpixel True
    ease_quad t/2 ypos y + m
    ease_quad t/2 ypos y - m
    repeat

# d is for delay until the animation starts, s is for the speed of the animation, and y is the height the character is walking at
transform walkerloop(d=0.0, s=1, y=0.0):
    transform_anchor True
    subpixel True
    yoffset 0.5 * 1500
    yanchor 0.5

    pause d
    parallel:
        easein_quad (0.3/s) ypos y - 0.0075
        easeout_quad (0.3/s) ypos y
        easein_cubic (0.075/s) ypos y + 0.0025
        easeout_cubic (0.075/s) ypos y
        repeat

transform walker(d=0.0, r=1, s=1, y=0.0):
    pause d
    block:
        easein_quad (0.3/s) ypos y - 0.0075
        easeout_quad (0.3/s) ypos y
        easein_cubic (0.075/s) ypos y + 0.0025
        easeout_cubic (0.075/s) ypos y
        repeat r



# Rotaters

# Input the point in the image you want to rotate around vertically - 0.0 for the very top, 1.0 for the very bottom. Specify the height of the sprite you're using as well.
transform tf_test_rotater(yanch=0.0, spr_height=1500):
    transform_anchor True
    subpixel True
    yoffset yanch * spr_height
    yanchor yanch

    block:
        parallel:
            ease_cubic 0.5 rotate 5
            ease_cubic 0.5 rotate -5
            repeat
        parallel:
            ease_cubic 0.75 ypos 0.05
            ease_cubic 0.75 ypos 0.0
            repeat

transform falldownleft(h=0.0, t=1, yanch=1.0, spr_height=1500):
    transform_anchor True
    subpixel True
    yoffset yanch * spr_height
    yanchor yanch

    parallel:
        easeout_circ t rotate -90
    parallel:
        easeout_circ t ypos h

transform falldownright(h=0.0, t=1, yanch=1.0, spr_height=1500):
    transform_anchor True
    subpixel True
    yoffset yanch * spr_height
    yanchor yanch

    parallel:
        easeout_circ t rotate 90
    parallel:
        easeout_circ t ypos h

transform standup(h=0.0, t=1, yanch=0.5, spr_height=1500):
    transform_anchor True
    subpixel True
    yoffset yanch * spr_height
    yanchor yanch

    parallel:
        easein_circ t rotate 0
    parallel:
        easein_circ t ypos h

transform rotate_funny(h=0.0, t=1, yanch=0.5, spr_height=1500):
    transform_anchor True
    subpixel True
    yoffset yanch * spr_height
    yanchor yanch

    parallel:
        ease_cubic t rotate 5
    parallel:
        ease_cubic t ypos h

transform resetrotate:
    yanchor 0.0
    yoffset 0.0
    rotate None # Why it can't just be zero, I don't know, and this is retarded, but whatever
    transform_anchor False

#
#   CAMERA TRANSFORMS
#


# This is gonna look really convoluted to make it extensible and work no matter what position the camera is in
# Evidently, renpy.random() also doesn't work to well in transforms, probably due to them being calculated on startup only.
# TODO: Fucking realized this doesn't work well with differeing zpos images. Redo them

# i is intensity, s is fast, inv is to invert the anchors for when 'perspective True' is on.
transform shake(i=1.0, s=1.0, inv=1.0):
    subpixel True
    linear (0.02*s): 
        zoom 1 + (0.002 * i)
        xanchor 0.1 * (0.002 * i * inv)
        yanchor 0.37 * (0.002 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.003  * i)
        xanchor 0.7 * (0.003  * i * inv)
        yanchor 0.4 * (0.003  * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.005 * i)
        xanchor 0.3 * (0.005 * i * inv)
        yanchor 0.8 * (0.005 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.006 * i)
        xanchor 0.5 * (0.006 * i * inv)
        yanchor 0.6 * (0.006 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.007* i)
        xanchor 0.4 * (0.007* i * inv)
        yanchor 0.0
    linear (0.02*s): 
        zoom 1 + (0.009 * i)
        xanchor 0.5 * (0.009 * i * inv)
        yanchor 0.5 * (0.009 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.01 * i)
        xanchor 0.9 * (0.01 * i * inv)
        yanchor 0.4 * (0.01 * i * inv)
    block:
        choice:
            linear (0.02*s): 
                zoom 1 + (0.007 * i)
                xanchor 0.2 * (0.007 * i * inv)
                yanchor 0.0
        choice:
            linear (0.02*s): 
                zoom 1 + (0.01 * i)
                xanchor 0.0
                yanchor 0.5 * (0.01 * i * inv)
        choice:
            linear (0.02*s): 
                zoom 1 + (0.011 * i)
                xanchor 0.6 * (0.011 * i * inv)
                yanchor 0.4 * (0.011 * i * inv)
        choice:
            linear (0.02*s): 
                zoom 1 + (0.015 * i)
                xanchor 0.25 * (0.015 * i * inv)
                yanchor 0.7  * (0.015 * i * inv)
        choice:
            linear (0.02*s): 
                zoom 1 + (0.01 * i)
                xanchor 0.4 * (0.01 * i * inv)
                yanchor 0.4 * (0.01 * i * inv)
        choice:
            linear (0.02*s): 
                zoom 1 + (0.005 * i)
                xanchor 0.9 * (0.005 * i * inv)
                yanchor 0.005 * i * inv
        choice:
            linear (0.02*s): 
                zoom 1 + (0.009 * i)
                xanchor 0.7 * (0.009 * i * inv)
                yanchor 0.2 * (0.009 * i * inv)
        choice:
            linear (0.02*s): 
                zoom 1 + (0.006 * i)
                xanchor 0.5 * (0.006 * i * inv)
                yanchor 0.8 * (0.006 * i * inv)
        repeat


transform shakeend(i=1.0, s=1, inv=1.0):
    subpixel True
    linear (0.02*s): 
        zoom 1 + (0.013 * i)
        xanchor 0.2 * (0.013 * i * inv)
        yanchor 0.0
    linear (0.02*s): 
        zoom 1 + (0.012 * i)
        xanchor 0.6 * (0.012 * i * inv)
        yanchor 0.9 * (0.012 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.01 * i)
        xanchor 0.3 * (0.01 * i * inv)
        yanchor 0.01 * i * inv
    linear (0.02*s): 
        zoom 1 + (0.009 * i)
        xanchor 0.55 * (0.009 * i * inv)
        yanchor 0.4  * (0.009 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.008 * i)
        xanchor 0.0
        yanchor 0.25 * (0.008 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.007 * i)
        xanchor 1.0  * (0.007 * i * inv)
        yanchor 0.75 * (0.007 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.006 * i)
        xanchor 0.6  * (0.006 * i * inv)
        yanchor 0.15 * (0.006 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.005 * i)
        xanchor 0.3 * (0.005 * i * inv)
        yanchor 0.4 * (0.005 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.004 * i)
        xanchor 0.8 * (0.004 * i * inv)
        yanchor 1.0 * (0.004 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.003 * i)
        xanchor 0.7 * (0.003 * i * inv)
        yanchor 0.9 * (0.003 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.002 * i)
        xanchor 0.45 * (0.002 * i * inv)
        yanchor 0.6  * (0.002 * i * inv)
    linear (0.02*s): 
        zoom 1 + (0.001 * i)
        xanchor 0.15 * (0.001 * i * inv)
        yanchor 0.6  * (0.001 * i * inv)
    linear (0.02*s):
        zoom 1
        xanchor 0.0
        yanchor 0.0


transform shakex(i=1.0, s=1.0, inv=1.0):
    subpixel True
    # The yanchors are the same offsets as zoom and xanchor but divided by 2
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.001 * i)    yanchor (0.0005 * i * inv)
    linear (0.02*s) xanchor (0.0025 * i * inv)  zoom 1 + (0.0025 * i)   yanchor (0.00125 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.004 * i)    yanchor (0.002 * i * inv)
    linear (0.02*s) xanchor (0.007 * i * inv)   zoom 1 + (0.007 * i)    yanchor (0.0035 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.008 * i)    yanchor (0.004 * i * inv) 
    linear (0.02*s) xanchor (0.01 * i * inv)    zoom 1 + (0.01 * i)     yanchor (0.005 * i * inv)
    block:
        choice:
            linear (0.02*s) xanchor 0.0
            linear (0.02*s) xanchor (0.01 * i * inv)
        choice:
            linear (0.02*s) xanchor 0.0
            linear (0.02*s) xanchor 0.8 * (0.01 * i * inv)
        choice:
            linear (0.02*s) xanchor 0.3 * (0.01 * i * inv)
            linear (0.02*s) xanchor (0.01 * i * inv)
        choice:
            linear (0.02*s) xanchor 0.1 * (0.01 * i * inv)
            linear (0.02*s) xanchor 0.9 * (0.01 * i * inv)
        choice:
            linear (0.02*s) xanchor 0.2 * (0.01 * i * inv)
            linear (0.02*s) xanchor 0.7 * (0.01 * i * inv)
        repeat

transform shakeendx(i=1.0, s=1.0, inv=1.0):
    subpixel True
    linear (0.02*s) xanchor (0.01 * i * inv)    zoom 1 + (0.01 * i)     yanchor (0.005 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.009 * i)    yanchor (0.0045 * i * inv)
    linear (0.02*s) xanchor (0.008 * i * inv)   zoom 1 + (0.008 * i)    yanchor (0.004 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.007 * i)    yanchor (0.0035 * i * inv)
    linear (0.02*s) xanchor (0.006 * i * inv)   zoom 1 + (0.006 * i)    yanchor (0.003 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.005 * i)    yanchor (0.0025 * i * inv)
    linear (0.02*s) xanchor (0.004 * i * inv)   zoom 1 + (0.004 * i)    yanchor (0.002 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.003 * i)    yanchor (0.0015 * i * inv)
    linear (0.02*s) xanchor (0.002 * i * inv)   zoom 1 + (0.002 * i)    yanchor (0.001 * i * inv)
    linear (0.02*s) xanchor 0.0                 zoom 1 + (0.001 * i)    yanchor (0.0005 * i * inv)
    linear (0.02*s) zoom 1 xanchor 0.0 yanchor 0.0

transform shakey(i=1.0, s=1.0, inv=1.0):
    subpixel True
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.001 * i)    xanchor (0.0005 * i * inv)
    linear (0.02*s) yanchor (0.003 * i * inv)   zoom 1 + (0.003 * i)    xanchor (0.0015 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.006 * i)    xanchor (0.003 * i * inv)
    linear (0.02*s) yanchor (0.01 * i * inv)    zoom 1 + (0.01 * i)     xanchor (0.005 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.012 * i)    xanchor (0.006 * i * inv)
    linear (0.02*s) yanchor (0.015 * i * inv)   zoom 1 + (0.015 * i)    xanchor (0.0075 * i * inv)
    block:
        choice:
            linear (0.02*s) yanchor 0.0
            linear (0.02*s) yanchor (0.015 * i * inv)
        choice:
            linear (0.02*s) yanchor 0.0
            linear (0.02*s) yanchor 0.8 * (0.015 * i * inv)
        choice:
            linear (0.02*s) yanchor 0.3 * (0.015 * i * inv)
            linear (0.02*s) yanchor 0.015 * i * inv
        choice:
            linear (0.02*s) yanchor 0.1 * (0.015 * i * inv)
            linear (0.02*s) yanchor 0.9 * (0.015 * i * inv)
        choice:
            linear (0.02*s) yanchor 0.2 * (0.015 * i * inv)
            linear (0.02*s) yanchor 0.7 * (0.015 * i * inv)
        repeat


transform shakeendy(i=1.0, s=1.0, inv=1.0):
    subpixel True
    linear (0.02*s) yanchor (0.015 * i * inv)   zoom 1 + (0.015 * i) xanchor (0.0075 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.014 * i) xanchor (0.007 * i * inv)
    linear (0.02*s) yanchor (0.012 * i * inv)   zoom 1 + (0.012 * i) xanchor (0.006 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.011 * i) xanchor (0.0055 * i * inv)
    linear (0.02*s) yanchor (0.009 * i * inv)   zoom 1 + (0.009 * i) xanchor (0.0045 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.008 * i) xanchor (0.004 * i * inv)
    linear (0.02*s) yanchor (0.006 * i * inv)   zoom 1 + (0.006 * i) xanchor (0.003 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.005 * i) xanchor (0.0025 * i * inv)
    linear (0.02*s) yanchor (0.004 * i * inv)   zoom 1 + (0.004 * i) xanchor (0.002 * i * inv)
    linear (0.02*s) yanchor 0.0                 zoom 1 + (0.003 * i) xanchor (0.0015 * i * inv)
    linear (0.02*s) yanchor (0.001 * i * inv)   zoom 1 + (0.001 * i) xanchor (0.0005 * i * inv)
    linear (0.02*s) zoom 1 xanchor 0.0 yanchor 0.0

transform resetshake:
    zoom 1
    xanchor 0.0
    yanchor 0.0

transform resetcamera:
    zpos 0 xpos 0 ypos 0 yoffset 0 xoffset 0
    perspective None


# Shakers for the gym background
transform gym_shaker_hit(x=0.0, y=0.0):
    linear 0.03 xpos 0.004 ypos -0.003
    linear 0.03 xpos 0.003 ypos 0.002
    linear 0.03 xpos -0.004 ypos 0.003
    linear 0.03 xpos 0.003 ypos -0.001
    linear 0.03 xpos 0.003 ypos -0.003
    linear 0.03 xpos -0.002 ypos -0.002
    linear 0.03 xpos 0.004 ypos -0.002
    linear 0.03 xpos -0.003 ypos -0.003
    linear 0.03 xpos -0.002 ypos -0.002
    linear 0.03 xpos 0.000 ypos -0.000
    linear 0.03 xpos 0.003 ypos -0.002
    linear 0.03 xpos -0.002 ypos -0.001
    linear 0.03 xpos 0.001 ypos -0.002
    linear 0.03 xpos -0.002 ypos -0.001
    linear 0.03 xpos -0.000 ypos -0.000
    linear 0.03 xpos 0.001 ypos -0.001
    linear 0.03 xpos 0.0 ypos 0.0


#
#   ATL TEXT TAG TRANSFORMS
#

# Shouting
transform sh:
    subpixel True
    yoffset -1 xoffset -2
    pause 0
    yoffset 1 xoffset 1
    pause 0
    yoffset 2 xoffset 0
    pause 0
    yoffset 0 xoffset 1
    pause 0
    yoffset 0 xoffset -2
    pause 0
    yoffset -2 xoffset 0
    pause 0
    yoffset -0.5 xoffset 2
    pause 0
    yoffset 2.5 xoffset -0.5
    pause 0
    yoffset -1 xoffset -1
    pause 0
    yoffset 0 xoffset 0.5
    pause 0
    yoffset -1 xoffset -1.5
    pause 0
    yoffset 1 xoffset 1
    pause 0
    yoffset 1.5 xoffset 0
    pause 0
    yoffset 0 xoffset 2.5
    pause 0
    yoffset -0.5 xoffset -2
    pause 0
    yoffset -1.5 xoffset 0
    pause 0
    yoffset -0.5 xoffset 2
    pause 0
    yoffset 0 xoffset -2
    pause 0
    yoffset -1 xoffset -0.5
    pause 0
    yoffset 0 xoffset 0.5
    pause 0
    repeat


#
#   IMAGE EFFECTS
#

transform tint(tintcolor):
    matrixcolor TintMatrix(tintcolor)