# Character names

#character colors and names for the text box
define base = Character(ctc="ctc_end_marker", ctc_pause="ctc_mid_marker", ctc_timedpause=Null(), ctc_position="nestled") #imagine having to tell your users they need to interact with the video game
define narrator = Character(kind=base)
define unknown = Character('???', base, color="#ffffff", who_outlines=[(gui.name_text_thickness, '#000000')]) # Grey
define I = Character('Inco', base, color="#dbe0ff", who_outlines=[(gui.name_text_thickness, '#0e0841')]) # Navy blue
define O = Character('Olivia', base, color="#73fdb1", who_outlines=[(gui.name_text_thickness, '#03200c')])
define B = Character('Ben', base, color="#9aceff", who_outlines=[(gui.name_text_thickness, '#0b0d22')])
define Scal = Character ('Scaler', base, color="#ffd9a8", who_outlines=[(gui.name_text_thickness, '#200505')]) # Bright fuckin' yellow
define Proc = Character ('Prockling', base, color="#ffeaf2", who_outlines=[(gui.name_text_thickness, '#4e024a')])
define Coach = Character('Coach', base, color="#ffa494", who_outlines=[(gui.name_text_thickness, '#350404')])
define D = Character('Damien', base, color="#fdddd4", who_outlines=[(gui.name_text_thickness, '#2c0e03')]) # Some kinda pastel velvet?
define L = Character('Liz', base, color="#faeeca", who_outlines=[(gui.name_text_thickness, '#032449')]) # Some kinda pastel velvet?
define Iad = Character('Iadakan', base, color="#fff8e6", who_outlines=[(gui.name_text_thickness, '#272b09')])
define Mia = Character('Mia', base, color="#ffffff", who_outlines=[(gui.name_text_thickness, '#8a0e0e')])
define Lu = Character('Lunara', base, color="#effdff", who_outlines=[(gui.name_text_thickness, '#082b30')])
define Fe = Character('Mr. Ferris', base, color="#b7abf8", who_outlines=[(gui.name_text_thickness, '#000000')])
define Ra = Character('Randy', base, color="#ec738d", who_outlines=[(gui.name_text_thickness, '#220a05')])
define Sp = Character('Sophia', base, color="#d3e6ff", who_outlines=[(gui.name_text_thickness, '#0b1431')])
define Vi = Character('Vinny', base, color="#fff3b0", who_outlines=[(gui.name_text_thickness, '#311c04')])
define So = Character('Solly', base, color="#ffd4cc", who_outlines=[(gui.name_text_thickness, '#350404')])

define Grill = Character('Grill', base, color="#ffffff", who_outlines=[(gui.name_text_thickness, '#000000')])
define Everyone = Character('Everyone', base, color="#ffffff", who_outlines=[(gui.name_text_thickness, '#000000')]) # Grey
define Teacher = Character('Teacher', base, color="#fff8e6", who_outlines=[(gui.name_text_thickness, '#272b09')]) # Grey

define Phone = Character('Phone', base, color="#ffffff", who_outlines=[(gui.name_text_thickness, '#000000')])
define InDa = Character('Damien & Inco', base, color = "#ffffff", who_outlines=[(gui.name_text_thickness, '#000000')])





#Helper functions

init python:

    # Get the position properties of a tag within the master layer
    def tag_get_placement(tag, layer="master"):
        return renpy.get_placement(renpy.game.context().scene_lists.get_displayable_by_tag(layer, tag))


    # xpos positions for crowd sprites, in order from back to front:
    # chilling1: 1.68
    # phone1:    1.18 
    # chilling2: 0.44 
    # watching4: 2.5
    # watching1: 0.85
    # idle1:     0.0
    # phone3:    0.65 
    # idle3:     0.88
    # idle4:     1.96
    # idle2:     1.59
    # phone2:    1.8
    # watching3: 0.39 
    # watching2: 1.33 
    # chilling3: 0.6
    #
    # xpos 2.4 for idle1 to complete the loop
    #
    # Formula for calculating the delay before sprites move to give their offsets:
    # time * (a sprite xpos / xpos of sprite that completes the loop))

    # Get the sprites started by sprHandler_CrowdTransitionIn and smoothly transition them out
    def sprHandler_crowdTransitionAway(instant=False):
        # TODO: Make sprHandler_crowdTransitionAway search through the scene's list of tags instead of a premade array
        #tags = renpy.get_showing_tags()
        #for i in tags:
        #    if i.find("spr_crowdperson_"):
        crowd_list =   ["spr_crowdperson_chilling1",
                        "spr_crowdperson_phone1",
                        "spr_crowdperson_chilling2",
                        "spr_crowdperson_watching4",
                        "spr_crowdperson_watching1",
                        "spr_crowdperson_idle1",
                        "spr_crowdperson_phone3",
                        "spr_crowdperson_idle3",
                        "spr_crowdperson_idle4",
                        "spr_crowdperson_idle2",
                        "spr_crowdperson_phone2",
                        "spr_crowdperson_watching3",
                        "spr_crowdperson_watching2",
                        "spr_crowdperson_chilling3",]
        if instant:
            for i in crowd_list:
                renpy.show(i, at_list=[setx()], layer="effects") # Override any transform currenlty happening, the sprite will disappear before this transform shows
                renpy.hide(i, layer="effects")
        else:
            for i in crowd_list:
                crowd_pos = tag_get_placement(i, "effects")
                dist_from_reset_point = crowd_pos.xpos - (0.9 - 2.4)
                new_interp_time = 3 * (dist_from_reset_point / 2.4)
                renpy.show(i, at_list=[tf_crowdperson_hide(new_interp_time)], layer="effects")
                renpy.hide(i, layer="effects")

    def sprHandler_CrowdTransitionIn(instant=False):
        if instant:
            renpy.show("spr_crowdperson_chilling1", at_list=[tf_crowdperson_scroll_instant(1.68, 1, "#113509")], layer="effects")
            renpy.show("spr_crowdperson_phone1", at_list=[tf_crowdperson_scroll_instant(1.18, 1, "#372020")], layer="effects")
            renpy.show("spr_crowdperson_chilling2", at_list=[tf_crowdperson_scroll_instant(0.44, -1, "#4f522f")], layer="effects")
            renpy.show("spr_crowdperson_watching4", at_list=[tf_crowdperson_scroll_instant(2.5, 1, "#340d2f")], layer="effects")
            renpy.show("spr_crowdperson_watching1", at_list=[tf_crowdperson_scroll_instant(0.85, -1, "#0f203f")], layer="effects")
            renpy.show("spr_crowdperson_idle1", at_list=[tf_crowdperson_scroll_instant(0.0, 1, "#19171E")], layer="effects")
            renpy.show("spr_crowdperson_phone3", at_list=[tf_crowdperson_scroll_instant(0.65, 1, "#292128")], layer="effects")
            renpy.show("spr_crowdperson_idle3", at_list=[tf_crowdperson_scroll_instant(0.88, 1, "#2A372F")], layer="effects")
            renpy.show("spr_crowdperson_idle4", at_list=[tf_crowdperson_scroll_instant(1.96, -1, "#0C122D")], layer="effects")
            renpy.show("spr_crowdperson_idle2", at_list=[tf_crowdperson_scroll_instant(1.59, 1, "#364b10")], layer="effects")
            renpy.show("spr_crowdperson_phone2", at_list=[tf_crowdperson_scroll_instant(1.8, 1, "#0D341E")], layer="effects")
            renpy.show("spr_crowdperson_watching3", at_list=[tf_crowdperson_scroll_instant(0.39, 1, "#142943")], layer="effects")
            renpy.show("spr_crowdperson_watching2", at_list=[tf_crowdperson_scroll_instant(1.33, -1, "#481818")], layer="effects")
            renpy.show("spr_crowdperson_chilling3", at_list=[tf_crowdperson_scroll_instant(0.6, 1, "#370B0D")], layer="effects")
        else:
            renpy.show("spr_crowdperson_chilling1", at_list=[tf_crowdperson_scroll(1.68, 1, "#113509")], layer="effects")
            renpy.show("spr_crowdperson_phone1", at_list=[tf_crowdperson_scroll(1.18, 1, "#372020")], layer="effects")
            renpy.show("spr_crowdperson_chilling2", at_list=[tf_crowdperson_scroll(0.44, -1, "#4f522f")], layer="effects")
            renpy.show("spr_crowdperson_watching4", at_list=[tf_crowdperson_scroll(2.5, 1, "#340d2f")], layer="effects")
            renpy.show("spr_crowdperson_watching1", at_list=[tf_crowdperson_scroll(0.85, -1, "#0f203f")], layer="effects")
            renpy.show("spr_crowdperson_idle1", at_list=[tf_crowdperson_scroll(0.0, 1, "#19171E")], layer="effects")
            renpy.show("spr_crowdperson_phone3", at_list=[tf_crowdperson_scroll(0.65, 1, "#292128")], layer="effects")
            renpy.show("spr_crowdperson_idle3", at_list=[tf_crowdperson_scroll(0.88, 1, "#2A372F")], layer="effects")
            renpy.show("spr_crowdperson_idle4", at_list=[tf_crowdperson_scroll(1.96, -1, "#0C122D")], layer="effects")
            renpy.show("spr_crowdperson_idle2", at_list=[tf_crowdperson_scroll(1.59, 1, "#364b10")], layer="effects")
            renpy.show("spr_crowdperson_phone2", at_list=[tf_crowdperson_scroll(1.8, 1, "#0D341E")], layer="effects")
            renpy.show("spr_crowdperson_watching3", at_list=[tf_crowdperson_scroll(0.39, 1, "#142943")], layer="effects")
            renpy.show("spr_crowdperson_watching2", at_list=[tf_crowdperson_scroll(1.33, -1, "#481818")], layer="effects")
            renpy.show("spr_crowdperson_chilling3", at_list=[tf_crowdperson_scroll(0.6, 1, "#370B0D")], layer="effects")

# Transforms for the crowd transitions above

transform tf_crowdperson_hide(t):
    on hide:
        linear t xpos 0.9 - 2.4

transform tf_crowdperson_scroll(x=0.0, flip=1, color="#ffffff", _offset=0.9, t=3):
    zoom 2.285714 ypos -0.91 xpos _offset xzoom flip alpha 0.0
    matrixcolor ColorizeMatrix(color, "#ffffff")
    pause t * (x / 2.4)
    alpha 1
    block:
        linear t xpos _offset - 2.4
        xpos _offset
        repeat
transform tf_crowdperson_scroll_instant(x=0.0, flip=1, color="#ffffff", _offset=0.9, t=3):
    zoom 2.285714 ypos -0.91 xpos _offset - (2.4 - x) xzoom flip
    matrixcolor ColorizeMatrix(color, "#ffffff")
    linear t * (x / 2.4) xpos _offset - 2.4
    block:
        xpos _offset
        linear t xpos _offset - 2.4
        repeat



#
#   METRO STUFF
#

init python:
    # some stupid bullshit you have to do to get sounds playing in an ATL block
    def play_metro_bump_sound(a,b,c):
        renpy.play("audio/sounds/snd_metro_bump" + DEFAULT_SOUND_EXTENSION, channel='audio')
    def play_metro_announcer1_sound(a,b,c):
        renpy.play("audio/sounds/snd_metro_announcer1" + DEFAULT_SOUND_EXTENSION, channel='audio')
    def play_metro_announcer2_sound(a,b,c):
        renpy.play("audio/sounds/snd_metro_announcer2" + DEFAULT_SOUND_EXTENSION, channel='audio')
    def play_metro_announcer3_sound(a,b,c):
        renpy.play("audio/sounds/snd_metro_announcer3" + DEFAULT_SOUND_EXTENSION, channel='audio')
    def play_metro_beep_sound(a,b,c):
        renpy.play("audio/sounds/snd_metro_beep" + DEFAULT_SOUND_EXTENSION, channel='audio')


transform tf_metro_cameramove:
    parallel:
        parallel:
            ease_quad 1.5 xoffset 1
            ease_quad 1.0 xoffset -2
            ease_quad 1.3 xoffset 2
            ease_quad 1.0 xoffset -2
            ease_quad 1.2 xoffset 3
            ease_quad 1.0 xoffset -2
            ease_quad 1.2 xoffset -4
            ease_quad 1.4 xoffset 0
            repeat
        parallel:
            ease_quad 1.0 yoffset -1
            ease_quad 1.4 yoffset 3
            ease_quad 1.1 yoffset -4
            ease_quad 1.5 yoffset 2
            ease_quad 1.1 yoffset 4
            ease_quad 1.0 yoffset -2
            repeat

    parallel:
        # autistic workaround for the 'time' statement not working in these blocks.
        pause 8
        block:
            parallel:
                pause 8
            parallel:
                linear 0.04 yanchor 0.002
                linear 0.055 yanchor 0.0
                linear 0.07 yanchor 0.005
                linear 0.07 yanchor 0.0
                linear 0.07 yanchor 0.01
                linear 0.07 yanchor 0.0
                linear 0.07 yanchor 0.005
                linear 0.09 yanchor 0.0
                linear 0.09 yanchor 0.002
                linear 0.09 yanchor 0.0
            repeat

transform tf_metro_soundplayer:
    parallel:
        pause 7.5
        function play_metro_bump_sound
        pause 0.5
        repeat
    parallel:
        pause 10
        function play_metro_beep_sound
        pause 1
        function play_metro_announcer1_sound
        pause 20
        function play_metro_beep_sound
        pause 1
        function play_metro_announcer2_sound
        pause 17
        function play_metro_beep_sound
        pause 1
        function play_metro_announcer3_sound
        pause 6
        repeat


# Call these labels, so you can quickly setup the metro scene in a chapter

label l_metro_day_sound:
    scene black

    show bg_metro_skyline:
        xpos 0.46
        ypos -0.61
        matrixtransform RotateMatrix(0.0, -9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan 360
            repeat
    show bg_metro_skyline as bg_metro_skyline2:
        xpos -0.96
        ypos -0.61
        matrixtransform RotateMatrix(0.0, 9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan -360
            repeat

    show bg_metro_base at truecenter

    show spr_metrorandy_hoe:
        truecenter
        pause 4
        "spr_metrorandy_hoe_blink"
        pause 4.1
        block:
            "spr_metrorandy_hoe_bump"
            pause 4
            "spr_metrorandy_hoe_blink"
            pause 4
            "spr_metrorandy_hoe_bump"
            pause 5
            "spr_metrorandy_hoe_blink"
            pause 3
            repeat

    show spr_metrorandy_rebels:
        truecenter
        pause 8.1
        block:
            "spr_metrorandy_rebels_bump"
            pause 8
            repeat
    show spr_metrorandy_paperguy:
        truecenter
        pause 8.1
        block:
            "spr_metrorandy_paperguy_bump"
            pause 3
            "spr_metrorandy_paperguy_turnpage"
            pause 5
            "spr_metrorandy_paperguy_bump"
            pause 8
            "spr_metrorandy_paperguy_bump"
            pause 8
            repeat

    show bg_metro_bars at truecenter
    show bg_metro_overlay at truecenter

    return


label l_metro_day:

    scene black

    show bg_metro_skyline:
        xpos 0.46
        ypos -0.61
        matrixtransform RotateMatrix(0.0, -9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan 360
            repeat
    show bg_metro_skyline as bg_metro_skyline2:
        xpos -0.96
        ypos -0.61
        matrixtransform RotateMatrix(0.0, 9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan -360
            repeat

    show bg_metro_base at truecenter

    show spr_metrorandy_hoe:
        truecenter
        pause 4
        "spr_metrorandy_hoe_blink"
        pause 4.1
        block:
            "spr_metrorandy_hoe_bump"
            pause 4
            "spr_metrorandy_hoe_blink"
            pause 4
            "spr_metrorandy_hoe_bump"
            pause 5
            "spr_metrorandy_hoe_blink"
            pause 3
            repeat

    show spr_metrorandy_rebels:
        truecenter
        pause 8.1
        block:
            "spr_metrorandy_rebels_bump"
            pause 8
            repeat
    show spr_metrorandy_paperguy:
        truecenter
        pause 8.1
        block:
            "spr_metrorandy_paperguy_bump"
            pause 3
            "spr_metrorandy_paperguy_turnpage"
            pause 5
            "spr_metrorandy_paperguy_bump"
            pause 8
            "spr_metrorandy_paperguy_bump"
            pause 8
            repeat

    show bg_metro_bars at truecenter
    show bg_metro_overlay at truecenter

    camera:
        perspective True
        tf_metro_cameramove
    
    return


label l_metro_dusk:

    scene black

    show bg_metro_skyline:
        xpos 0.46
        ypos -0.61
        matrixtransform RotateMatrix(0.0, -9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan -360
            repeat
    show bg_metro_skyline as bg_metro_skyline2:
        xpos -0.96
        ypos -0.61
        matrixtransform RotateMatrix(0.0, 9.0, 0.0)
        block:
            xpan 0
            linear 140 xpan 360
            repeat

    show bg_metro_base at truecenter

    show spr_metrorandy_paperguy:
        truecenter
        pause 8.1
        block:
            "spr_metrorandy_paperguy_bump"
            pause 3
            "spr_metrorandy_paperguy_turnpage"
            pause 5
            "spr_metrorandy_paperguy_bump"
            pause 8
            "spr_metrorandy_paperguy_bump"
            pause 8
            repeat

    show bg_metro_bars at truecenter
    show bg_metro_overlay at truecenter

    camera:
        perspective True
        matrixcolor BrightnessMatrix(0.1)*TintMatrix("#FFA976")*ContrastMatrix(value=1.2)
        tf_metro_cameramove

    return