# Feast your eyes, you're going to see horrid copypasted code
# TODO: have liz functions looked over by someone who can actually python and renpy


# DON'T USE THESE TRANSFORMS! They are intended for the functions

transform tf_lizhead_moveOutToPos_hideimmediately_cubic(x, y, t):
    subpixel True
    parallel:
        on hide:
            easeout_cubic min(0.5, t) alpha 0
    parallel:
        easeout_cubic t xpos x
    parallel:
        easein_cubic t ypos y

transform tf_lizhead_moveOutToPos_hideimmediately_quad(x, y, t):
    subpixel True
    parallel:
        on hide:
            easeout_cubic min(0.5, t) alpha 0
    parallel:
        easeout_quad t xpos x
    parallel:
        easein_cubic t ypos y

transform tf_lizhead_moveinright_fromtop(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y - 0.3
    xpos x - m
    easein_cubic t xpos x ypos y

transform tf_lizhead_moveinleft_fromtop(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos y - 0.3
    xpos x + m
    easein_cubic t xpos x ypos y

transform tf_lizhead_moveinup_fromtop(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos (y + m) - 0.3
    xpos x
    easein_cubic t ypos y

transform tf_lizhead_moveindown_fromtop(x=0.5, y=0.0, m=0.2, t=1):
    subpixel True
    ypos (y - m) - 0.3
    xpos x
    easein_cubic t ypos y

transform tf_lizhead_moveOutToXPos(x, t):
    subpixel True
    on hide:
        parallel:
            time t - 0.5
            easeout_cubic min(0.5, t) alpha 0
        parallel:
            easeout_cubic t xpos x

transform tf_lizhead_moveOutToYPos(y, t):
    subpixel True
    on hide:
        parallel:
            time t - 0.5
            easeout_cubic min(0.5, t) alpha 0
        parallel:
            easeout_cubic t ypos y

transform tf_lizhead_quadmovexy(x, y, t):
    subpixel True
    ease_quad t xpos x ypos y



#
#   LIZ TRANSFORM FUNCTIONS
#

# Explanation for some of arguments in these functions:
#
# 'headatt' and 'bodyatt' - A string containing attributes you'd use for calling a sprite, in this case liz's head or body. 
#                           Does not need their designated tags, like 'lizhead' or 'lizbody', just the attributes.
# 'mode' - Parameter that takes MOVE or POSE constants, and refers to how her head moves.
#               MOVE: the head moves alongside the body, the exact same speed as the body
#               POSE: the head moves to be in front of the body so it ends up at the head's default position relative to her body
# 'usetrans' - Boolean that determines if the function uses a transition to fade between sprites. Useful for when you have multiple other sprites that need transitioning at the same time, outside the function.
# 'atlist' - A list of transforms to apply to the sprite, similar to the 'at' statement in ATL.
# 'behindlist' - A list of sprites to apply behind this sprite, similar to the 'behind' statement in ATL.

# When the functions that move liz get called, they will get her current body position and then depending on the mode, will get a predefined position offset from a list of 
# expressions - of which are currently or about to be applied onto the sprite - to apply to the head relative to the body, or move her head an equal distance as her body.

# -Note that these functions hitch the game when they're first used, but subsequent uses don't hitch.
# -Liz's head offsets are defined in characters.rpy
# -You're gonna want to use some collapsable blocks in your IDE for this.
# -NOTE: When specifying positions in functions, you have to make your number a float, so 0 won't function correctly but 0.0 will

init python:

    #
    #   SUPPORING FUNCTIONS
    #

    MOVE = 1
    POSE = 2

    # Finds out what position Liz's head should be in relative to her body. Takes a list of body attributes.
    # The second argument should always be None or the return of lizbody's attributes, which may be a list or None. It's set up this way because of the stupid toggle system
    # Horrid, rancid fucking function.
    # TODO: Make the head offsetter liz function not suck
    def liz_headoffsetter(attr_to_check, attr_to_compare=None):
        # If liz's sprite doesn't exist yet, or if we only have to check the attribute list in isolation.
        if attr_to_compare == None:
            # Check the direction
            if 'left' in attr_to_check:
                direction = -1.0
            # Even if we don't have a right attribute, the sprites default to being right.
            else:
                direction = 1.0

            # Check the sprite
            offsets = liz_bodylist(attr_to_check, direction)
            if offsets == -1:
                offsets = [0.0, 0.0]
            return offsets
        # Otherwise, check the calling attributes with the existing attributes to see what the offset should be.
        else:
            if 'left' in attr_to_check:
                direction = -1.0
            elif 'right' in attr_to_check:
                direction = 1.0
            # If we didn't pass any directions when we called the sprite, check the current direction of that sprite.
            else:
                if 'left' in attr_to_compare:
                    direction = -1.0
                # Even if we don't have a right attribute, the sprites default to being right.
                else:
                    direction = 1.0

            # See if we're calling a new sprite.
            offsets = liz_bodylist(attr_to_check, direction)
            if offsets == -1:
                # Now check the current sprite for Liz
                offsets = liz_bodylist(attr_to_compare, direction)
                if offsets == -1:
                    offsets = [0.0, 0.0]

            return offsets

    # Returns a tuple containing positional offsets for the head relative to the body based on the inputted attribute list, which should be the body's attributes.
    def liz_bodylist(attr, direction):
        if 'neutral' in attr:
            return [LIZHEADX_NEUTRAL * direction, LIZHEADY_NEUTRAL]
        if 'excited' in attr:
            return [LIZHEADX_EXCITED * direction, LIZHEADY_EXCITED]
        if 'thinking' in attr:
            return [LIZHEADX_THINKING * direction, LIZHEADY_THINKING]
        if 'verysad' in attr:
            return [LIZHEADX_VERYSAD * direction, LIZHEADY_VERYSAD]
        if 'terrified' in attr:
            return [LIZHEADX_TERRIFIED * direction, LIZHEADY_TERRIFIED]
        if 'furious' in attr:
            return [LIZHEADX_FURIOUS * direction, LIZHEADY_FURIOUS]
        return -1

    # Makes sure transform properties don't have a None value
    def liz_safeguardTProperty(tproperty, value):
        if tproperty == None:
            return value
        else:
            return tproperty

    # Puts a space before the attribute string so we the functions can use the sprites only via their tags if needed.
    def liz_attspacer(attr):
        if attr != "":
            attr = " " + attr
        return attr



    #
    #   MAIN FUNCTIONS
    #

    # This shit is all generally identical to the transforms for general movement, but special case for liz since she's
    # a fucking beast to handle

    def liz_updateexp(headatt="", bodyatt="", f=0.5, mode=POSE, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        if mode == POSE:
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))

            # Get her current position
            liz_coord = tag_get_placement("lizbody")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + offsets[0]
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + offsets[1]

            # Move her head into place
            tlist = [movexy(lizhead_xpos, lizhead_ypos)]
            tlist.extend(atlist)
            renpy.show("lizhead", at_list=tlist, behind=behindlist)

        # Seperate the movement transform and the sprite change to stop ghosting
        renpy.with_statement(None)
        # Make sure if we're using POSE, we don't reapply a transform since we already did that.
        renpy.show("lizbody" + bodyatt, at_list=atlist, behind=behindlist)
        if mode == POSE:
            renpy.show("lizhead" + headatt)
        elif mode == MOVE:
            renpy.show("lizhead" + headatt, at_list=atlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eiDissolve(f))

    def liz_show(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", f=0.5, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [setxy(x, y)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [setxy(x + offsets[0], y + offsets[1])]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eiDissolve(f))

    def liz_hide(f=0.5):
        renpy.with_statement(None)
        renpy.hide("lizbody")
        renpy.hide("lizhead")
        renpy.with_statement(eiDissolve(f))


    #
    #   MOVING IN
    #

    def liz_moveinright(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=1, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinright(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [moveinright(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveinleft(x=0.5, y=0.0, headatt="neutral left", bodyatt="neutral left", m=0.2, t=1, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinleft(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [moveinleft(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveinup(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=0.75, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinup(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [moveinup(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveindown(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=0.75, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveindown(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [moveindown(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)


    # Moves her head in from the top of the screen as she moves in.

    def liz_moveinright_fromtop(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=1, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinright(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveinright_fromtop(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveinleft_fromtop(x=0.5, y=0.0, headatt="neutral left", bodyatt="neutral left", m=0.2, t=1, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinleft(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveinleft_fromtop(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveinup_fromtop(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=0.75, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveinup(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveinup_fromtop(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)

    def liz_moveindown_fromtop(x=0.5, y=0.0, headatt="neutral", bodyatt="neutral", m=0.2, t=0.75, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
        renpy.with_statement(None)

        tlist = [moveindown(x, y, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody" + bodyatt, at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveindown_fromtop(x + offsets[0], y + offsets[1], m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead" + headatt, at_list=tlist, behind=behindlist)

        if usetrans:
            renpy.with_statement(eidissolve)



    #
    #   MOVING OUT
    #

    def liz_moveoutright(m=0.15, t=0.75, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]

        tlist = [moveoutright(lizbody_xpos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveOutToXPos(lizhead_xpos + m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.hide("lizbody")
        renpy.hide("lizhead")

    def liz_moveoutleft(m=0.15, t=0.75, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]

        tlist = [moveoutleft(lizbody_xpos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveOutToXPos(lizhead_xpos - m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.hide("lizbody")
        renpy.hide("lizhead")

    def liz_moveoutup(m=0.1, t=0.5, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [moveoutup(lizbody_ypos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveOutToYPos(lizhead_ypos - m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.hide("lizbody")
        renpy.hide("lizhead")

    def liz_moveoutdown(m=0.1, t=0.5, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [moveoutdown(lizbody_ypos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_moveOutToYPos(lizhead_ypos + m, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.hide("lizbody")
        renpy.hide("lizhead")



    def liz_moveoutright_cs(headatt="", bodyatt="", m=0.15, t=1, mode=POSE, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_finalxpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_finalypos = liz_safeguardTProperty(liz_coord.ypos, 0)

            tlist = [tf_lizhead_moveOutToPos_hideimmediately_cubic(lizhead_finalxpos + m, lizhead_finalypos, t)]
            tlist.extend(atlist)
            renpy.show("lizhead", at_list=tlist, behind=behindlist)
        elif mode == POSE:
            usequad = False
    
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            # This will find if the sprite change has us turning Liz around, so that we can apply a different warper to her head
            currentbodyatt = renpy.get_attributes("lizbody")

            if 'left' in currentbodyatt:
                if bodyatt.find('right') == 1:
                    usequad = True
            # Regardless, we'll be facing right by default if a direction isn't set.
            else:
                if bodyatt.find('left'):
                    usequad = True

            lizhead_finalxpos = lizbody_xpos + offsets[0]
            lizhead_finalypos = lizbody_ypos + offsets[1]

            if usequad:
                tlist = [tf_lizhead_moveOutToPos_hideimmediately_quad(lizhead_finalxpos + m, lizhead_finalypos, t)]
            else:
                tlist = [tf_lizhead_moveOutToPos_hideimmediately_cubic(lizhead_finalxpos + m, lizhead_finalypos, t)]
            tlist.extend(atlist)
            renpy.show("lizhead", at_list=tlist, behind=behindlist)

        tlist = [moveoutright_cs(lizbody_xpos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)
        renpy.with_statement(eidissolve)

        renpy.hide("lizbody")
        renpy.hide("lizhead")

    def liz_moveoutleft_cs(headatt="", bodyatt="", m=0.15, t=1, mode=POSE, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_finalxpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_finalypos = liz_safeguardTProperty(liz_coord.ypos, 0)

            tlist = [tf_lizhead_moveOutToPos_hideimmediately_cubic(lizhead_finalxpos - m, lizhead_finalypos, t)]
            tlist.extend(atlist)
            renpy.show("lizhead", at_list=tlist, behind=behindlist)
        elif mode == POSE:
            usequad = False

            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            currentbodyatt = renpy.get_attributes("lizbody")

            if 'left' in currentbodyatt:
                if bodyatt.find('right') == 1:
                    usequad = True
            else:
                if bodyatt.find('left'):
                    usequad = True

            lizhead_finalxpos = lizbody_xpos + offsets[0]
            lizhead_finalypos = lizbody_ypos + offsets[1]

            if usequad:
                tlist = [tf_lizhead_moveOutToPos_hideimmediately_quad(lizhead_finalxpos - m, lizhead_finalypos, t)]
            else:
                tlist = [tf_lizhead_moveOutToPos_hideimmediately_cubic(lizhead_finalxpos - m, lizhead_finalypos, t)]
            tlist.extend(atlist)
            renpy.show("lizhead", at_list=tlist, behind=behindlist)

        tlist = [moveoutleft_cs(lizbody_xpos, m, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)
        renpy.with_statement(eidissolve)

        renpy.hide("lizbody")
        renpy.hide("lizhead")


    
    #
    #   MOVEMENTS
    #

    def liz_movex(x=0.5, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [movex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
    
        tlist = [movexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_movey(y=0.0, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [movey(y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [movexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_movexy(x=0.5, y=0.0, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [movexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [movexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)



    def liz_easemovex(x=0.5, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [easemovex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
    
        tlist = [easemovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_easemovey(y=0.0, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [easemovey(y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [easemovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_easemovexy(x=0.5, y=0.0, t=1.0, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [easemovexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [easemovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)



    def liz_backmovex(x=0.5, t=0.75, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [backmovex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
    
        tlist = [backmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_backmovey(y=0.0, t=0.75, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [backmovey(y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [backmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_backmovexy(x=0.5, y=0.0, t=0.75, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [backmovexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [backmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)



    def liz_elasticmovex(x=0.5, t=1, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [elasticmovex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)
    
        tlist = [elasticmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_elasticmovey(y=0.0, t=1, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = lizbody_xpos + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [elasticmovey(y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [elasticmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

    def liz_elasticmovexy(x=0.5, y=0.0, t=1, mode=MOVE, atlist=[], behindlist=[]):
        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [elasticmovexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [elasticmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)





    #
    #   SPRITE CHANGING MOVEMENT
    #

    def liz_movex_cs(x=0.5, headatt="", bodyatt="", t=1, f=0.5, mode=POSE, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [movex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [movexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)

        if usetrans:
            renpy.with_statement(eiDissolve(f))

    def liz_movexy_cs(x=0.5, y=0.0, headatt="", bodyatt="", t=1, f=0.5, mode=POSE, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [movexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [movexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)

        if usetrans:
            renpy.with_statement(eiDissolve(f))

    def liz_easemovex_cs(x=0.5, headatt="", bodyatt="", t=1, f=0.5, mode=POSE, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)
        elif mode == POSE:
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = lizbody_ypos + offsets[1]

        tlist = [easemovex(x, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_quadmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)

        if usetrans:
            renpy.with_statement(eiDissolve(f))

    def liz_easemovexy_cs(x=0.5, y=0.0, headatt="", bodyatt="", t=1, f=0.5, mode=POSE, usetrans=True, atlist=[], behindlist=[]):
        bodyatt = liz_attspacer(bodyatt)
        headatt = liz_attspacer(headatt)

        liz_coord = tag_get_placement("lizbody")
        lizbody_xpos = liz_safeguardTProperty(liz_coord.xpos, 0)
        lizbody_ypos = liz_safeguardTProperty(liz_coord.ypos, 0)

        if mode == MOVE:
            liz_coord = tag_get_placement("lizhead")
            lizhead_xpos = liz_safeguardTProperty(liz_coord.xpos, 0) + (x - lizbody_xpos)
            lizhead_ypos = liz_safeguardTProperty(liz_coord.ypos, 0) + (y - lizbody_ypos)
        elif mode == POSE:
            offsets = liz_headoffsetter(bodyatt.split(), renpy.get_attributes("lizbody"))
            lizhead_xpos = x + offsets[0]
            lizhead_ypos = y + offsets[1]

        tlist = [easemovexy(x, y, t)]
        tlist.extend(atlist)
        renpy.show("lizbody", at_list=tlist, behind=behindlist)

        tlist = [tf_lizhead_quadmovexy(lizhead_xpos, lizhead_ypos, t)]
        tlist.extend(atlist)
        renpy.show("lizhead", at_list=tlist, behind=behindlist)

        renpy.with_statement(None)

        renpy.show("lizbody" + bodyatt)
        renpy.show("lizhead" + headatt)

        if usetrans:
            renpy.with_statement(eiDissolve(f))