# Gallery stuff needs to be initialized like this or else it fails to display in it. Remember to do this if gallery isn't overhauled to alleviate this.
#init 1 python:

# This would be for assets that aren't automatically namespaced by renpy.
init -1 python:
    DEFAULT_IMAGE_EXTENSION = ".png"
    DEFAULT_VIDEO_EXTENSION = ".webm"



#
#   SYSTEM
#

# For displaying nothing
image spr_null = Null()

# Generic images for sprite and background uses, non-assets
# TODO: See if Solid() does anything different, because 'image (color) = (hexcode)' creates an image of only the screen's dimensions.
image white = "#ffffff"
image black = "#000000"
image paper_color = "#ede6e6"


image anim_caveintro:
    "spr_caveintro"
    alpha 0
    time 0.5
    linear 3.5 alpha 1
    time 10
    linear 1 alpha 0


#
#   UI
#

image pickicon_smaller = "gui/ctc/ui_pickicon_smaller" + DEFAULT_IMAGE_EXTENSION

# Click-to-continue icons / animations
image ctc_end_marker:
    "pickicon_smaller"
    # xalign 0.925 yalign 0.98
    alpha 0
    linear 0.25 alpha 1
   
image ctc_mid_marker:
    "pickicon_smaller"
    # xalign 0.925 yalign 0.98
    alpha 0
    linear 0.25 alpha 1


image spr_ui_logo = Composite(
    (1056, 950),
    (0, 0), "spr_ui_logo_title",
    (0, 0), "spr_ui_logo_stickynote"
)

#account for characters with long names (the asset for it is placeholder pls fixme)
define long_textbox_img = Image("gui/textbox_long.png", xalign=0.5, yalign=1.0)
define long_textbox = { "window_background": long_textbox_img, 'namebox_style': "namebox_large" }



#
# PROPS
#


# Inco's grocery bag
image spr_grocerybag_full = Composite(
    (129, 267),
    (0, 0), "spr_grocerybag_part1",
    (0, 0), "spr_grocerybag_part2",
    (0, 0), "spr_grocerybag_part3"
)
image spr_grocerybag_incoverysad = Composite(
    (129, 267),
    (0, 0), "spr_grocerybag_part1",
    (0, 0), "spr_grocerybag_part2"
)
image spr_grocerybag_liz = "spr_grocerybag_part1"

#simple flash
define flash = Fade(.25, 0, .75, color="#fff")


# Crowd sprites
image spr_crowdbackdrop_left = Flatten("spr_crowdbackdrop_left_unflattened")
image spr_crowdbackdrop_right = Flatten("spr_crowdbackdrop_right_unflattened")
image spr_crowdbackdrop_left_unflattened:
    contains:
        "spr_crowdperson_watching3"
        xpos 0.3 xanchor 0.5
        matrixcolor ColorizeMatrix("#252e06", "#ffffff")
    contains:
        "spr_crowdperson_idle1"
        xpos 0.2 xanchor 0.5
        matrixcolor ColorizeMatrix("#042838", "#ffffff")
    contains:
        "spr_crowdperson_watching2"
        xpos 0.4 xanchor 0.5
        matrixcolor ColorizeMatrix("#0e272b", "#ffffff")
    contains:
        "spr_crowdperson_idle3"
        xpos 0.5 xanchor 0.5
        matrixcolor ColorizeMatrix("#2b0111", "#ffffff")
    contains:
        "spr_crowdperson_idle2"
        xpos 0.05 xanchor 0.5
        matrixcolor ColorizeMatrix("#4e0000", "#ffffff")

image spr_crowdbackdrop_right_unflattened:
    contains:
        "spr_crowdperson_chilling1"
        xpos 0.65 xzoom -1 xanchor 0.5
        matrixcolor ColorizeMatrix("#18093a", "#ffffff")
    contains:
        "spr_crowdperson_chilling3"
        xpos 0.85 xzoom -1 xanchor 0.5
        matrixcolor ColorizeMatrix("#4e2305", "#ffffff")
    contains:
        "spr_crowdperson_phone1"
        xpos 1.0 xzoom -1 xanchor 0.5
        matrixcolor ColorizeMatrix("#04031a", "#ffffff")
    contains:
        "spr_crowdperson_chilling2"
        xpos 0.7 xzoom -1 xanchor 0.5
        matrixcolor ColorizeMatrix("#0a422d", "#ffffff")



image spr_crowdbackdrop_back_right = Flatten("spr_crowdbackdrop_cafeteria_back_right_unflattened")
image spr_crowdbackdrop_back_left = Flatten("spr_crowdbackdrop_cafeteria_back_left_unflattened")
image spr_crowdbackdrop_front_right = Flatten("spr_crowdbackdrop_cafeteria_front_right_unflattened")
image spr_crowdbackdrop_front_left = Flatten("spr_crowdbackdrop_cafeteria_front_left_unflattened")

image spr_crowdbackdrop_cafeteria_back_right_unflattened:
    contains:
        "spr_crowdperson_chilling1"
        ypos 0.0 - 0.05 xpos 0.37
        matrixcolor ColorizeMatrix("#13390A", "#ffffff")
    contains:
        "spr_crowdperson_chilling2"
        ypos 0.0 - 0.05 xpos -0.07 xzoom -1
        matrixcolor ColorizeMatrix("#2C242B", "#ffffff")
    contains:
        "spr_crowdperson_idle1"
        ypos 0.0 - 0.05 xpos 0.29
        matrixcolor ColorizeMatrix("#1B1920", "#ffffff")
    contains:
        "spr_crowdperson_idle3"
        ypos 0.0 - 0.05 xpos 0.16
        matrixcolor ColorizeMatrix("#2D3B33", "#ffffff")
    contains:
        "spr_crowdperson_phone2"
        ypos 0.0 - 0.05 xpos 0.03
        matrixcolor ColorizeMatrix("#431D10", "#ffffff")
    contains:
        "spr_crowdperson_watching1"
        ypos 0.0 - 0.05 xpos 0.14 xzoom -1
        matrixcolor ColorizeMatrix("#0E3820", "#ffffff")
    contains:
        "spr_crowdperson_watching2"
        ypos 0.0 - 0.05 xpos 0.36 xzoom -1
        matrixcolor ColorizeMatrix("#4D191A", "#ffffff")

image spr_crowdbackdrop_cafeteria_back_left_unflattened:
    contains:
        "spr_crowdperson_chilling3"
        ypos 0.0 - 0.05 xpos 0.39
        matrixcolor ColorizeMatrix("#0B343B", "#ffffff")
    contains:
        "spr_crowdperson_idle2"
        ypos 0.0 - 0.05 xpos 0.04
        matrixcolor ColorizeMatrix("#3B0C0E", "#ffffff")
    contains:
        "spr_crowdperson_phone1"
        ypos 0.0 - 0.05 xpos 0.27
        matrixcolor ColorizeMatrix("#3A3221", "#ffffff")
    contains:
        "spr_crowdperson_phone3"
        ypos 0.0 - 0.05 xpos 0.21
        matrixcolor ColorizeMatrix("#3F2440", "#ffffff")
    contains:
        "spr_crowdperson_watching3"
        ypos 0.0 - 0.05 xpos 0.12
        matrixcolor ColorizeMatrix("#162C48", "#ffffff")

image spr_crowdbackdrop_cafeteria_front_left_unflattened:
    contains:
        "spr_crowdperson_chilling2"
        ypos 0.04 - 0.05 xpos 0.41 xzoom -1
        matrixcolor ColorizeMatrix("#7C5D69", "#ffffff")
    contains:
        "spr_crowdperson_idle1"
        ypos 0.0 - 0.05 xpos 0.53
        matrixcolor ColorizeMatrix("#49958C", "#ffffff")
    contains:
        "spr_crowdperson_idle3"
        ypos -0.05 - 0.05 xpos -0.06
        matrixcolor ColorizeMatrix("#A47B3A", "#ffffff")
    contains:
        "spr_crowdperson_chilling1"
        ypos -0.05 - 0.05 xpos 0.14
        matrixcolor ColorizeMatrix("#9B9931", "#ffffff")
    contains:
        "spr_crowdperson_watching1"
        ypos -0.02 - 0.05 xpos 0.34
        matrixcolor ColorizeMatrix("#323565", "#ffffff")
    contains:
        "spr_crowdperson_watching2"
        ypos -0.01 - 0.05 xpos 0.1
        matrixcolor ColorizeMatrix("#4E5A27", "#ffffff")

image spr_crowdbackdrop_cafeteria_front_right_unflattened:
    contains:
        "spr_crowdperson_chilling3"
        ypos 0.0 - 0.05 xpos 0.13
        matrixcolor ColorizeMatrix("#577E56", "#ffffff")
    contains:
        "spr_crowdperson_idle2"
        ypos -0.05 - 0.05 xpos 0.37
        matrixcolor ColorizeMatrix("#588595", "#ffffff")
    contains:
        "spr_crowdperson_phone1"
        ypos 0.04 - 0.05 xpos 0.16
        matrixcolor ColorizeMatrix("#7E4AAE", "#ffffff")
    contains:
        "spr_crowdperson_phone3"
        ypos 0.0 - 0.05 xpos 0.03 xzoom -1
        matrixcolor ColorizeMatrix("#4C6A58", "#ffffff")

# Hacks for crowd transition
image spr_crowdperson_watching4 = "spr_crowdperson_watching1"
image spr_crowdperson_idle4 = "spr_crowdperson_idle3"


#
#   ANIMATIONS
#

# Main menu background

# 8 fps
image anim_fountain_background:
    "anim_fountain_background_f1"
    pause 0.125
    "anim_fountain_background_f2"
    pause 0.125
    "anim_fountain_background_f3"
    pause 0.125
    "anim_fountain_background_f4"
    pause 0.125
    "anim_fountain_background_f5"
    pause 0.125
    "anim_fountain_background_f6"
    pause 0.125
    repeat


# Inco's intro
image anim_incointro = Movie(play="animations/anim_incointro" + DEFAULT_VIDEO_EXTENSION, loop=False)

# Ben's intro
image anim_benintro1 = Composite(
    (1920, 1080),
    (0, 0), "anim_benintro_background",
    (0, 0), "anim_benintro_ben1"
)
image anim_benintro2 = Composite(
    (1920, 1080),
    (0, 0), "anim_benintro_background",
    (0, 0), "anim_benintro_ben2"
)
image anim_benintro3 = Movie(play="animations/ben/anim_benintro_standup" + DEFAULT_VIDEO_EXTENSION, 
                            start_image="animations/ben/anim_benintro_ben2" + DEFAULT_IMAGE_EXTENSION, 
                            loop=False)

# Olivia's intro
image anim_oliviaintro2 = Movie(play="animations/olivia/anim_oliviaintro2" + DEFAULT_VIDEO_EXTENSION,
                                start_image="animations/olivia/anim_oliviaintro1" + DEFAULT_IMAGE_EXTENSION,
                                image="animations/olivia/anim_oliviaintro3" + DEFAULT_IMAGE_EXTENSION,
                                loop=False)

# Pool dunk animation
image anim_pooldunk1:
    contains:
        "anim_pooldunk_background"
    contains:
        "anim_pooldunk_group1"
    contains:
        "anim_pooldunk_f1"
image anim_pooldunk2:
    contains:
        "anim_pooldunk_background"
    contains:
        "anim_pooldunk_group1"
    contains:
        "anim_pooldunk_f2"
image anim_pooldunk3:
    contains:
        "anim_pooldunk_background"
    contains:
        "anim_pooldunk_group1"
    contains:
        # 12 fps
        "anim_pooldunk_f3"
        pause 0.08333
        "anim_pooldunk_f4"
        pause 0.08333
        "anim_pooldunk_f5"
        pause 0.08333
        "anim_pooldunk_f6"
        pause 0.08333
        "anim_pooldunk_f7"
image anim_pooldunk4:
    contains:
        "anim_pooldunk_background"
    contains:
        "anim_pooldunk_group1"
    contains:
        # 8 fps
        "anim_pooldunk_f8"
        pause 0.125
        "anim_pooldunk_f9"
        pause 0.125
        "anim_pooldunk_f10"
        pause 0.125
        "anim_pooldunk_f11"
        pause 0.125
        "anim_pooldunk_f12"
    contains:
        "white"
        alpha 0.0
        pause 0.5 # 4 frames
        linear 0.125 alpha 1 # 1 frames
image anim_pooldunk5:
    contains:
        "anim_pooldunk_background"
    contains:
        "anim_pooldunk_group2"
    contains:
        "anim_pooldunk_f12"


#
#   METRO RANDY ANIMATIONS
#

# pause 0.083 = 12fps

image spr_metrorandy_hoe:
    # WHAT THE FUCK. WHY DOES THIS FUCKING CONTAINS SHIT NOT BE AFFECTED BY XALIGN OR YALIGN OUTSIDE OF HERE, WHY DOES IT ONLY AFFECT THIS BITCH
    # AND WHY THE FUCK DO I HAVE TO MANUALLY PUT IN SEEMINGLY ARBITRARY OFFSETS
    xoffset -27
    yoffset -551
    contains:
        "spr_metrorandy_hoe_body"
    contains:
        "spr_metrorandy_hoe_head"
image spr_metrorandy_hoe_bump:
    "spr_metrorandy_hoe_bump_f1"
    pause 0.083
    "spr_metrorandy_hoe_bump_f2"
    pause 0.083
    "spr_metrorandy_hoe_bump_f3"
    pause 0.083
    "spr_metrorandy_hoe"
image spr_metrorandy_hoe_blink:
    xoffset -27
    yoffset -551
    contains:
        "spr_metrorandy_hoe_body"
    contains:
        "spr_metrorandy_hoe_head_blink_f1"
        pause 0.083
        "spr_metrorandy_hoe_head_blink_f2"
        pause 0.083
        "spr_metrorandy_hoe_head"

image spr_metrorandy_rebels = "spr_metrorandy_rebels_bump_f1"
image spr_metrorandy_rebels_bump:
    "spr_metrorandy_rebels_bump_f2"
    pause 0.083
    "spr_metrorandy_rebels_bump_f3"
    pause 0.083
    "spr_metrorandy_rebels_bump_f4"
    pause 0.083
    "spr_metrorandy_rebels_bump_f1"

image spr_metrorandy_paperguy = "spr_metrorandy_paperguy_bump_f1"
image spr_metrorandy_paperguy_bump:
    "spr_metrorandy_paperguy_bump_f2"
    pause 0.083
    "spr_metrorandy_paperguy_bump_f3"
    pause 0.083
    "spr_metrorandy_paperguy_bump_f4"
    pause 0.083
    "spr_metrorandy_paperguy_bump_f1"

image spr_metrorandy_paperguy_turnpage:
    "spr_metrorandy_paperguy_turnpage_f1"
    pause 0.166
    "spr_metrorandy_paperguy_turnpage_f2"
    pause 0.166
    "spr_metrorandy_paperguy_turnpage_f3"
    pause 0.166
    "spr_metrorandy_paperguy_bump_f1"
    pause 0.166



#
#   METRO FERRIS ANIMATIONS
#

# pause 0.0416 = 24fps

# blinking
image spr_metroferris_blink_neutral:
    "spr_metroferris_eyelid_f2"
    pause 0.0416
    "spr_metroferris_eyelid_f3"
    pause 0.0416
    "spr_metroferris_eyelid_f4"
    pause 0.0416
    "spr_metroferris_eyelid_f3"
    pause 0.0416
    "spr_metroferris_eyelid_f2"
    pause 0.0416
    "spr_metroferris_eyelid_f1"
image spr_metroferris_blink_skeptical:
    "spr_metroferris_eyelid_f3"
    pause 0.0416
    "spr_metroferris_eyelid_f4"
    pause 0.0416
    "spr_metroferris_eyelid_f3"
    pause 0.0416
    "spr_metroferris_eyelid_f2"

# eye balls
image spr_metroferris_eye_lookleft:
    "spr_metroferris_eye_f2"
    pause 0.0416
    "spr_metroferris_eye_f3"
    pause 0.0416
    "spr_metroferris_eye_f4"
image spr_metroferris_eye_lookright:
    "spr_metroferris_eye_f3"
    pause 0.0416
    "spr_metroferris_eye_f2"
    pause 0.0416
    "spr_metroferris_eye_f1"

# eyebrows
image spr_metroferris_eyebrow_neutral_to_smirk:
    "spr_metroferris_eyebrow_f2"
    pause 0.0416
    "spr_metroferris_eyebrow_f3"
    pause 0.0416
    "spr_metroferris_eyebrow_f4"
image spr_metroferris_eyebrow_neutral_to_skeptical:
    "spr_metroferris_eyebrow_f1"
    yoffset -3
    pause 0.0416
    yoffset -12
    pause 0.0416
    yoffset -14
image spr_metroferris_eyebrow_smirk_to_neutral:
    "spr_metroferris_eyebrow_f3"
    pause 0.0416
    "spr_metroferris_eyebrow_f2"
    pause 0.0416
    "spr_metroferris_eyebrow_f1"
image spr_metroferris_eyebrow_smirk_to_skeptical:
    "spr_metroferris_eyebrow_f3"
    yoffset -3
    pause 0.0416
    "spr_metroferris_eyebrow_f2"
    yoffset -12
    pause 0.0416
    "spr_metroferris_eyebrow_f1"
    yoffset -14
image spr_metroferris_eyebrow_skeptical_to_neutral:
    "spr_metroferris_eyebrow_f1"
    yoffset -12
    pause 0.0416
    yoffset -3
    pause 0.0416
    yoffset 0
image spr_metroferris_eyebrow_skeptical_to_smirk:
    "spr_metroferris_eyebrow_f1"
    yoffset -12
    pause 0.0416
    "spr_metroferris_eyebrow_f2"
    yoffset -3
    pause 0.0416
    "spr_metroferris_eyebrow_f3"
    yoffset 0

image spr_metroferris_mouth_neutral_to_considering:
    "spr_metroferris_mouth_frown_f1"
    pause 0.0416
    "spr_metroferris_mouth_frown_f2"
    pause 0.0416
    "spr_metroferris_mouth_frown_f3"
image spr_metroferris_mouth_neutral_to_smirk:
    "spr_metroferris_mouth_smile_f1"
    pause 0.0416
    "spr_metroferris_mouth_smile_f2"
    pause 0.0416
    "spr_metroferris_mouth_smile_f3"
image spr_metroferris_mouth_considering_to_neutral:
    "spr_metroferris_mouth_frown_f2"
    pause 0.0416
    "spr_metroferris_mouth_frown_f1"
    pause 0.0416
    "spr_metroferris_mouth_neutral"
image spr_metroferris_mouth_considering_to_smirk:
    "spr_metroferris_mouth_frown_f3"
    pause 0.0416
    "spr_metroferris_mouth_frown_f1"
    pause 0.0416
    "spr_metroferris_mouth_smile_f1"
    pause 0.0416
    "spr_metroferris_mouth_smile_f3"
image spr_metroferris_mouth_smirk_to_neutral:
    "spr_metroferris_mouth_smile_f2"
    pause 0.0416
    "spr_metroferris_mouth_smile_f1"
    pause 0.0416
    "spr_metroferris_mouth_neutral"
image spr_metroferris_mouth_smirk_to_considering:
    "spr_metroferris_mouth_smile_f3"
    pause 0.0416
    "spr_metroferris_mouth_smile_f1"
    pause 0.0416
    "spr_metroferris_mouth_frown_f1"
    pause 0.0416
    "spr_metroferris_mouth_frown_f3"


# facial expressions

image spr_metroferris_face_neutral:
    contains:
        "spr_metroferris_mouth_neutral"
    contains:
        "spr_metroferris_eyebrow_f1"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_neutral_nomouth:
    contains:
        "spr_metroferris_eyebrow_f1"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_smirk:
    contains:
        "spr_metroferris_mouth_smirk_f3"
    contains:
        "spr_metroferris_eyebrow_f4"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_considering:
    contains:
        "spr_metroferris_mouth_frown_f3"
    contains:
        "spr_metroferris_eyebrow_f1"
    contains:
        "spr_metroferris_eye_f4"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_skeptical:
    contains:
        "spr_metroferris_mouth_neutral"
    contains:
        "spr_metroferris_eyebrow_f1"
        yoffset -14
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f2"
        block:
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            pause 5
            "spr_metroferris_blink_skeptical"
            pause 0.5
            "spr_metroferris_blink_skeptical"
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 4.5
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            repeat

# facial transitions

image spr_metroferris_face_neutral_to_considering:
    contains:
        "spr_metroferris_mouth_neutral_to_considering"
    contains:
        "spr_metroferris_eyebrow_f1"
    contains:
        "spr_metroferris_eye_lookleft"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_neutral_to_smirk:
    contains:
        "spr_metroferris_mouth_neutral_to_smirk"
    contains:
        "spr_metroferris_eyebrow_neutral_to_smirk"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_neutral_to_skeptical:
    contains:
        "spr_metroferris_mouth_neutral"
    contains:
        "spr_metroferris_eyebrow_neutral_to_skeptical"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        pause 0.0416
        "spr_metroferris_eyelid_f2"
        block:
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            pause 5
            "spr_metroferris_blink_skeptical"
            pause 0.5
            "spr_metroferris_blink_skeptical"
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 4.5
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            repeat
image spr_metroferris_face_considering_to_neutral:
    contains:
        "spr_metroferris_mouth_considering_to_neutral"
    contains:
        "spr_metroferris_eyebrow_f1"
    contains:
        "spr_metroferris_eye_lookright"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_considering_to_smirk:
    contains:
        "spr_metroferris_mouth_considering_to_smirk"
    contains:
        "spr_metroferris_eyebrow_neutral_to_smirk"
    contains:
        "spr_metroferris_eye_lookright"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_considering_to_skeptical:
    contains:
        "spr_metroferris_mouth_considering_to_neutral"
    contains:
        "spr_metroferris_eyebrow_neutral_to_skeptical"
    contains:
        "spr_metroferris_eye_lookright"
    contains:
        "spr_metroferris_eyelid_f1"
        pause 0.0416
        "spr_metroferris_eyelid_f2"
        block:
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            pause 5
            "spr_metroferris_blink_skeptical"
            pause 0.5
            "spr_metroferris_blink_skeptical"
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 4.5
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            repeat
image spr_metroferris_face_smirk_to_neutral:
    contains:
        "spr_metroferris_mouth_smirk_to_neutral"
    contains:
        "spr_metroferris_eyebrow_smirk_to_neutral"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_smirk_to_considering:
    contains:
        "spr_metroferris_mouth_smirk_to_considering"
    contains:
        "spr_metroferris_eyebrow_smirk_to_neutral"
    contains:
        "spr_metroferris_eye_lookleft"
    contains:
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_smirk_to_skeptical:
    contains:
        "spr_metroferris_mouth_smirk_to_neutral"
    contains:
        "spr_metroferris_eyebrow_smirk_to_skeptical"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f1"
        pause 0.0416
        "spr_metroferris_eyelid_f2"
        block:
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            pause 5
            "spr_metroferris_blink_skeptical"
            pause 0.5
            "spr_metroferris_blink_skeptical"
            pause 4
            "spr_metroferris_blink_skeptical"
            pause 4.5
            "spr_metroferris_blink_skeptical"
            pause 3.5
            "spr_metroferris_blink_skeptical"
            repeat
image spr_metroferris_face_skeptical_to_neutral:
    contains:
        "spr_metroferris_mouth_neutral"
    contains:
        "spr_metroferris_eyebrow_skeptical_to_neutral"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f2"
        pause 0.0416
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_skeptical_to_considering:
    contains:
        "spr_metroferris_mouth_neutral_to_considering"
    contains:
        "spr_metroferris_eyebrow_skeptical_to_neutral"
    contains:
        "spr_metroferris_eye_lookleft"
    contains:
        "spr_metroferris_eyelid_f2"
        pause 0.0416
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat
image spr_metroferris_face_skeptical_to_smirk:
    contains:
        "spr_metroferris_mouth_neutral_to_smirk"
    contains:
        "spr_metroferris_eyebrow_skeptical_to_smirk"
    contains:
        "spr_metroferris_eye_f1"
    contains:
        "spr_metroferris_eyelid_f2"
        pause 0.0416
        "spr_metroferris_eyelid_f1"
        block:
            pause 4
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            pause 5
            "spr_metroferris_blink_neutral"
            pause 0.5
            "spr_metroferris_blink_neutral"
            pause 4
            "spr_metroferris_blink_neutral"
            pause 4.5
            "spr_metroferris_blink_neutral"
            pause 3.5
            "spr_metroferris_blink_neutral"
            repeat