# Remember if you do multiple layeredimages of the same character, you gotta put defaults for each!

# EVIDENTLY while I was testing out character shit, this current configuation of having attributes assigned to whole sprites
# under no groups doesn't replace sprites when a different attribute is called, it gets added ontop of the sprite that's
# currently shown

# EVEN MORE FUCKING EVIDENTLY, AS I DISCOVERED WHILE TRYING TO MAKE TRANSFORMS WORK,
# If you put attributes in the root of the layeredimage (i.e not in an group), they get applied everytime the tag is called.
# Not sprite, TAG. If you have a sprite like "olivia neutral" and you use a show statement like "show olivia" then the attributes
# in the root of the layeredimage get applied no matter what, even if you're just using it to change unrelated transform properties.

# Due to the use of offset, rotations also become dumb. I guess the offset gets unapplied as soon as you mess with rotation, so you have to re-apply them.
# Probably has something to do with layeredimages and reapplying properties when called with the show statement now matter what
#
# WRONG, this causes the sprite to snap is if there was no offset
# show olivia:
#    linear 3 rotate 180
#
# RIGHT, this will rotate in the correct spot
# show olivia:
#    yoffset (offset of the sprite)
#    linear 3 rotate 180


# Good thing renpy automatically crops images to the bounding box of visible pixels, because that probably means images with no pixels don't impact performance very much.
# Not using renpy's automatic displayable searching for layeredimages for the sake of readability
# TODO: Consider using layeredimage's automatic name parser for images on most things for mod support.



#
#   INCO
#

# Tier 1
layeredimage inco:
    xanchor 0.5
    # This prevents overlapping transluscent layers being visible, making sure the sprite look like it's just one sprite.
    # Possible downside is it eats up performance, possibly CPU and/or GPU. It's basically placebo in normal circumstances, but something to keep in mind.
    # TODO: Consider turning off mesh rendering on sprites for mobile ports.
    mesh True

    group outfit:
        attribute normal default "spr_inco_body_normal"
        attribute gym "spr_inco_body_gym"

    # body sweat
    group sweat:
        if_not "gym"
        attribute sweat: 
            blend 'multiply'
            "spr_inco_body_normal_sweat"
        attribute nosweat "spr_null"
    group sweat:
        if_any "gym"
        attribute sweat: 
            blend 'multiply'
            "spr_inco_body_gym_sweat"

    # hand
    group carrying_item:
        if_not "gym"
        attribute carrying_nothing default "spr_inco_hand_open"
        attribute carrying_bag "spr_inco_hand_closed"
    # bag
    group carrying_item:
        if_not "gym"
        attribute carrying_bag:
            xoffset 300 yoffset 843
            "spr_grocerybag_full"

    # expressions
    group face:
        attribute neutral default "spr_null"
        attribute happy "spr_inco_face_happy"
        attribute annoyed "spr_inco_face_annoyed"
        attribute angry "spr_inco_face_angry"
        attribute considering "spr_inco_face_considering"
        attribute sad "spr_inco_face_sad"
        attribute concerned "spr_inco_face_sad"
        attribute smug "spr_inco_face_smug"
        attribute surprised "spr_inco_face_surprised"
        attribute shocked "spr_inco_face_shocked"
        attribute skeptical "spr_inco_face_considering"
        attribute blank "spr_null"

    # face sweat
    group sweat:
        attribute sweat "spr_inco_face_sweat"

    # glasses
    group face:
        if_any "glasses"
        attribute neutral default "spr_inco_glasses_up"
        attribute happy "spr_inco_glasses_up"
        attribute annoyed "spr_inco_glasses_up"
        attribute angry "spr_inco_glasses_down"
        attribute considering "spr_inco_glasses_down"
        attribute sad "spr_inco_glasses_down"
        attribute concerned "spr_inco_glasses_up"
        attribute smug "spr_inco_glasses_up"
        attribute surprised "spr_inco_glasses_up"
        attribute shocked "spr_inco_glasses_down"
        attribute skeptical "spr_inco_glasses_up"
    # Dummy group to toggle glasses for the above face glasses group
    group glasses:
        attribute glasses default "spr_null"
        attribute noglasses "spr_null"

image inco left = LayeredImageProxy("inco", Transform(xzoom=-1.0))
image inco right = LayeredImageProxy("inco", Transform(xzoom=1.0))


# Unfortunately, for ease of use for keeping the 'left' and 'right' attributes between sprites, we have to do this bloat.

# Tier 2
layeredimage inco furious:
    xanchor 0.5
    always "spr_inco_furious"

image inco furious left = LayeredImageProxy("inco furious", Transform(xzoom=-1.0))
image inco furious right = LayeredImageProxy("inco furious", Transform(xzoom=1.0))


layeredimage inco thinking:
    xanchor 0.5
    always "spr_inco_thinking"

image inco thinking left = LayeredImageProxy("inco thinking", Transform(xzoom=-1.0))
image inco thinking right = LayeredImageProxy("inco thinking", Transform(xzoom=1.0))


layeredimage inco explaining:
    xanchor 0.5
    always "spr_inco_explaining"

image inco explaining left = LayeredImageProxy("inco explaining", Transform(xzoom=-1.0))
image inco explaining right = LayeredImageProxy("inco explaining", Transform(xzoom=1.0))


layeredimage inco verysad:
    xanchor 0.5
    mesh True

    always "spr_inco_verysad"
    group carrying_item:
        attribute carrying_bag:
            xoffset 312 yoffset 813 xzoom -1.0
            "spr_grocerybag_incoverysad"
        attribute carrying_nothing "spr_null"

image inco verysad left = LayeredImageProxy("inco verysad", Transform(xzoom=-1.0))
image inco verysad right = LayeredImageProxy("inco verysad", Transform(xzoom=1.0))


layeredimage inco terrified:
    xanchor 0.5
    always "spr_inco_terrified"

image inco terrified left = LayeredImageProxy("inco terrified", Transform(xzoom=-1.0))
image inco terrified right = LayeredImageProxy("inco terrified", Transform(xzoom=1.0))


layeredimage inco unimpressed:
    xanchor 0.5
    always "spr_inco_unimpressed"

image inco unimpressed left = LayeredImageProxy("inco unimpressed", Transform(xzoom=-1.0))
image inco unimpressed right = LayeredImageProxy("inco unimpressed", Transform(xzoom=1.0))


layeredimage inco yiiking:
    xanchor 0.5
    always "spr_inco_yiiking"
image inco yiiking left = LayeredImageProxy("inco yiiking", Transform(xzoom=-1.0))
image inco yiiking right = LayeredImageProxy("inco yiiking", Transform(xzoom=1.0))


# Tier 3
layeredimage inco falling:
    xanchor 0.5
    always "spr_inco_falling"

image inco falling left = LayeredImageProxy("inco falling", Transform(xzoom=-1.0))
image inco falling right = LayeredImageProxy("inco falling", Transform(xzoom=1.0))






#
#   OLIVIA
#

layeredimage olivia:
    xanchor 0.5
    yoffset -150
    group expressions:
        # Tier 1
        attribute neutral default:
            "spr_olivia_neutral"
        attribute happy:
            "spr_olivia_happy"
        attribute cheerful:
            "spr_olivia_cheerful"
        attribute annoyed:
            "spr_olivia_annoyed"
        attribute considering:
            "spr_olivia_considering"
        attribute surprised:
            "spr_olivia_surprised"
        attribute sad:
            "spr_olivia_sad"
        attribute shocked:
            "spr_olivia_shocked"
        attribute angry:
            "spr_olivia_angry"
        attribute skeptical:
            "spr_olivia_skeptical"
        attribute somberdown:
            "spr_olivia_somberdown"
        attribute somber:
            "spr_olivia_somber"
        attribute grin:
            "spr_olivia_grin"
        attribute neutraldown:
            "spr_olivia_neutraldown"
        attribute shockeddown:
            "spr_olivia_shockeddown"
        attribute grindown:
            "spr_olivia_grindown"
        # Tier 2
        attribute attentive:
            "spr_olivia_attentive"
        attribute embarassed:
            "spr_olivia_embarassed"
        attribute excited:
            "spr_olivia_excited"
        attribute grumpy:
            "spr_olivia_grumpy"
        attribute hmph:
            "spr_olivia_hmph"
        attribute furious:
            "spr_olivia_furious"
        attribute ugh:
            "spr_olivia_ugh"
        attribute canteen:
            "spr_olivia_canteen"
        attribute canteeneyes:
            "spr_olivia_canteeneyes"
        attribute hoodie:
            "spr_olivia_hoodie"
        attribute hoodieflipoff:
            "spr_olivia_hoodieflipoff"

image olivia left = LayeredImageProxy("olivia", Transform(xzoom=-1.0))
image olivia right = LayeredImageProxy("olivia", Transform(xzoom=1.0))


layeredimage olivia pool:
    xanchor 0.5
    yoffset -150
    group expressions:
        # Tier 1
        attribute neutral default:
            "spr_olivia_pool_neutral"
        attribute happy:
            "spr_olivia_pool_happy"
        attribute annoyed:
            "spr_olivia_pool_annoyed"
        attribute considering:
            "spr_olivia_pool_considering"
        attribute consideringsmile:
            "spr_olivia_pool_consideringgrin"
        attribute surprised:
            "spr_olivia_pool_surprised"
        attribute angry:
            "spr_olivia_pool_angry"
        attribute somberdown:
            "spr_olivia_pool_somberdown"
        attribute somber:
            "spr_olivia_pool_somber"
        attribute shocked:
            "spr_olivia_pool_shocked"

image olivia pool left = LayeredImageProxy("olivia pool", Transform(xzoom=-1.0))
image olivia pool right = LayeredImageProxy("olivia pool", Transform(xzoom=1.0))

layeredimage oliviatail:
    xanchor 0.5
    yoffset -150
    always "spr_olivia_pool_tail"

image oliviatail right = Transform("oliviatail", xzoom=-1.0)
image oliviatail left = Transform("oliviatail", xzoom=-1.0)




#
#   BEN
#

# Tier 1
layeredimage ben:
    xanchor 0.5
    mesh True

    group outfit: 
        attribute normal default "spr_ben_body_normal"

    group face:
        attribute neutral default "spr_ben_face_neutral"
        attribute angry "spr_ben_face_angry"
        attribute considering "spr_ben_face_considering"
        attribute explaining "spr_ben_face_explaining"
        attribute happy "spr_ben_face_happy"
        attribute sad "spr_ben_face_sad"
        attribute shocked "spr_ben_face_shocked"
        attribute unimpressed "spr_ben_face_unimpressed"
        attribute skeptical "spr_ben_face_skeptical"
        attribute surprised "spr_ben_face_surprised"

    group outfit: 
        attribute normal default "spr_ben_hair_normal"

    group glasses:
        attribute glasses default "spr_ben_glasses"
        attribute no_glasses "spr_null"

image ben left = LayeredImageProxy("ben", Transform(xzoom=-1.0))
image ben right = LayeredImageProxy("ben", Transform(xzoom=1.0))


# Tier 2
layeredimage ben apathetic:
    xanchor 0.5
    always "spr_ben_apathetic"

image ben apathetic left = LayeredImageProxy("ben apathetic", Transform(xzoom=-1.0))
image ben apathetic right = LayeredImageProxy("ben apathetic", Transform(xzoom=1.0))


layeredimage ben verysad:
    xanchor 0.5
    always "spr_ben_verysad"

image ben verysad left = LayeredImageProxy("ben verysad", Transform(xzoom=-1.0))
image ben verysad right = LayeredImageProxy("ben verysad", Transform(xzoom=1.0))


layeredimage ben devious:
    xanchor 0.5
    always "spr_ben_devious"

image ben devious left = LayeredImageProxy("ben devious", Transform(xzoom=-1.0))
image ben devious right = LayeredImageProxy("ben devious", Transform(xzoom=1.0))


layeredimage ben nervous:
    xanchor 0.5
    always "spr_ben_nervous"

image ben nervous left = LayeredImageProxy("ben nervous", Transform(xzoom=-1.0))
image ben nervous right = LayeredImageProxy("ben nervous", Transform(xzoom=1.0))


layeredimage ben sheepish:
    xanchor 0.5
    always "spr_ben_sheepish"

image ben sheepish left = LayeredImageProxy("ben sheepish", Transform(xzoom=-1.0))
image ben sheepish right = LayeredImageProxy("ben sheepish", Transform(xzoom=1.0))


layeredimage ben evil:
    xanchor 0.5
    always "spr_ben_evil"

image ben evil left = LayeredImageProxy("ben evil", Transform(xzoom=-1.0))
image ben evil right = LayeredImageProxy("ben evil", Transform(xzoom=1.0))


layeredimage ben cheerful:
    xanchor 0.5
    mesh True

    always "spr_ben_body_normal_cheerful"
    always "spr_ben_face_cheerful"
    always "spr_ben_hair_normal"

    group glasses:
        attribute glasses default "spr_ben_glasses"
        attribute no_glasses "spr_null"

    always "spr_ben_body_normal_cheerfularm"

image ben cheerful left = LayeredImageProxy("ben cheerful", Transform(xzoom=-1.0))
image ben cheerful right = LayeredImageProxy("ben cheerful", Transform(xzoom=1.0))






#
#   DAMIEN
#

# Tier 1
layeredimage damien:
    xanchor 0.5
    mesh True

    # body
    group outfit:
        attribute normal default "spr_damien_body_normal"
        attribute gym "spr_damien_body_gym"

    group face:
        attribute neutral default "spr_damien_face_neutral"
        attribute angry "spr_damien_face_angry"
        attribute angryup "spr_damien_face_angryup"
        attribute angryconsidering "spr_damien_face_angryconsidering"
        attribute angrydown "spr_damien_face_angrydown"
        attribute considering "spr_damien_face_considering"
        attribute neutralconsidering "spr_damien_face_neutralconsidering"
        attribute happy "spr_damien_face_happy"
        attribute pog "spr_damien_face_pog"
        attribute sad "spr_damien_face_sad"
        attribute shocked "spr_damien_face_shocked"
        attribute skeptical "spr_damien_face_skeptical"

    # hair
    group outfit:
        attribute normal default "spr_damien_hair_normal"
        attribute gym "spr_damien_hair_normal"

image damien left = LayeredImageProxy("damien", Transform(xzoom=-1.0))
image damien right = LayeredImageProxy("damien", Transform(xzoom=1.0))


# Tier 2
layeredimage damien furious:
    always "spr_damien_furious"

image damien furious left = LayeredImageProxy("damien furious", Transform(xzoom=-1.0))
image damien furious right = LayeredImageProxy("damien furious", Transform(xzoom=1.0))


layeredimage damien pondering:
    always "spr_damien_pondering"

image damien pondering left = LayeredImageProxy("damien pondering", Transform(xzoom=-1.0))
image damien pondering right = LayeredImageProxy("damien pondering", Transform(xzoom=1.0))


layeredimage damien thinking:
    always "spr_damien_thinking"

image damien thinking left = LayeredImageProxy("damien thinking", Transform(xzoom=-1.0))
image damien thinking right = LayeredImageProxy("damien thinking", Transform(xzoom=1.0))


layeredimage damien sheepish:
    always "spr_damien_sheepish"

image damien sheepish left = LayeredImageProxy("damien sheepish", Transform(xzoom=-1.0))
image damien sheepish right = LayeredImageProxy("damien sheepish", Transform(xzoom=1.0))


layeredimage damien terrified:
    always "spr_damien_terrified"

image damien terrified left = LayeredImageProxy("damien terrified", Transform(xzoom=-1.0))
image damien terrified right = LayeredImageProxy("damien terrified", Transform(xzoom=1.0))


layeredimage damien verysad:
    always "spr_damien_verysad"

image damien verysad left = LayeredImageProxy("damien verysad", Transform(xzoom=-1.0))
image damien verysad right = LayeredImageProxy("damien verysad", Transform(xzoom=1.0))


layeredimage damien cheerful:
    group body:
        attribute normal default "spr_damien_body_normal_cheerful"
        attribute gym "spr_damien_body_gym_cheerful"

    always "spr_damien_face_cheerful"
    always "spr_damien_hair_normal"

image damien cheerful left = LayeredImageProxy("damien cheerful", Transform(xzoom=-1.0))
image damien cheerful right = LayeredImageProxy("damien cheerful", Transform(xzoom=1.0))






#
#   IADAKAN
#

layeredimage iadakan:
    xanchor 0.5
    group expressions:
        # Tier 1
        attribute neutral default "spr_iadakan_neutral"
        attribute angry "spr_iadakan_angry"
        attribute considering "spr_iadakan_considering"
        attribute explaining "spr_iadakan_explaining"
        attribute happy "spr_iadakan_happy"
        attribute sad "spr_iadakan_sad"
        attribute surprised "spr_iadakan_surprised"
        attribute unimpressed "spr_iadakan_unimpressed"

        # Tier 2
        attribute concerned "spr_iadakan_concerned"
        attribute annoyed "spr_iadakan_annoyed"
        attribute excited "spr_iadakan_excited"
        attribute ugh "spr_iadakan_ugh"
        attribute eccentric 'spr_iadakan_eccentric'

image iadakan left = LayeredImageProxy("iadakan", Transform(xzoom=-1.0))
image iadakan right = LayeredImageProxy("iadakan", Transform(xzoom=1.0))



#
#   LIZ
#

# Liz's head offset positions
# These are effectively constants so when you call liz's sprites, the body is called normally but the head
# is a number + the body position, so her head is in the right place
# the last constants are just offsets for her necks and bodies
init -1 python:
    LIZHEADX_NEUTRAL = 0.11
    LIZHEADY_NEUTRAL = -0.15

    LIZHEADX_EXCITED = 0.08
    LIZHEADY_EXCITED = -0.06

    LIZHEADX_VERYSAD = 0.11
    LIZHEADY_VERYSAD = 0.0

    LIZHEADX_TERRIFIED = 0.07
    LIZHEADY_TERRIFIED = -0.14

    LIZHEADX_THINKING = 0.075
    LIZHEADY_THINKING = -0.08

    LIZHEADX_FURIOUS = 0.19
    LIZHEADY_FURIOUS = -0.12


    LIZHEAD_YOFFSET = -1207
    LIZBODY_YOFFSET = -1207


# Unfortunately, due to her neckiness it's more concise to define layeredimages for her tier 2 expressions. God forbid putting on different outfits

# Tier 1 and Tier 2
layeredimage lizbody:
    xanchor 0.5
    yoffset LIZBODY_YOFFSET
    group outfit:
        if_any "normal"
        attribute neutral default "spr_liz_body_neutral"
        attribute excited "spr_liz_body_excited"
        attribute verysad "spr_liz_body_verysad"
        attribute terrified "spr_liz_body_terrified"
        attribute thinking "spr_liz_body_thinking"
        attribute furious "spr_liz_body_furious"

    # Dummy group to toggle between the above groups
    group outfit_toggler:
        attribute normal default "spr_null"

image lizbody left = LayeredImageProxy("lizbody", Transform(xzoom=-1.0))
image lizbody right = LayeredImageProxy("lizbody", Transform(xzoom=1.0))



# Tier 1
layeredimage lizhead:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    # back hair
    group outfit:
        attribute normal default "spr_liz_normal_backhair"

    group neck:
        attribute n_down default "spr_liz_neck_neutral"

    group face:
        if_any "normal"
        attribute neutral default "spr_liz_face_normal_neutral"
        attribute angry "spr_liz_face_normal_angry"
        attribute considering "spr_liz_face_normal_considering"
        attribute explaining "spr_liz_face_normal_explaining"
        attribute happy "spr_liz_face_normal_happy"
        attribute sad "spr_liz_face_normal_sad"
        attribute shocked "spr_liz_face_normal_shocked"
        attribute unimpressed "spr_liz_face_normal_unimpressed"

    # front hair
    group outfit:
        attribute normal default "spr_liz_normal_fronthair"

    # hat shadow
    group hat:
        attribute hat:
            blend 'multiply'
            xoffset 256 yoffset 1356
            "spr_liz_hatshadow"
    # the hat
    group hat:
        attribute hat:
            xoffset 256 yoffset 1356
            "spr_liz_hat"
        attribute nohat "spr_null"

    group carrying_item:
        attribute carrying_nothing "spr_null"
        attribute carrying_bag:
            xoffset 380 yoffset 1580 xzoom -1.0
            "spr_grocerybag_liz"

    group salad:
        attribute salad "spr_liz_leaves"
        attribute nosalad "spr_null"

image lizhead left = LayeredImageProxy("lizhead", Transform(xzoom=-1.0))
image lizhead right = LayeredImageProxy("lizhead", Transform(xzoom=1.0))


# Tier 2
layeredimage lizhead excited:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    group neck:
        attribute n_down default "spr_liz_neck_excited"
    
    always "spr_liz_face_excited"

image lizhead excited left = LayeredImageProxy("lizhead excited", Transform(xzoom=-1.0))
image lizhead excited right = LayeredImageProxy("lizhead excited", Transform(xzoom=1.0))


layeredimage lizhead verysad:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    group neck:
        attribute n_down default "spr_liz_neck_verysad"

    always "spr_liz_face_verysad"

image lizhead verysad left = LayeredImageProxy("lizhead verysad", Transform(xzoom=-1.0))
image lizhead verysad right = LayeredImageProxy("lizhead verysad", Transform(xzoom=1.0))


layeredimage lizhead terrified:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    group neck:
        attribute n_down default "spr_liz_neck_terrified"

    always "spr_liz_face_terrified"

image lizhead terrified left = LayeredImageProxy("lizhead terrified", Transform(xzoom=-1.0))
image lizhead terrified right = LayeredImageProxy("lizhead terrified", Transform(xzoom=1.0))


layeredimage lizhead thinking:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    group neck:
        attribute n_down default "spr_liz_neck_thinking"
    
    always "spr_liz_face_thinking"

    # hat shadow
    group hat:
        attribute hat:
            blend 'multiply'
            transform_anchor True anchor (0.0, 0.0)
            xoffset 179 yoffset 1460 rotate -30
            "spr_liz_hatshadow"
    # the hat
    group hat:
        attribute hat:
            transform_anchor True anchor (0.0, 0.0) # Make the hat rotate around the top left point of the image, easier to do.
            xoffset 179 yoffset 1460 rotate -30
            "spr_liz_hat"
        attribute nohat "spr_null"

image lizhead thinking left = LayeredImageProxy("lizhead thinking", Transform(xzoom=-1.0))
image lizhead thinking right = LayeredImageProxy("lizhead thinking", Transform(xzoom=1.0))


layeredimage lizhead furious:
    xanchor 0.5
    mesh True
    yoffset LIZHEAD_YOFFSET

    group neck:
        attribute n_down default "spr_liz_neck_furious"
    
    always "spr_liz_face_furious"

image lizhead furious left = LayeredImageProxy("lizhead furious", Transform(xzoom=-1.0))
image lizhead furious right = LayeredImageProxy("lizhead furious", Transform(xzoom=1.0))






#
#   MIA
#

# Tier 1
layeredimage mia:
    xanchor 0.5
    mesh True

    group outfit:
        attribute normal default "spr_mia_body_normal"
        attribute gym "spr_mia_body_gym"

    # face
    group head:
        attribute neutral default "spr_mia_face_neutral"
        attribute angry "spr_mia_face_angry"
        attribute considering "spr_mia_face_considering"
        attribute cringe "spr_mia_face_cringe"
        attribute smug "spr_mia_face_smug"
        attribute shocked "spr_mia_face_shocked"

    # hair
    group head:
        if_not "gym"
        attribute neutral default "spr_mia_hair_neutral"
        attribute angry "spr_mia_hair_angry"
        attribute considering "spr_mia_hair_neutral"
        attribute cringe "spr_mia_hair_cringe"
        attribute smug "spr_mia_hair_cringe"
        attribute shocked "spr_mia_hair_neutral"
    group head:
        if_any "gym"
        attribute neutral default "spr_mia_hair_gym"
        attribute angry "spr_mia_hair_gym"
        attribute considering "spr_mia_hair_gym"
        attribute cringe "spr_mia_hair_gym"
        attribute smug "spr_mia_hair_gym"
        attribute shocked "spr_mia_hair_gym"

image mia left = LayeredImageProxy("mia", Transform(xzoom=-1.0))
image mia right = LayeredImageProxy("mia", Transform(xzoom=1.0))



# Tier 2
layeredimage mia furious:
    xanchor 0.5
    always "spr_mia_furious"

image mia furious left = LayeredImageProxy("mia furious", Transform(xzoom=-1.0))
image mia furious right = LayeredImageProxy("mia furious", Transform(xzoom=1.0))


layeredimage mia coinflip:
    xanchor 0.5
    always "spr_mia_coinflip"

image mia coinflip left = LayeredImageProxy("mia coinflip", Transform(xzoom=-1.0))
image mia coinflip right = LayeredImageProxy("mia coinflip", Transform(xzoom=1.0))


layeredimage mia thinking:
    xanchor 0.5
    always "spr_mia_thinking"

image mia thinking left = LayeredImageProxy("mia thinking", Transform(xzoom=-1.0))
image mia thinking right = LayeredImageProxy("mia thinking", Transform(xzoom=1.0))


layeredimage mia flipoff:
    xanchor 0.5
    always "spr_mia_flipoff"

image mia flipoff left = LayeredImageProxy("mia flipoff", Transform(xzoom=-1.0))
image mia flipoff right = LayeredImageProxy("mia flipoff", Transform(xzoom=1.0))


layeredimage mia cheerful:
    xanchor 0.5
    always "spr_mia_cheerful"

image mia cheerful left = LayeredImageProxy("mia cheerful", Transform(xzoom=-1.0))
image mia cheerful right = LayeredImageProxy("mia cheerful", Transform(xzoom=1.0))


layeredimage mia pedantic:
    xanchor 0.5
    always "spr_mia_pedantic"

image mia pedantic left = LayeredImageProxy("mia pedantic", Transform(xzoom=-1.0))
image mia pedantic right = LayeredImageProxy("mia pedantic", Transform(xzoom=1.0))


layeredimage mia terrified:
    xanchor 0.5
    always "spr_mia_terrified"

image mia terrified left = LayeredImageProxy("mia terrified", Transform(xzoom=-1.0))
image mia terrified right = LayeredImageProxy("mia terrified", Transform(xzoom=1.0))


layeredimage mia taunting:
    xanchor 0.5
    always "spr_mia_taunting"

image mia taunting left = LayeredImageProxy("mia taunting", Transform(xzoom=-1.0))
image mia taunting right = LayeredImageProxy("mia taunting", Transform(xzoom=1.0))






#
#   PROCKLING
#

# Tier 1
layeredimage prockling:
    xanchor 0.5
    group expressions:
        attribute neutral default "spr_prockling_neutral"
        attribute angry "spr_prockling_angry"
        attribute annoyed "spr_prockling_annoyed"
        attribute considering "spr_prockling_considering"
        attribute smirk "spr_prockling_smirk"
        attribute surprised "spr_prockling_surprised"

image prockling left = LayeredImageProxy("prockling", Transform(xzoom=-1.0))
image prockling right = LayeredImageProxy("prockling", Transform(xzoom=1.0))



#
#   SCALER
#

# Tier 1
layeredimage scaler:
    xanchor 0.5
    mesh True

    # body
    group outfit:
        attribute normal default "spr_scaler_body_normal"

    group face:
        if_any "normal"
        attribute neutral default "spr_scaler_face_neutral"
        attribute shocked "spr_scaler_face_shocked"
        attribute happy "spr_scaler_face_happy"

    group outfit_toggler:
        attribute normal default "spr_null"

    # hair
    group outfit:
        attribute normal default "spr_scaler_hair_normal"

image scaler left = LayeredImageProxy("scaler", Transform(xzoom=-1.0))
image scaler right = LayeredImageProxy("scaler", Transform(xzoom=1.0))





#
#   SOLLY
#

# Tier 1
layeredimage solly:
    xanchor 0.5
    group expressions:
        attribute neutral default "spr_solly_neutral"
        attribute happy "spr_solly_happy"
        attribute yelling "spr_solly_yelling"

image solly left = LayeredImageProxy("solly", Transform(xzoom=-1.0))
image solly right = LayeredImageProxy("solly", Transform(xzoom=1.0))



#
#   SOPHIA
#

# Tier 1
layeredimage sophia:
    xanchor 0.5
    group expressions:
        attribute neutral default "spr_sophia_neutral"
        attribute happy "spr_sophia_happy"
        attribute confused "spr_sophia_confused"
        attribute annoyed "spr_sophia_annoyed"

image sophia left = LayeredImageProxy("sophia", Transform(xzoom=-1.0))
image sophia right = LayeredImageProxy("sophia", Transform(xzoom=1.0))




#
#   RANDY
#

# Tier 1
layeredimage randy:
    xanchor 0.5
    group expressions:
        attribute neutral default "spr_randy_neutral"
        attribute happy "spr_randy_happy"
        attribute annoyed "spr_randy_annoyed"

image randy left = LayeredImageProxy("randy", Transform(xzoom=-1.0))
image randy right = LayeredImageProxy("randy", Transform(xzoom=1.0))





#
#   VINNY
#

layeredimage vinny:
    xanchor 0.5
    yoffset -100

    group expressions:
        attribute neutral default "spr_vinny_neutral"
        attribute sad "spr_vinny_sad"
    
    group swag:
        attribute swag "spr_vinny_chain"
        attribute unswag "spr_null"

image vinny left = LayeredImageProxy("vinny", Transform(xzoom=-1.0))
image vinny right = LayeredImageProxy("vinny", Transform(xzoom=1.0))





#
#   FERRIS
#

layeredimage ferris:
    xanchor 0.5
    yoffset -100
    mesh True

    group expressions:
        attribute neutral default "spr_ferris_neutral"
        attribute happy "spr_ferris_happy"

    group chain:
        attribute swag "spr_ferris_goldchain"
        attribute unswag "spr_null"

image ferris left = LayeredImageProxy("ferris", Transform(xzoom=-1.0))
image ferris right = LayeredImageProxy("ferris", Transform(xzoom=1.0))



#
#   METRO FERRIS
#

layeredimage metroferris:
    xalign 0.5
    yalign 0.5
    mesh True

    always "spr_metroferris_base"

    group head:
        if_any "hairstyle"
        attribute head_normal default "spr_metroferris_head_hairstyle"
    group head:
        if_not "hairstyle"
        attribute head_normal default "spr_metroferris_head_normal"

    group expressions:
        attribute neutral_nomouth "spr_metroferris_face_neutral_nomouth"

        attribute neutral default "spr_metroferris_face_neutral"
        attribute considering "spr_metroferris_face_considering"
        attribute smirk "spr_metroferris_face_smirk"
        attribute skeptical "spr_metroferris_face_skeptical"

        attribute neutral_considering "spr_metroferris_face_neutral_to_considering"
        attribute neutral_smirk "spr_metroferris_face_neutral_to_smirk"
        attribute neutral_skeptical "spr_metroferris_face_neutral_to_skeptical"

        attribute considering_neutral "spr_metroferris_face_considering_to_neutral"
        attribute considering_smirk "spr_metroferris_face_considering_to_smirk"
        attribute considering_skeptical "spr_metroferris_face_considering_to_skeptical"

        attribute smirk_neutral "spr_metroferris_face_smirk_to_neutral"
        attribute smirk_considering "spr_metroferris_face_smirk_to_considering"
        attribute smirk_skeptical "spr_metroferris_face_smirk_to_skeptical"

        attribute skeptical_neutral "spr_metroferris_face_skeptical_to_neutral"
        attribute skeptical_considering "spr_metroferris_face_skeptical_to_considering"
        attribute skeptical_smirk "spr_metroferris_face_skeptical_to_smirk"

    group hairstyle:
        attribute no_hairstyle "spr_null"
        attribute hairstyle "spr_null"

    group outfits multiple:
        if_any "outfits_on"
        attribute jacket "spr_metroferris_jacket"
        attribute beanie "spr_metroferris_beanie"
        attribute glasses "spr_metroferris_glasses"

    group outfit_toggler:
        attribute outfits_on default "spr_null"
        attribute outfits_off "spr_null"






#
#   LUNARA
#

layeredimage lunara:
    xanchor 0.5

    group expressions:
        attribute neutral default "spr_lunara_neutral"
        attribute happy "spr_lunara_happy"
        attribute cheerful "spr_lunara_cheerful"
        attribute surprised "spr_lunara_surprised"

image lunara left = LayeredImageProxy("lunara", Transform(xzoom=-1.0))
image lunara right = LayeredImageProxy("lunara", Transform(xzoom=1.0))





#
#   KIARA
#

layeredimage kiara:
    xanchor 0.5
    always "spr_kiara_neutral"

image kiara left = LayeredImageProxy("kiara", Transform(xzoom=-1.0))
image kiara right = LayeredImageProxy("kiara", Transform(xzoom=1.0))