# label chapter_2:
label chapter_2:
    stop music fadeout(3.0)

    "Morning comes."
    window auto hide
    pause 0.5

    scene white with Dissolve(1)
    pause 0.25

    play music mus_inco fadein 3.0

    scene bg_inco_room_day with eDissolve(2)
    pause 0.5

    "I've always had a decent internal clock, but it's a new record for me to get accustomed to a new sleeping schedule in just one day."

    "Especially with this fully grown lump on my scalp."

    "I move an arm from my sheets and feel my head."

    "Yeah, that's bruised real good."

    "Could be worse, though."
    pause 0.5

    "Alright, time to get up."
 
    show inco neutral at moveinup(0.3) with eidissolve

    "I slump out of bed and yawn, stretching my arms and cracking my spine a bit."

    "My new room is pretty nice."

    "Quite spacious, even with all the still-sealed boxes."

    show inco neutral at sety(), easemovex(0.5)
    pause 0.5

    "I brush my hand over one of them, the one with my other clothes."

    "I'll get around to opening them at some point."

    "Right now though, it's time for breakfast."
    window auto hide

    show inco at moveoutright(0.5)
    hide inco

    pause 0.5
    show black with dissolve
    pause 0.5

    "I shuffle downstairs into the heart of the house."

    "The morning sunbeams shining through the window draw my eyes to look out to the new neighborhood."

    "The driveway is empty." 

    "Looks like my parents are already gone for the day."

    "No surprise there, really. It's all they ever focus on."
    window auto hide
    pause 0.25

    scene bg_inco_kitchen_day with Dissolve(1)
    pause 0.25

    show inco concerned at moveinright(0.3) with eidissolve

    "A shiver runs up my spine as my feet step on the icy tiles of the kitchen." 

    show inco neutral with eidissolve_nd

    "My eyes are drawn to some taped up boxes that are still scattered about on the counters."

    "There's a familiar sticky note on the fridge, and I don't even have to read it to know what it says."

    "At this point, Mom's just wasting paper. The least she could do is reuse the same note and make small addendums to it."
    show inco at movex(0.4)
    pause 0.5

    "I snag a plate from the nearest drawer and open up the freezer."

    "No fresh produce to be seen, but there's still the mostly full box of breakfast burritos."

    show inco smug with eidissolve

    "Yeah, I've been trying to appreciate ethnic cultures more."

    show inco neutral with eidissolve

    "Plate loaded with a couple of the miniscule flour-wrapped meals, I set the microwave and wait for the burritos to hopefully not explode or burn inside."

    "While I wait though, I check my phone."
    show inco left with eidissolve

    "I scan over my newsfeed, and check out some of the people I'm subscribed to, hoping there's something to watch during my meal."

    "Unfortunately nobody posts videos or streams this early in the morning."

    "Guess I'll just watch a suggested video then."
    pause 0.5

    "I prop my phone up and click on something random."
    pause 0.25

    play sound snd_microwave_ding volume 0.5
    pause 0.5
    show inco right with eidissolve_nd

    "At the ding of the microwave I retrieve my breakfast, carrying it carefully so I don't burn my hands on the bottom of the plate."
    pause 0.5

    "I give the first burrito a test bite and..."

    show inco concerned with eidissolve_nd

    "Ugh, the inside is still cool."

    "I don't want to stick it back in, though, the tortilla would just become a brick then."

    show inco neutral with eidissolve

    "I shrug it off, continue chewing and watch my phone."
    pause 0.5

    Phone "TOPOFTHEMORNINGFOLKS!"
    pause 0.5

    "By the time the video ends I've finished the last of the half-thawed burritos."

    "Pocketing my phone, I slip the plate into the sink and head out for the day."

    show inco at moveoutright(0.3)
    hide inco
    pause 0.5

    "This time, I'm at {i}least{/i} getting through the day."

    "Today, survival."

    "Tomorrow, thrive-al."
    pause 0.5

    "{cps=5}...{/cps}"

    "I'll work on it."

    stop music fadeout 2.0
    stop sound fadeout 1.0

    window auto hide
    pause 0.5

    scene black with dissolve
    pause 0.5

    "{cps=5}...{/cps}"
    window auto hide
    pause 0.5

    play music mus_chill2
    play ambient1 amb_metro_loop fadein 2 volume 0.5

    call l_metro_day_sound from _call_l_metro_day_sound_1
    camera:
        perspective True
        parallel:
            tf_metro_cameramove
        parallel:
            tf_metro_soundplayer
    with Dissolve(1)
    pause 0.5

    "On the metro again, I take a little more time to check out my surroundings."

    "The sun shines through the windows across from my normal seat."

    "There's this one chick that was there yesterday, probably on her way to work."

    "It's probably a set routine for her at this point."

    "She always does a bit of makeup first and then checks her phone the rest of the way."

    "When the sun shines through the window, it highlights her hair in a really neat way."

    "Like a movie poster, almost."

    show metroferris behind bg_metro_overlay with eidissolve:
        truecenter
        moveindown(0.5, 0.5)
    pause 0.5

    "I'd take a picture, but it might be a little too awkward for me."

    "Also everything's disappeared. Why's it so dark?"
    pause 0.5

    unknown "{i}ahem{/i}."

    unknown "How's St. Hammond treating you so far, Mr. Nito?"
    pause 0.5

    "A voice so deep I feel it reverberate in my bones calls from above."
    window auto hide
    pause 0.5

    show layer master:
        ease_cubic 2 ypos 500
    pause 3
    show layer master:
        ypos 500 # necessary for some stupid reason

    "I'm taken aback at his authoritative stature."

    "His head is nearly grazing the top of the passenger car."

    "How did he even get in here?"
    pause 0.5

    I "Oh{cps=5}...{/cps} I,{w=.3} uh,{w=.3} it's been great so far, Mr{cps=5}...{/cps}?"

    Fe "Ferris."

    "He offers out his hand for a handshake."

    "Though his palm alone smothers my entire hand."
    pause 0.5

    I "How do you know my name?"

    Fe "You're clearly going to school, the nearest one is St. Hammond, and I'm already aware of a new human student, if you don't mind my profiling."

    I "Whoa{cps=5}...{/cps}{w=.3} You got all that just from looking at me?"

    Fe "I'm partially joking, your full name is printed on your backpack."

    show metroferris neutral_skeptical

    Fe "You know that's dangerous, right?"
    pause 0.5

    "{cps=5}...{/cps}Oops."

    I "Yep, that's me alright, haha."

    show metroferris skeptical_neutral
    pause 0.5

    Fe "But please{cps=5}...{/cps}"

    Fe "I know it's only been a few days since the year started, I'd like to hear your opinion so far."

    I "Is this a questionnaire or something?"

    Fe "Not exactly, but it is of some importance to an assignment of mine."

    "What does that mean?"

    show metroferris neutral_considering
    pause 0.5

    Fe "Oh, what am I being secretive for?"

    show metroferris considering_neutral

    Fe "I'm here to audit your school. See the teachers, know the students, make sure it's a proper place of learning."

    Fe "I wish it were something worth being secretive about."

    Fe "More often than not it's just paperwork and office politics."

    I "Oh, alright then."

    "My thoughts on the school so far{cps=5}...{/cps}"

    "I consider telling him about a teacher nailing me with a dodgeball to make a point..."
    pause 0.5

    "{cps=5}...{/cps}Nah, I'm over it."
    pause 0.5

    I "Well, the classes that I have are great, and the teachers I have are a dynamic bunch."

    "He thumbs the inside of his coat pocket for his pen, but decides he doesn't need it yet."

    Fe "I see. Any favorites?"

    I "I mean, I don't like to have favorites{cps=5}...{/cps}"

    I "But all the staff seem pretty lively."

    show metroferris neutral_smirk
    pause 0.5

    "Ferris lets out a heavy, rumbling chuckle."
    pause 0.5

    Fe "That's certainly good to hear." 

    Fe "And what of your fellow students? Made any friends?"

    I "It's been a bit of a struggle, but it's always been that way for me since my folks move around a lot."

    I "I think I'm doing pretty good this time around, though."

    Fe "Why do you think that is?"
    pause 0.5

    I "I think{w=.5} it's the jacket."

    show metroferris smirk_neutral

    Fe "The jacket?"
    pause 0.5

    "I give my lapel a quick tug for extra style points."
    pause 0.5

    I "The Coastline Cotton Nylon Bomber #32."

    I "Part of the latest catalog by A&F."

    Fe "I see{cps=5}...{/cps}"
    pause 0.5

    "Does he need to lean so close to inspect it?"

    "If the carriage rocks in any way, he'd probably turn me into a piece of modern art against the window."
    pause 0.5

    Fe "And that's really what the youth are into these days?"

    I "Hey, the results speak for themselves."

    show metroferris neutral_considering

    Fe "{cps=10}Hm...{/cps}"
    pause 0.5

    "Whatever he's thinking about, it's got nothing to do with his work."

    "I think I have a pretty good idea."
    pause 0.5

    I "Mr. Ferris?"

    I "Do you got no swag?"

    show metroferris considering_neutral

    Fe "Huh?"

    Fe "Um.{w=.3} Well,{w=.3} I guess that probably answers it."

    Fe "I admit to being a little 'gray'."

    Fe "I'm aware I'm not exactly 'with it' anymore."

    I "Well, even the older generation can dress to impress, you just have to see what people today like to wear."

    Fe "I'm certainly willing to listen to the youth of today, yes."

    Fe "It is somewhat important to my job to know how the student body thinks."

    Fe "And my niece often suggests 'dressing more relaxed', whatever that means."

    I "Does she ever see you in casual clothes?"

    Fe "I'm wearing them now."
    pause 0.5

    I "{cps=5}...{/cps}"
    pause 0.5

    "I can save him."
    window auto hide
    pause 0.25

    stop ambient1 fadeout 2

    scene black 
    camera at resetcamera
    with dissolve
    pause 0.25

    "The rest of the trip was quick, but we continue with small talk about trends."

    "When we arrive at my stop, he attempts to give me his business card."
    pause 0.5

    "For someone whose mere presence could stop a fight, he seems like a genuinely nice fellow."

    "I look forward to talking to him again."

    stop music fadeout 3

    "{cps=5}...{/cps}"
    window auto hide
    pause 0.5

    camera:
        perspective True

    scene bg_gym:
        zzoom True
        zpos -2400

    show damien gym neutral at setx(0.35)
    show inco gym concerned at setx(0.2)
    with Dissolve(1.0)
    pause 0.25

    "Oh god, those burritos were a mistake."

    "My stomach is roiling after the warmups."

    pause 0.5

    play music mus_mia2
    show solly neutral left at moveinleft(0.8) with eidissolve

    So "{atl=sh}ALRIGHT MAGGOTS. TODAY WE'LL BE WORKING ON YOUR CARDIOVASCULAR \nSYSTEM.{/atl}" with ypunchlong

    So "{atl=sh}BY THAT I MEAN A GOOD OLE FASHION MILE RUN.{/atl}"

    So "{atl=sh}I WANT EVERYONE OUT ON THE TRACK FIELD YESTERDAY!{/atl}"

    show damien at movex(0.37)

    "I notice Damien's mouth open soon as Coach Solly yells the words."

    So "{atl=sh}AND NO, DAMIEN, THAT DOESN'T MEAN I WANT YOU TO TIME TRAVEL.{/atl}"

    So "{atl=sh}UNLESS, OF COURSE, YOU MEAN RUNNING SO FAST THAT YOU HIT EIGHTY-EIGHT \nMILES AN HOUR!{/atl}"

    show damien at easemovex(0.35)
    show damien cheerful with eidissolve

    "And just as quickly, Damien shuts his mouth again and shoots Solly a thumb's up."
    pause 0.5

    "Solly's only reply is to let out a snort."
    pause 0.5

    show solly at setx(0.8), hop(0.0, 4)

    So "{atl=sh}DOUBLE TIME IT NOW, CUPCAKES!{/atl}" with ypunch

    show damien at moveoutleft_cs(0.35, 0.2)
    show damien neutral left with eidissolve
    hide damien
    show inco at moveoutleft(0.2, 0.2, 1)
    show inco left with eidissolve_nd
    hide inco

    "There's no hesitation from me this time. I follow the rest of the class and do the run Solly wanted."

    stop music fadeout 2

    window auto hide
    pause 0.25

    scene black with dissolve
    pause 0.25

    "As expected, I rapidly fell behind the pack."
    window auto hide
    pause 0.5

    play music mus_general

    scene bg_school_track with dissolve#:
    #    xpan 0
    #    linear 8 xpan -360
    #    repeat

    show inco gym concerned left at moveinleft(0.4) with eidissolve #, walkerloop with eidissolve

    pause 1.5

    show damien gym neutral left at moveinleft(0.6) with eidissolve #, walkerloop with eidissolve

    D "Hey, Inco, nice of you to drop by. How are you doing?"

    I "Damien? W-{w=.3}what are you doing back here?"

    D "Keeping my new buddy company, of course."

    D "What are you doing?"

    I "Tr-{w=.3}trying not to vomit."

    show damien happy with eidissolve_nd

    D "You're doing great then!"

    I "Thanks, I guess."

    I "Shouldn't you be at the very front of the pack though?"

    show damien considering with eidissolve_nd

    D "Next to Mia? Nah, man. Not her."

    show inco gym neutral with eidissolve_nd

    I "Mia?"

    show damien skeptical with eidissolve_nd

    D "You know, the one who knocked you out yesterday."
    pause 0.5

    "A brief flashback reminds me of the red parasaurus."

    I "Ah, her{cps=5}...{/cps}"
   
    show damien neutral with eidissolve

    D "By the by, glad to see you're doing way better today."

    D "You're even up and running!"

    I "Yeah. Glad I didn't wind up with permanent brain damage."
    pause 0.5

    I "{cps=5}...{/cps}"
    pause 0.5

    I "Hey, question."

    I "Was what happened yesterday{cps=5}...{/cps}{w=.3} normal here at St. Hammond?"

    D "Well{cps=5}...{/cps} Mia's a wild one, that's for sure."

    D "Best not to mess with her. Unless you're into those kinds of chicks, in which case, be my guest."

    D "As for Solly{cps=5}...{/cps}{w=.3} yeah, he's always like that."

    D "You'll get used to it though."

    D "He ain't that bad a guy once he warms up to you."
    pause 0.5

    I "If you say so{cps=5}...{/cps}"

    D "Hey! Don't worry, man. You're going to fit right in in no time flat!"

    D "In fact, you should sit with us at lunch! That way, we can give you the proper St. Hammond welcome and stuff!"

    I "Lunch? We? I-{w=.3}I mean-"

    show damien shocked
    show inco gym surprised

    So "{cps=*1.5}{atl=sh}INCO! DAMIEN! DON'T FALL BEHIND!{/atl}{/cps}" with xpunch
    pause 0.5

    "Solly's voice snaps me from my mini stupor and makes me realize just how far behind Damien and I had fallen behind the rest of the class."

    show damien neutral with eidissolve_nd

    D "Whoops! Better catch up with the others before Solly brings out the 'Punitive Measure'!"

    show inco concerned with eidissolve_nd

    I "E-{w=.3}excuse me, the {i}what{/i}?"

    D "You don't want to find out, brother. Trust me!"

    I "Wha-"

    D "'C'mon, dude. Let's jet!"

    show damien at easemovex(0.63)#, walkerloop

    "Before I can say another word, Damien gets behind me and starts pushing me forward, forcing my legs to move faster than ever should have."

    show inco:
        subpixel True
        on hide:
            pause 0.5
            parallel:
                linear 0.75 xpos 0.4 - 0.25
            parallel:
                easeout_cubic 0.5 alpha 0

    show damien behind inco:
        subpixel True
        on hide:
            parallel:
                easeout_quad 1.0 xpos 0.63 - 0.3
            parallel:
                time .5
                easeout_cubic 0.5 alpha 0

    hide damien
    hide inco
    pause 0.75

    "I have to struggle to not trip over myself, but somehow, I manage to keep up the pace that Damien was forcing my whole body to maintain."
    window auto hide
    pause 0.5

    scene black with dissolve
    pause 0.5

    scene bg_school_track with dissolve#:
    #    xpan 0

    pause 0.5

    show inco gym concerned sweat left with eidissolve:
        parallel:
            moveinleft(0.5)
        parallel:
            ease_quad 0.4 ypos -0.0075
            ease_quad 0.4 ypos 0.0
            ease_quad 0.4 ypos -0.0075
            ease_quad 0.4 ypos 0.0
            ease_quad 0.4 ypos -0.0075
            ease_quad 0.4 ypos 0.0

    pause 2.0
    show inco at setx(0.5), falldownright(0.03, 0.75, 0.8)
    pause 0.75
    play sound snd_bodyslam_grass
    show inco with xpunchlong

    show damien gym skeptical left behind inco:
        subpixel True
        rotate -18
        xpos 1.15
        ypos -0.16
        easein_cubic 1 xpos 1.07

    "Five minutes and three more laps later, I fall flat on my ass, heart beating so fast and lungs burning so fiercely that every breath feels like sandpaper scraping against my throat."
    
    "Regardless of that though, I finished the jog."

    "The first small step towards conquering my physical weakness."

    stop music fadeout 3.0

    show solly neutral at moveinright(0.2) with eidissolve

    So "{atl=sh}GOOD JOB, MAGGOTS!{/atl}"

    So "{atl=sh}KEEP THIS UP, AND YOU'LL BE SOLDIERS YET!{/atl}"
    pause 0.5

    "Solly turns to me, and with a slight grin, shoots me a thumb's up."

    show solly happy with eidissolve

    So "{atl=sh}OKAY, THAT'S ALL FOR TODAY!{/atl}"

    So "{atl=sh}HIT THE LOCKERS, CUPCAKES!{/atl}"
    window auto hide

    show solly at moveoutleft_cs(0.2)
    show solly left with eidissolve
    hide solly

    show damien:
        easein_cubic 0.75 rotate 0.0 xpos 0.98
        easemovex(0.8)
        movey(0.0)
    show damien neutral with eidissolve

    pause 1.0

    scene black with dissolve
    pause 0.5
    play music mus_casual fadein 3.0

    "Damien helps back up and I join the rest of the male students back to the locker room."

    "We talk a bit more about interest and other school matters on the way, Damien filling me in a bit on St. Hammond's history during the three years he'd been in attendance."

    "By a bit of luck, our lockers aren't that far apart from one another, but our conversation isn't a real possibility considering all the other ones going on in the relatively cramped locker rooms."

    "There really isn't that much more time to chat before the bell rings for our next class switch."
    window auto hide
    pause 0.5

    scene bg_school_hallway with dissolve
    pause 0.25
    show inco neutral at moveinright(0.35)
    show damien neutral right at moveinright(0.65) behind inco
    with eidissolve
    show damien left with eidissolve

    "I wave goodbye to Damien and start looking for my next class."
    pause 0.5

    show damien at nudgeup()

    D "Don't forget! Lunch with the buds!"

    "I nod in reply as I turn around and head down the hall towards my next class."
    window auto hide

    show inco behind damien
    show damien at moveoutleft(0.6)
    hide damien 

    pause 1.0
    hide inco with eodissolve
    pause 0.25

    "Making my way down the hall, I take notice of the surroundings."

    "Everything about the school seemed pretty normal, though there are some key modifications made to better suit the majority of the student body."

    "Mainly water fountains that settle a good ten or more feet above me."

    "Overall, nothing crazy special."
    pause 0.5

    "This next class I'm sorta looking forward to."

    "AP art design. I've actually been looking forward to this."

    "The class looks like it's in a studio classroom on the second floor."
    window auto hide
    pause 0.25

    show black with dissolve
    pause 0.25

    scene bg_school_secondfloor with Dissolve(1) 
    pause 0.5

    "Part of the school here is built to be both inside and outside, with open ceilings and walls here and there."

    "Since it's also {i}the{/i} art wing, the displayed pictures are coated in hydrophobic layers and framed."

    "Although since it's the start of the year the halls are freshly cleared, waiting to be filled in as the semesters pass."

    "Of course, there's also no shortage of drains."

    "This hall in particular is displayed prominently in the school's advertising material, and for good reason."

    "The carefully and expertly built dynamic between the surrounding nature, the school, and even the building materials themselves is nothing less but mystical."

    "I can already feel the {i}creative juices{/i} flowing."
    pause 0.5

    "Soon enough, I'm standing just outside the door to my next class."

    "Much like the school wall outside, it's decorated in various colors and patterns, each corner painted and tagged by different students."

    "I barely step foot inside before the bell rings."
    window auto hide
    pause 0.25

    show black with dissolve
    pause 0.5

    scene bg_class_art with Dissolve(1)
    pause 0.5
    show inco neutral at moveinright(0.3) with eidissolve

    "Since I was the last one in, all but one of the other seats were taken. It's pretty close to the front."

    "While many of the students look well-prepared, some are clearly ready to fall asleep within the next few minutes."

    show inco at easemovex(-0.1, 1.5)
    show iadakan neutral left with eidissolve_nd:
        setx(1.1)
        easemovex(0.7, 1.5)
    pause 1.0

    "Then there's the teacher. He's standing up by the board, waiting for me to finish looking around and take a seat."

    "Since he isn't urging me to look for a seat, he must be used to new students taking it all in."

    "That must be the art teacher."

    "Somehow, he looks young and old at the same time."

    show iadakan at movex(1.1)
    show inco at movex(0.3)
    hide iadakan with eodissolve_nd
    pause 0.5

    "{cps=5}...{/cps}Well, don't want to hold up class for {i}too{/i} long."

    "Trying not to take the teachers' hospitality for granted, I take the seat closest to me in the front row."
    show inco:
        movex(0.5)
        backmovey(0.1)
    pause 1.0

    "Even with me sitting down, the art teacher still continues to idle, instead staring at the seated students with a hazy stare."

    "Nobody else seems to be paying attention to him, save for a few people here and there."
    pause 0.5

    "A few students are whispering something behind me."
    pause 0.5

    unknown "Where was he, yesterday?"

    unknown "Hey, I'm not complaining about less work."

    unknown "Yeah, but on the first day?"

    show inco skeptical with eidissolve

    "Huh, so in a way it's the teachers' first day as well."

    "So I didn't miss anything in this class. That's pretty cool, actuall-"

    stop music fadeout 0.3
    play sound snd_table_slam
    show inco surprised at setx(0.5), nudgeup(0.1)

    "*{i}WHAM{/i}*!!" with xpunch

    play music mus_iadakan

    show inco at movex(0.1)
    hide inco with eodissolve_nd
    show iadakan happy left at moveinleft(0.7, m=0.4) with eidissolve_nd
    pause 0.5

    "The teacher slams the front of his desk with both fists, the sound echoing through the room."

    "It's the signal for all auxiliary conversation to cease, and the class obeys."

    "Despite the sudden furniture abuse, the teacher doesn't look agitated."

    "Rather, he's got a massive grin on his face."

    "The phrase 'winning smile' comes to mind."

    show iadakan at movex(0.5)
    show iadakan excited left with eidissolve

    Teacher "Right, then!"

    "The pale pterodactyl holds what looks to be a metallic tray on a stick."

    Teacher "Good morning class!"
    window auto hide

    play sound snd_shine
    pause 0.3
    show white with Dissolve(0.2)
    pause 1.0

    "Thank you Raptor Jesus, for forcing me to wear prescription shades."

    "My classmates are all wincing in pain and wiping at their eyes."
    pause 0.5
    hide white with dissolve

    Teacher "...and welcome to AP Art Design!"
    pause 0.5

    "He holds up the stick haphazardly."
    pause 0.5

    show iadakan at setx(0.5), nudgeup()

    Teacher "This is a flash-pan."

    Teacher "Saw it at an antique store yesterday, thought it'd be a good introduction."

    Teacher "It's not important. Worthless, actually!"
    window auto hide

    play sound snd_slapstick_whoosh
    show iadakan at nudgeup()
    show iadakan happy with eidissolve

    pause 0.4

    play sound snd_metalpan_crash volume 0.8
    pause 0.5

    "The class winces as the stick is chucked into the garbage bin and shattered."
    pause 0.5

    Teacher "Excuse my absence yesterday, I had matters to take care of elsewhere."

    Teacher "My name is Mr. Iadakan!"

    show iadakan at movex(0.6)
    show iadakan eccentric right with eidissolve

    "Within the blink of an eye the teacher has replaced the sun-on-a-stick with a fancy marker and managed to scrawl his name across the board in the finest show of calligraphy."
    show iadakan at movex(0.5)
    show iadakan eccentric left with eidissolve

    Iad "And I shall be your guide as we explore the expanse of the creative world!"

    Iad "Let's not dilly-dally then, shall we?"

    show iadakan at movex(0.7)
    show inco at moveinright(0.2, 0.1) with eidissolve

    "For a teacher he's very{cps=5}...{/cps} animated."
    
    show iadakan happy with eidissolve

    Iad "This first week, we'll be going in-depth on the history of the fundamentals of art! Perhaps a little trial by fire as well, to get your creative juices flowing!"

    "There're murmurs from my classmates, though I pay them no mind."

    "In fact the prospect of doing some creative work, something that I could possibly show off..."

    "For a brief moment, I picture my own name on a placard in the hallway outside the principal's office."
    pause 0.5

    Iad "For now though, I'd like for you all to open up your book to page 3."

    "Right, my bo-"
    pause 0.25
    stop music fadeout 0.02
    pause 0.5

    "Wait what book."

    "Wait."
    pause 0.5

    show black behind inco:
        alpha 0.0
        linear 0.5 alpha 0.4
    show inco concerned left with eidissolve

    "Looking around I see that everyone else has a novel-sized hardcover book opened."
    pause 0.5

    "Oh."

    show inco neutral right with eidissolve

    "They must've gotten them yesterday."
    pause 0.5

    "{cps=5}...{/cps}"

    hide black with dissolve

    Iad "Now then class, we'll be starting with-"

    show inco at movey(0.05)

    "Hesitantly, I raise my hand."

    I "M-{w=.3}Mr. Iadakan?{w=.3} Sir?"

    show inco at movey(0.1)
    pause 0.5

    I "I uh{cps=5}...{/cps}{w=.3} don't have a book yet."

    show iadakan surprised left with eidissolve

    Iad "You don't have- how?"

    Iad "The substitute passed all of them out yesterd-{w=.4}{cps=10}ooooh.{/cps}"

    show iadakan explaining left with eidissolve

    "His eyes flicker open a second as he connects some internal dots."

    Iad "The word on the street is that some new kid got concussed so hard he had to leave early."

    show inco concerned with eidissolve

    I "Did{cps=5}...{/cps}{w=.3} did the street at least mention I was doing well before that?"

    show iadakan at setx(0.7), nudgeup()

    Iad "Ho! Of course not!"

    Iad "You're Mr. Nito, then?"

    I "Yes sir."

    Iad "Given the circumstance, I'll let it slide."

    Iad "For now, why don't you share with one of your classmates?"

    Iad "After class I'll write you a note that you can give to the librarian."

    show iadakan neutral with eidissolve_nd

    I "Thank you, sir."
    show inco neutral with eidissolve

    play music mus_casual fadein 1

    "I kind of regret being so late, because the only person I can realistically share with is the person to my side."
    
    show inco left with eidissolve

    I "So, uh, hey."

    show iadakan at movex(1.1)
    show inco at sety(0.1), movex(0.6)
    show olivia annoyed at moveinright(0.4, m=0.4) with eidissolve_nd
    hide iadakan with eodissolve_nd
    pause 1.5

    "Wait a minute."

    "Wasn't she the one speeding through the hallway yesterday?"
    pause 0.5

    "Just like back then I feel her gaze, piercing and cold, as if she's not even seeing me next to her."
    pause 0.5

    I "Would it be okay to share the book? It'll only be for today."

    show olivia grumpy with eidissolve

    "Instead of a response, she lets out a defeated low groan like I just spit in her cereal."

    "Then huddles back over her page."

    show inco skeptical with eidissolve_nd

    "Well gee, sorry I asked."

    show inco neutral right with eidissolve

    "{cps=5}...{/cps}It's only the first real day, maybe I won't {i}need{/i} it."
    
    show inco at movex(0.35)
    show olivia at movex(0.15)
    show iadakan left at moveinleft(0.7) with eidissolve

    Iad "Olivia, c'mon, share with him this one time."

    show iadakan explaining left with eidissolve_nd

    Iad "I already told him I'd personally resolve the issue, just help me out here, aight?"

    show olivia ugh with eidissolve

    "She responds by making a show of sighing deeply while rolling her head back and around."

    "Ordinarily there'd be a groan to go with the gesture, but she remains silent."

    show olivia angry with eidissolve

    "Her head hangs low in defeat, and she nudges the book a few centimeters closer to me."

    show inco skeptical left with eidissolve

    I "Er, thanks?"

    "I slide my own desk closer to her, just enough that I can read the page."

    show inco neutral right
    show iadakan eccentric
    with eidissolve

    "While our teacher orates the page as if reading from Death of a Hunter, I follow along while simultaneously trying to capture anything that stands out into my notebook."

    show olivia neutraldown with eidissolve

    "A lot more difficult than expected as Mr. Iadakan seemed to put emphasis on every word he spoke."

    "I felt like I was just copying the page wholesale."

    show iadakan at movex(0.95)
    show inco at movex(0.6)
    show olivia at movex(0.4)
    hide iadakan with eodissolve

    "My eyes turn from the book to the girl's notes and-"

    "{i}*scrtch scrtch scrtch*{/i}"

    show inco surprised with eidissolve

    "Those're some very murderous-looking claws on her fingertips."

    show inco at movexy(0.57, 0.13)
    pause 0.5

    "For a split-second I see them retract."

    "She wipes her fingertips on a small hand towel and-"

    "Whoa, the claws extend again into a puddle of red on her desk."

    "A singular red-colored claw is pressed on her paper for a moment, quickly tugged and twirled and twisted."

    "Leaving behind a bright red cursive sentence on the page."

    show inco neutral with eidissolve
    show inco at movexy(0.6, 0.1)

    I "Cool."

    "Those silver iris' flick my way once more."

    show olivia at setx(0.4), nudgeup()
    show olivia surprised with eidissolve

    O "What?"

    show inco left with eidissolve_nd

    I "Er, what you're doing, that looks pretty cool."
    pause 0.5

    "A hint of red creeps across the girl's cheeks."

    show olivia grumpy with eidissolve

    "She looks back at the book and hunches her shoulders as high as she humanly (Dinoly?) can."
    pause 0.5

    "Huh?"

    "She's now leaning over her notes too, even using the book as extra protection for the pages."

    show inco neutral right
    show olivia neutraldown
    with eidissolve

    "I should be focusing on my own notes. Yeah."

    "An impossible task now, though, as the colorful calligraphy next to me has piqued my curiosity."

    show inco surprised with eidissolve
    show inco at movexy(0.57, 0.13)

    "The quill talon continues to delicately etch notes onto the page."

    "And it only leaves the page to dip into what looks like a tiny paint palette at the edge of her desk."

    show olivia annoyed with eidissolve

    "The claws extend again, and now there's a faint rumbling."

    pause 0.25
    show olivia at growl2x(0.4, 0.0, 0.7)
    pause 0.25

    "{i}*grrrrr*{/i}"

    show olivia at setx(0.4), nudgeup()

    O "Hey."

    show inco at backmovexy(0.6, 0.1)
    pause 0.5

    "I hadn't meant to get caught up in it."

    show inco concerned left with eidissolve

    I "Sorry, uh{cps=5}...{/cps}"

    "I wait for her to give me a name."
    pause 0.5

    "She doesn't."

    show olivia neutraldown with eidissolve

    "She simply returns her focus to the book between us."

    show inco skeptical right with eidissolve

    "I wonder what her deal is."
    pause 0.5

    "In either case, I turn my attention back to class. Hope I can make up for lost time."

    "{cps=5}...{/cps}It's hard to ignore the gator girl though."

    show inco concerned with eidissolve

    "Especially when those icy gray eyes of hers feel like icicles poised to stab through me."

    show inco skeptical with eidissolve

    "{cps=5}...{/cps}Hey, wait a second."

    "Those hand motions{cps=5}...{/cps}{w=.3} She's not writing something right now."

    "She's drawing."
    pause 0.5

    "{cps=5}...{/cps}Well{cps=5}...{/cps}{w=.3} It's none of my business..."

    "But I {i}am{/i} rather curious{cps=5}...{/cps}"
    
    show inco neutral with eidissolve
    show inco at movexy(0.57, 0.13)

    "I make a show of leaning back to yawn."

    "Now I can see. It's..."

    show inco surprised with eidissolve_nd

    "Whoa. It's a calligraphic doodle of me."

    "There's no mistaking it, that's my jacket and sunglasses."

    "That's{cps=5}...{/cps}{w=.3} Pretty cool."

    "Nobody's ever really drawn me before."
    pause 0.5

    "Well, there were those others on the first day of school, but that's different."

    "They weren't using their own claws or ink."

    show inco at movexy(0.6, 0.1)
    show inco happy left with eidissolve

    "Aw man, I can't wait, I gotta ask for a closer look."
    pause 0.5

    I "Hey..."

    show olivia neutral with eidissolve

    O "{cps=5}...?{/cps}"

    I "Your picture is super cool, can I see it?"

    show olivia annoyed with eidissolve

    O "{cps=5}...{/cps}"
    pause 0.5

    "She glares me in the eye, but slowly brings the sheaf she was doodling on."

    "With the light still dim, I just barely make out all the important details."

    "The linework is sharp, each stroke an organic curve that when combined formed what had to be me."

    "It even had my glasses, in the negative space of the head."

    "Though what was with the multiple swervy lines coming out of my drawing's head?"
    pause 0.5

    I "Dude, this is great."

    show olivia considering with eidissolve_nd

    "She rolls her eyes and starts retracting the page."

    I "Can I take a picture of it?"
    pause 0.5

    "A pause."
    show olivia neutral with eidissolve

    O "{cps=5}...{/cps}Why?"

    I "Nobody's ever done something like that for me, I wanna remember it."
    pause 0.5

    O "{cps=5}...{/cps}{w=.3} {cps=5}...{/cps}"
    pause 0.5

    "She passes the paper over to me."

    O "'s yours."

    I "Whoa, really? Thanks!"

    O "Don't mention it."

    I "But-"

    O "Don't."
    pause 0.5

    "Hm."

    "She's nice."

    show inco neutral right with eidissolve

    "After a grueling period made worse by my own anxiety, the bell rings to set us free."

    play sound snd_school_bell fadein 0.5
    pause 0.5

    show olivia at sety(), moveoutleft_cs(0.4)
    show olivia left with eidissolve
    hide olivia

    show inco at setx(0.6), movey(0.0)
    show inco happy with eidissolve

    stop sound fadeout 5

    "Finally, freedom at las-"

    show inco at movexy(0.5, 0.0)
    show iadakan considering left at moveinleft(0.75) with eidissolve

    Iad "Just stay for a minute longer, Inco."

    show inco neutral with eidissolve

    "I get some sideways glances from other students as they leave, no doubt suspecting I'm a teacher's pet already."

    "With few strokes from his pen, Iadakan hands me a note."

    show iadakan explaining with eidissolve

    Iad "Just show this to the librarian and she'll hand you your books."

    Iad "On your way now."
    window auto hide
    pause 0.5

    stop music fadeout 2

    scene black with dissolve
    pause 0.5

    "A quick trip to the library earns me my missing books."

    "I even got a fancy laminated library card."

    "Iadakan's introduction to his class certainly has me excited for photography next."

    "First stop, though; lunch. Can't take pictures on an empty stomach!"

    "Between my lackluster breakfast and gym class, I'm practically starving."

    "Despite my hunger, though, I'm stopped dead in my tracks as I look around the cafeteria for a place to sit."
    window auto hide
    pause 0.5

    play ambient1 amb_crowd_rowdy_loop fadein 1.0
    $ renpy.music.set_volume(0.4, 0.0, "ambient1")

    camera:
        perspective True

    scene bg_cafeteria:
        zpos -1800 zzoom True

    show spr_crowdperson_chilling2 as temp_crowdperson_4:
        xpos -0.5 ypos 0.1 zpos -20
        matrixcolor ColorizeMatrix("#c04141", "#ffffff")
        block:
            parallel:
                pause 4
                xzoom 1
                linear 1.5 xpos 1.0
                pause 4
                xzoom -1
                linear 1.5 xpos -0.5
                repeat
            parallel:
                pause 4.5
                easein_circ 0.3 ypos -0.05
                easeout_circ 0.3 ypos 0.1
                pause 0.4
                repeat

    show spr_crowdperson_chilling1 as temp_crowdperson_3:
        xpos -0.5 ypos 0.1
        matrixcolor ColorizeMatrix("#516de6", "#ffffff")
        pause 0.5
        block:
            parallel:
                pause 4
                xzoom 1
                linear 1.5 xpos 1.0
                pause 4
                xzoom -1
                linear 1.5 xpos -0.5
                repeat
            parallel:
                pause 4.5
                easein_circ 0.3 ypos -0.1
                easeout_circ 0.3 ypos 0.05
                pause 0.4
                repeat

    show spr_crowdbackdrop_back_right:
        xpos 0.21 ypos 0.05
        block:
            ease_quad 0.5 xpos 0.21 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.3 xpos 0.21 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.6 xpos 0.21 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.4 xpos 0.21 ypos -0.01 + 0.05
            ease_quad 0.5 xpos 0.21 + 0.01 ypos 0.0 + 0.05
            repeat
    show spr_crowdbackdrop_back_left:
        xpos -0.32 ypos 0.05
        block:
            ease_quad 0.5 xpos -0.32 ypos -0.01 + 0.05
            ease_quad 0.5 xpos -0.32 + 0.01 ypos 0.0 + 0.05
            ease_quad 0.6 xpos -0.32 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.4 xpos -0.32 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.4 xpos -0.32 + 0.02 ypos 0.0 + 0.05
            repeat
    show spr_crowdbackdrop_front_right:
        xpos 0.56 ypos 0.05
        block:
            ease_quad 0.3 xpos 0.56 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.5 xpos 0.56 ypos -0.01 + 0.05
            ease_quad 0.5 xpos 0.56 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.6 xpos 0.56 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.3 xpos 0.56 + 0.01 ypos 0.0 + 0.05
            repeat
    show spr_crowdbackdrop_front_left:
        xpos 0.0 ypos 0.05
        block:
            ease_quad 0.5 xpos 0.0 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.4 xpos 0.0 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.6 xpos 0.0 ypos -0.01 + 0.05
            ease_quad 0.3 xpos 0.0 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.5 xpos 0.0 + 0.01 ypos 0.0 + 0.05
            repeat
    show spr_crowdperson_watching3 as temp_crowdperson_5:
        xpos 0.36 ypos 0.0 xzoom -1
        matrixcolor ColorizeMatrix("#9A9071", "#ffffff")
        block:
            ease_quad 0.4 xpos 0.36 ypos -0.01 + 0.05
            ease_quad 0.4 xpos 0.36 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.3 xpos 0.36 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.4 xpos 0.36 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.5 xpos 0.36 ypos 0.0 + 0.05
            repeat
    show spr_crowdbackdrop_front_right as temp_crowdperson_2:
        xpos -0.16 ypos 0.05
        block:
            ease_quad 0.3 xpos -0.16 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.5 xpos -0.16 ypos -0.01 + 0.05
            ease_quad 0.5 xpos -0.16 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.6 xpos -0.16 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.3 xpos -0.16 + 0.01 ypos 0.0 + 0.05
            repeat
    show spr_crowdperson_phone2 as temp_crowdperson_1:
        xpos -0.31 ypos 0.0
        matrixcolor ColorizeMatrix("#9B62A8", "#ffffff")
        block:
            ease_quad 0.5 xpos -0.31 + 0.02 ypos 0.0 + 0.05
            ease_quad 0.4 xpos -0.31 ypos -0.01 + 0.05
            ease_quad 0.5 xpos -0.31 - 0.01 ypos -0.01 + 0.05
            ease_quad 0.4 xpos -0.31 + 0.01 ypos 0.01 + 0.05
            ease_quad 0.6 xpos -0.31 ypos 0.0 + 0.05
            repeat

    with Dissolve(1)
    pause 0.5

    show inco neutral at moveinright(0.5) with eidissolve

    "The whole place is overtaken by lawless anarchy. I've never seen a riot this intense."

    "A few students have even crawled halfway up the wall, hanging by the decorative vines."

    "Food flies about everywhere, utilized as ammunition rather than sustenance."

    "Although the security guard by the door isn't moving. This must be{cps=5}...{/cps}{w=.4} acceptable?"
    pause 0.5

    "I shudder to think what would be bad enough to warrant him taking action."

    "I've never seen anything like that at any of my old schools."

    "But more importantly..."

    show inco concerned with eidissolve

    "All the cliques have already formed from the previous day."

    "I missed my chance to sit with anybody."
    pause 0.5

    "{cps=5}...{/cps}"

    show inco surprised with eidissolve

    "Wait, it's only the second day."

    "Why am I acting as though it's 'too late' for anything?"
    pause 0.5

    D "Yooo, Niko!"

    show inco:
        setx()
        pause 0.5
        "inco shocked"
        hit()
    show damien happy at moveinright(0.35) with eidissolve

    "I'm shoulder checked from behind by what feels like an oversized fist or undersized boulder."

    "If I weren't already by a wall I would have either been sent sprawling or made into roadkill again."
    
    "When I turn about I'm met with Damien's toothy grin."

    show inco at movex(0.55)
    show inco neutral left with eidissolve

    I "OW-{w=.3} Wh-{w=.3} What?"

    show damien at movex(0.32)
    show damien sheepish with eidissolve_nd

    D "What, already forgot about me?"

    D "You don't got anywhere to be right?"

    show inco concerned with eidissolve_nd

    I "I, uhh{cps=5}...{/cps}{w=.3} Yea-"

    D "You stuttered! Come on, we're going somewhere."

    show inco surprised with eidissolve

    "...May as well, right?"
    
    show damien happy with eidissolve

    "Damien excitedly motions at me to follow through the traffic of students going about the lunchroom."

    show damien at moveoutright(0.32)
    hide damien
    pause 0.5
    show inco neutral right with eidissolve_nd

    "Peering in through the crowd, waving me over, and disappearing again like he's outrunning something."
    window auto hide

    show inco:
        pause 0.3
        easeout_cubic 1 xpos 0.65

    camera:
        pause 0.65
        easeout_quad 1 xpos 0.1
        linear 1 xpos 0.3

    $ renpy.music.set_volume(1.0, 3.0, "ambient1")
    $ sprHandler_CrowdTransitionIn()

    pause 2.5

    "It's a good thing I hadn't gotten my own lunch yet, it'd be dumped on the ground about three elbows and a slap ago."

    "Through the clamoring I hear something about a turf war restarting with the new year, and that Megalodons will continue to rule."

    "Somewhere mixed in is the undeniable sound of a steel chair clattering to the ground."

    "The place is an actual warzone now. How on earth is Damien able to weave through these guys so easily?"

    stop ambient1 fadeout 7

    camera:
        xpos -0.3
        linear 1 xpos -0.1
        easein_quad 1 xpos 0.0

    show damien happy left at setx(0.65)

    hide inco

    hide temp_crowdperson_1
    hide temp_crowdperson_2
    hide temp_crowdperson_3
    hide temp_crowdperson_4
    hide temp_crowdperson_5
    hide spr_crowdbackdrop_back_right
    hide spr_crowdbackdrop_back_left
    hide spr_crowdbackdrop_front_right
    hide spr_crowdbackdrop_front_left
    $ sprHandler_crowdTransitionAway()
    pause 1.0

    "Eventually he leads me to the far corner of the room, and to his usual lunch table."

    show inco verysad at moveinright(0.35) with eidissolve
    show damien at nudgeup()

    D "Hey, you're alive!"
    pause 0.5

    I "{cps=20}I think one of my ribs is cracked...{/cps}"

    D "That's just the school spirit you're feeling!"

    "{cps=10}Oog...{/cps}"
    pause 0.5

    "I feel less like a person and more like a..."

    show inco neutral with eidissolve

    "I finish stretching my wounded back and actually check the table."

    "{cps=10}It's...{/cps}{w=.3} basically empty."

    "There's only one other person here."

    play music mus_general

    show inco at movex(0.25)
    show damien at sety(), movex(0.5)

    show olivia skeptical left at moveinleft(0.75) with eidissolve
    #olivia appears omg!
    "The gator girl gives an unamused raised brow."

    show inco concerned with eidissolve
    I "{cps=15}Uhh...{/cps}{w=.4} {cps=15}Hey...{/cps}{w=.4} {cps=15}you...{/cps}"

    # For skipping
    $ sprHandler_crowdTransitionAway(True)
    camera:
        xpos 0.0
    with None

    show olivia neutraldown
    show damien shocked left
    with eidissolve_nd

    D "Oh, snap, you know Olivia?"

    show inco neutral at setx(0.25), nudgeup()

    I "Olivia! Right, yeah."

    show damien happy left with eidissolve_nd
    D "The one and only!" 

    D "Why didn't you tell me you met already?"

    show inco neutral with eidissolve
    I "{cps=15}...Because I...{/cps}{w=.4} only sort of did? We're in the same class."

    D "Ah! Okay, I get it now!"

    D "Still, that sounds awesome! All my lunch buddies are artists!"

    I "All?"

    D "Oh, yeah. There's usually a third in our group, but she's out screwing around in school business."

    D "She'll probably be back tomorrow. Student council stuff can't take {i}that{/i} long, right?"
    pause 0.5

    I "What's she need with the student council?"

    D "Oh, she doesn't {i}need{/i} anything with the student council, she's in it!"

    D "She's the treasurer!"

    show inco surprised with eidissolve

    I "The treasurer?"

    D "Something like that.{w=.5}{nw}"

    show damien right with eidissolve_nd

    extend " What do you think, Olivia?"
    pause 0.5

    "Olivia just grunts in reply."

    "She doesn't even bother to look up from her lunch tray."

    show inco neutral with eidissolve

    I "Aren't you an artist too, Damien?"

    show damien neutral left with eidissolve_nd

    D "Nahhh, I don't got the patience to sit around for hours like that."

    I "So you're not taking advantage of the art programs here?"

    D "Don't really need 'em."

    D "Home's just real close by."

    D "Only other artist here today is Olivia."
    
    show damien at movex(0.53)
    show damien right with eidissolve

    "His arms wave over Olivia as if he was presenting her at an auction or something."

    "For her part, the gator girl just grunts again."

    show damien at movex(0.5)
    pause 0.5

    I "Well, what do you do then, Olivia?"

    show olivia neutral with eidissolve

    "Finally she looks up, turning an indifferent look my way."
    pause 0.5

    O "---"

    show inco skeptical behind olivia with eidissolve

    "{cps=5}...{/cps}Did she say something?"

    I "What was that?"

    show olivia angry left with eidissolve

    O "--------."

    "The ambient war noises are 'a bit' too loud. Can't hear a thing."
    pause 0.5

    I "Sorry, I can't hear anything you're saying over the..."

    show damien left with eidissolve_nd

    D "Don't sweat it, she's just the real quiet type-"

    show damien shocked at setx(0.5), nudgeupinv()
    show inco shocked at nudgeupinv()
    show olivia at hit(0.75)

    O "{sc}{i}I PAINT.{/i}{/sc}" with xpunch

    show damien right 
    show olivia angry
    with eidissolve

    D "Whoa, hey."

    "Holy hell, her voice sounds so raspy, as if she'd never drank a drop of water in her life."

    "Guess I hadn't noticed before when she gave those one syllable responses, but for someone's voice to be strained from a single shout?"

    show olivia annoyed left
    with eidissolve

    "She furrows her brow and looks back down at her lunch."

    show olivia neutraldown
    show inco neutral
    with eidissolve

    pause 0.5

    show damien at nudgeup()
    show damien left with eidissolve_nd

    D "Oh snap! We've been standing around for a while!"

    show damien neutral with eidissolve

    "He sits back in his own seat and takes a huge bite of mystery meat steak."

    "Right. Food."

    "After the workout and poor breakfast today I'm particularly famished now."
    pause 0.5

    "{cps=10}But...{/cps}"

    show inco concerned left with eidissolve

    I "The line..."

    show damien skeptical
    show olivia neutral
    with eidissolve

    "All eyes look to where the lunch line should be."

    "And it's become a full-blown riot."

    "Someone's got a fire extinguisher trying to stop it."
    pause 0.5

    D "Oh, I probably should've waited for you to get yours."

    show damien sheepish left with eidissolve_nd

    D "Oops!"

    show damien angrydown
    show inco neutral right
    with eidissolve

    "Damien returns to his steak. Rather aggressively."

    "But who am I to question dino etiquette and the act of using one's foot to anchor the food for tearing."

    pause 0.5
    show olivia at setx(0.75), backmovex(0.73)

    "Suddenly, the sound of squeaking rubber draws both of our attention towards Olivia."

    "She's holding onto one of her wheels, having just skidded it across the granite floor."

    show damien happy right with eidissolve

    D "{cps=5}...{/cps}Oh! What's up?"

    show olivia considering with eidissolve

    "She tilts her head back, towards the courtyard door behind us."

    "{cps=5}...{/cps}It looks like there's a few vending machines out there."
    pause 0.5

    I "Huh. I guess I'll check them out."

    show inco neutral at moveoutright(0.25) with eidissolve
    hide inco

    "I leave the group behind to go try and get lunch."
    window auto hide
    pause 0.25

    scene black with dissolve
    pause 0.25

    "Not a fan of soda and chips for a meal, but it's enough for wartime survival..."
    pause 0.5

    "Hey, this thing accepts credit cards. Handy."

    "I pick out a few brands I recognize, enough to tide me over for the rest of the school day."

    "I bend to pick up the bags from the dispenser slot and..."

    #here there will be a pan cut with motion blur to Olivia

    pause 0.5

    "{cps=5}...{/cps}That green chick's looking at me."

    "She notices me gazing at her and hunches over again hurriedly."

    "What's that all about?"

    pause 0.5

    "{cps=5}...{/cps}"

    "Right, making new friends."

    pause 0.5

    "I buy a few extra sodas for the table."
    window auto hide
    pause 0.25

    scene bg_cafeteria 
    show damien neutral at setx(0.5)
    show olivia neutral left at setx(0.75)
    with dissolve
    pause 0.25

    show inco neutral left at moveinleft(0.25) with eidissolve
    show inco right with eidissolve

    "Carrying everything back in both arms, I place them on an empty spot, sliding a can of soda to Damien."

    "He looks at me like I had just tossed him a gold bar."

    show damien at hop()
    show damien pog left with eidissolve

    D "WHOA, DUDE!"

    show damien at nudgeup()
    show damien happy with eidissolve

    "The Dilo-boy's mouth open wide as he chomps on the bottom of the can, his fangs piercing the thin metal and spraying it's contents down his gullet."

    show olivia neutraldown with eidissolve

    "I toss some over to Olivia as well. She eyes it as though it were boobytrapped before taking a bag of chips."

    "Damien sighs happily as he chucks the shredded remains of his can away."
    pause 0.5

    D "Mm, caffeine ambrosia."

    show damien thinking left with eidissolve 
    D "What were we talking about before?"

    pause 0.5
    show damien happy left with eidissolve_nd

    D "Olivia's art! Right."

    D "She's *REALLY* good, Inky! Like, you wouldn't believe."

    "Can he at least stick to a nickname?"

    I "Really?"

    D "Oh totally, she's like, won awards and stuff."

    "She has?"
    pause 0.5

    I "Can I see them?"

    I "In fact, I could snap some glamor shots for you."

    D "No need dude, I've already got pictures on my phone."

    I "No I mean, hold on."

    "I pick my backpack up from the floor, unzipping it and retrieving my beloved camera from it."
    pause 0.5

    I "I'm actually into photography."

    show damien happy left at easemovex(0.45)
    pause 0.5

    "The dinoman reaches for the well-aged DSLR, and on instinct I swat his hand away."

    show inco annoyed at hit(0.25)
    show damien shocked at backmovex(0.5)
    pause 0.25

    D "Hey!"

    show inco neutral with eidissolve_nd

    I "Sorry, force of habit."

    show damien neutral right with eidissolve

    D "What do you think, Olivia?"

    show olivia annoyed with eidissolve

    "She eyes me up and down with the same furrowed brow."

    show olivia neutral with eidissolve

    O "{cps=5}...{/cps}Aren't you the guy that ate dirt in gym yesterday?"

    InDa "{color=#FFC3C5}Yep!{/color} \n{color=#C3D3FF}No!{/color}"

    show inco unimpressed with eidissolve

    "I shoot Damien a quick dirty glance before returning to look at Olivia."

    show inco explaining with eidissolve

    I "It wasn't that bad!"

    show damien happy left with eidissolve_nd

    D "It was pretty bad."

    show inco skeptical with eidissolve_nd

    I "It wasn't! And how does everyone seem to know about it?!"

    show damien sheepish left with eidissolve

    "Damien looks aside sheepishly."
    pause 0.5

    D "I {cps=10}maaaay{/cps} have had a hand spreading the story around?" 

    show inco unimpressed with eidissolve
    pause 0.5
    show damien at setx(), hop()

    D "I thought it was funny!"

    show damien happy left with eidissolve

    D "Don't worry though, everyone has some embarrassing story."

    D "One time I got my frills stuck in the bathroom stall."

    show inco concerned with eidissolve

    I "{cps=5}I...{/cps}{w=.3} didn't need to know that{cps=5}...{/cps}"

    show olivia attentive left with eidissolve

    O "It took him an hour to get it out."

    D "See? Everybody's got something."

    show olivia neutral
    show inco neutral
    with eidissolve

    "Olivia pops a chip into her jaws, her face looking out to nowhere as if she's thinking of something."
    pause 0.5

    O "Hm."

    show damien at sety(), movex(0.45)
    pause 0.5

    "Damien leans close to me. One of his frills extends to hide from Olivia."
    pause 0.5

    D "Dude, I haven't seen her talk this much during lunch since last year!"

    show inco skeptical with eidissolve

    I "She said three things and one of them was a grunt. Why the secrecy?"

    D "It's like a secret meeting. Those are cool."

    I "Uh huh."
    pause 0.5

    D "But yeah, this is something else! She's really warming up to you, I can tell."

    show damien at movex(0.5)
    pause 0.5

    "He sits back down properly."
    pause 0.5

    "Honestly, this whole thing is a little creepy."

    "She's probably not a bad person to talk to, but Damien isn't helping any."

    "As eager as I am to make new friends this year, this is definitely not how I thought it would pan out."

    show inco neutral with eidissolve

    "Maybe it's best that I get through lunch quickly and quietly."

    "At least I have a spot to sit during lunch. Not like I'd have any other options."
    pause 0.5

    B "Ah, there you are, Inco!"

    show inco surprised with eidissolve

    "A voice rings out to greet me, which catches our attention."

    show inco left with eidissolve

    "I see a familiar bespeckled face walk over to us with a lunchtray in his hands."

    show inco at movex(0.4)
    show damien at movex(0.6)
    show olivia at movex(0.8)
    show ben happy at moveinright(0.2) with eidissolve

    B "Glad to see that you've made it to lunch this time."

    D "Oh, hey Ben! I'm guessing you and Inky here already met?"

    show ben neutral with eidissolve_nd

    B "Mhm, introduced myself after I bumped into him the other day."

    D "Speaking of bumps, you should've seen Inky here yesterday!"

    show damien:
        easeout_cubic 0.4 xpos 0.55
        easein_cubic 0.75 xpos 0.6

    pause 0.4
    show inco concerned at hit(0.4, 0.75)

    "Damien lets out a cackle and slaps me on the back, igniting the gym pains in my body and almost knocking my glasses off."

    show ben happy with eidissolve

    "Ben gives a concerned half-smile."

    "This must be my eternal torment for the rest of the semester."

    show inco neutral left with eidissolve
    show ben sheepish with eidissolve

    B "Yeah{cps=5}...{/cps}{w=.3} About yesterday."

    show ben neutral left with eidissolve

    "Ben looks down the isle of chatting students and signals to someone with his head."

    "Standing ten feet away from us is an imposing looking dinosaur girl, with blonde hair, crimson scales, and sporting a fiery red leather jacket."

    stop music fadeout 7

    show damien shocked at setx(0.6), nudgeup()
    show inco surprised at setx(0.4), nudgeup()

    pause 0.5

    show ben at sety(), movex(0.1)
    show inco at sety(), movex(0.6)
    show damien at movex(0.75)
    show olivia at movex(0.9)
    with None

    show ben unimpressed left
    show olivia skeptical left
    with eidissolve

    "Ben uses his hand to usher her over while also mouthing a hushed 'come on.'"
    pause 0.5

    Mia "Ugh..."

    "She slowly makes her way over, and I notice how some of the students begin to quiet down as she passes them by."
    window auto hide
    pause 0.5

    show ben right
    show mia neutral:
        matrixcolor BrightnessMatrix(-1)
        moveinright(0.35, 0.0, .3, 2.5)
    with eidissolve
    pause 1.5
    show mia neutral with Dissolve(1):
        setx(0.35)
        matrixcolor BrightnessMatrix(0.0)
    pause 0.5

    "As she gets closer, her intense presence invades me, and even though we're about the same height, I feel like an ant about to get crushed under her boot."

    show inco concerned left with eidissolve

    "Somewhere in me a synapse connects her face to me tasting bright red rubber yesterday. I really wish it hadn't."

    show ben sheepish with eidissolve

    B "Inco,{w=.3} uh{cps=5}...{/cps}{w=.3} Mia here has something to say to you."

    show ben neutral with eidissolve
    pause 1.0
    show black behind mia, inco:
        alpha 0.0
        linear 1.0 alpha 0.5
    show ben behind black
    show mia angry with eidissolve

    "Mia stays silent, but continues to glare at me from under her neatly cut fringe."
    pause 0.5

    "She sucks in air through her teeth."
    pause 1.0

    Mia "{w=.5}{cps=5}...{/cps}{w=.5}{cps=10}Sorry...{/cps}"

    pause 1.0
    show mia smug with eidissolve_nd

    "The corner of the girl's lips start to rise."

    window auto hide
    pause 0.3

    play music mus_mia1
    play sound snd_slapstick_thunder
    pause 0.2

    show ben skeptical
    show white behind mia, inco
    hide white with Dissolve(1.5)
    pause 0.3

    show mia taunting with eidissolve

    Mia "I didn't {i}mean{/i} to knock your lights out."

    camera:
        ease_quad 1.25 xpos 0.12 zoom 1.2

    show black:
        linear 1.0 alpha 0.75

    show mia at movex(0.5) behind inco
    with None

    show mia smug
    show ben shocked
    show olivia surprised
    with eidissolve

    show inco shocked at setx(0.6), nudgeup()

    "The girl lets out a laugh as lays an arm around my shoulder, her smile growing wider"

    "Heat creeps along my face as her muzzle nears my ear, especially when a puff of hot air blows by the lobe."
    pause 0.5

    show inco at hitx(0.6, 0.5)

    "The heat is torn away though when I feel her fingers dig roughly into my shoulder, and her sharp hiss of a whisper scrapes my eardrum."
    
    show mia neutral with eidissolve

    Mia "That ball was me being nice, baldy."

    Mia "Screw the class over again, and I'll fucking{w=.4}{nw}"
    
    show mia furious at setx(), hity()

    extend " END you."
    pause 0.5

    show inco at rotate_funny(0.05)
    pause 0.25

    "Nodding in understanding, Mia pushes away from me with a small cheer."

    camera:
        easein_cubic 1 xpos 0.0 zoom 1.0
    show inco at backmovex(0.65)
    show mia at movex(0.35)
    with None

    show mia cheerful left
    hide black
    with eidissolve

    Mia "See, all clear now Benny Boy. Can I go now?"

    show ben at movex(0.125)
    show ben nervous with eidissolve
    
    B "Uh,{w=.3} Mia{cps=5}...{/cps}That's not quite-"

    show mia at setx(0.35), nudgeup()
    show mia angry with eidissolve_nd

    Mia "Shut it, glasses. I'm fixin' things here."
    pause 0.5

    B "{cps=5}...{/cps}You're making it worse{cps=5}...{/cps}"

    show mia flipoff with eidissolve_nd

    Mia "Oh, well fuck you then!"
    window auto hide

    stop music fadeout 5.0

    show mia right with eidissolve
    pause 0.75

    show mia at sety(), moveoutleft_cs(0.35)
    show mia angry left with eidissolve
    hide mia 

    pause 1.0

    show inco at setx(0.65), standup(0.0, 1, 0.5)
    show ben unimpressed left with eidissolve_nd

    "She flips us off collectively and backs into the crowd, vanishing before either one of us could fully process her words and actions."

    show damien neutral left with eidissolve

    "Damien nudges my side."
    pause 0.5

    D "Dude, I think she likes you."

    show ben at movex(0.2, 1.5)
    show inco:
        resetrotate
        movex(0.4, 1.5)
    show damien at movex(0.6, 1.5)
    show olivia at movex(0.8, 1.5)

    show olivia neutral with eidissolve

    "Ben sighs."
    pause 0.5

    play music mus_ben

    show ben sheepish right with eidissolve_nd

    B "Sorry about that, Inco."

    B "I heard earlier about what happened at PE and connected the dots."

    show inco neutral left with eidissolve

    I "It's fine, it was just dodgeball. Not like she was looking to do something."
    pause 0.5

    B "{cps=5}...{/cps}Yeah."

    show ben unimpressed with eidissolve

    B "Uh, Damien?"

    show damien at setx(0.6), nudgeup()

    D "Hm?"

    "Damien looks up from the rest of his meal having selectively heard his name."

    "He wasn't even paying attention- how?"
    pause 0.5

    B "Could you not spread rumors around about your fellow classmates?"

    show damien happy with eidissolve

    D "No worries, Niko and I are cool."

    show ben skeptical with eidissolve

    B "{cps=5}...{/cps}"

    B "That {i}still{/i} doesn't make it right."

    show damien skeptical with eidissolve

    D "{cps=10}Uh...{/cps} Sure, yes sir. Yeah."

    show damien at nudgeup()

    "He gives Ben a lazy salute."
   
    show ben unimpressed with eidissolve

    "Ben merely sighs as he places his tray on the table and makes himself comfortable on the seat next to me."

    show damien neutral with eidissolve

    "As he settles in, Ben notices my camera, still out on the table."

    show ben surprised with eidissolve

    B "Oh, is this your camera, Inco?"

    I "Huh? Oh yeah, I was showing it to Damien and Olivia earlier."

    show ben neutral with eidissolve

    B "May I?"

    "I feel my instincts kick in for a moment before remembering that Ben also works with a camera."

    I "Sure, have a look."
    pause 0.5

    "I watch as Ben gingerly picks up my camera and gives it a thorough inspection."

    show ben explaining with eidissolve

    B "I must say, as far as standard cameras go, yours is a good quality."

    I "It's nothing too special really. Just something I picked up a while back."

    show ben happy with eidissolve_nd

    B "Well, you have a good taste in camera models."
    pause 0.5

    "He hands me back my camera, to which I place it back into my backpack."
    pause 0.5

    I "Thanks."

    B "With something like that, it'd be easy to get some great shots."

    I "Well, I do have a small collection in a portfolio drive."

    B "A portfolio? Ah man, I'd only just got mine a month ago."

    B "I bet you've got like a dozen pieces to choose from for the new year's art contest."

    show inco surprised left with eidissolve

    "The what?"
    pause 0.5

    D "He missed that announcement."

    show inco skeptical right with eidissolve

    I "What announcement?"

    show ben at setx(0.2), nudgeup()
    show inco left with eidissolve_nd

    B "The school has an annual art contest at the start of every new year!"

    show olivia:
        subpixel True
        on hide:
            pause 5
            parallel:
                easeout_cubic 1.5 xpos 0.8 + 0.1
            parallel:
                pause 1.0
                easeout_quad 0.5 alpha 0
    hide olivia

    B "The winner gets a small cash prize, but the bigger prize is the fact that the winner's piece is submitted for publication in a couple big-time magazines!"

    show inco neutral left with eidissolve

    "Oh."

    show inco happy left with eidissolve

    "Oh wow!"

    I "That sounds awesome!"

    B "Of course, that also means a lot of the students plan ahead and work all summer for something to submit."

    D "Did you do anything for it Ben?"

    show ben at nudgeup()
    show ben cheerful with eidissolve

    B "You know it!"

    D "Well, good luck, Liz said she'd turned in the perfect piece yesterday."

    I "Okay, now I'm interested."

    "Finally, a chance to show my real skill at something I'm good at!"

    show damien happy at nudgeup()

    D "Hey! Olivia could help you out! With your shots and her art, you two could totally win!"

    D "Right Olivia?"
    pause 0.5

    "{cps=5}...{/cps}"

    show damien skeptical right with eidissolve

    D "Olivia?"

    show inco neutral right
    show damien shocked
    show ben surprised
    hide olivia
    with eidissolve

    "We all turn our heads to Olivia, only to realize that she's disappeared."

    show inco skeptical with eidissolve

    "When did she leave?"

    show ben at sety(), movex(0.25)
    show inco at movex(0.5)
    show damien at sety(), movex(0.75)
    pause 1.0

    show inco at movex(0.53)
    pause 0.5

    "Confused, I scan around the cafeteria, and my eyes manage to spot her through the crowd of students."

    "She's rolling away towards the cafeteria doors, and quickly."

    "Just like that, I lose sight of her as fast as I had seen her."

    show inco at movex(0.5)
    show inco surprised with eidissolve
    
    "I turn to look at Damien and Ben."

    show damien pondering right with eidissolve

    "Damien not only looks puzzled, but also disappointed for some reason."

    show inco left with eidissolve

    "Ben, meanwhile{cps=5}...{/cps}"

    show ben unimpressed with eidissolve

    "Well, he almost looks annoyed that Olivia left."
    pause 0.5

    D "{cps=5}...{/cps}"
    pause 0.5

    D "Guess she hasn't changed."

    show ben angry with eidissolve

    B "So it seems."
    pause 0.5

    "The venomous sting to his words makes me feel like there's more going on than I'm aware of."

    "I decide not to try to pry into it, and instead bring the conversation back."

    show inco neutral with eidissolve

    I "Well, I still wanna try."

    show ben neutral with eidissolve_nd

    B "You can upload your submission on the school's website."

    I "Oh. Then I'll need an account."

    show damien neutral left with eidissolve_nd

    D "You don't have one?"

    I "Don't think so. I've been told they'll get me that stuff by the end of the week."

    B "Sounds about right."
    pause 0.5

    B "Truthfully it takes maybe five minutes at most to deal with that."

    I "Then why the wait?"

    B "Nobody wants to deal with it. "
    pause 0.5

    I "{cps=5}...{/cps}Guess I'll wait then."

    show ben sheepish with eidissolve

    "Ben scratches the side of his head."
    pause 0.5

    B "Uhh, I think there's someone in StuCo that can help you out, actually."

    B "It's the Treasurer's duty day today."

    show damien happy with eidissolve

    D "So that's where Liz ended up."

    show ben neutral with eidissolve_nd

    B "I don't know any names, so maybe?"

    "Huh, guess I'll get to meet Liz sooner rather than later."
    pause 0.5
    
    I "Think I'll take care of that before lunch is over then."

    I "See you in class Ben."

    show ben neutral with eidissolve

    B "Sure thing."

    show inco right with eidissolve

    I "Later Damien."

    show damien at setx(0.75), nudgeup()

    D "Deuces man! Tell Liz I said hi!"
    pause 0.5

    "I grab some of the leftover snacks from the table and my backpack and head out of the cafeteria."

    stop music fadeout(3.0)

    show inco at moveoutleft_cs(0.5)
    show inco left with eidissolve
    hide inco
    
    "Finally I can show off my skills. Show that I'm just as capable an artist as anyone else here."
    window auto hide
    pause 0.5

    scene black with dissolve 
    pause 0.5

    "{cps=5}...{/cps}"
    window auto hide
    pause 0.5

    scene bg_computerroom with Dissolve(1)
    pause 0.5

    "The computer lab is in an offshoot room from our library."

    "As for the library itself, aside from an expected emphasis on anatomy drawing guides and the like it's pretty standard."

    "Not to brag, but the school I was at for my freshman and junior years had a library with two floors."

    "{cps=5}...{/cps}Probably should've read a thing or two with all those resources{cps=5}...{/cps}"
    pause 0.5

    "I'm getting off topic. The computer lab is the focus."

    pause 0.5
    show inco neutral at moveinright(0.5) with eidissolve

    "The calm tranquility of the library is overtaken by the organized sterility of the lab."

    "Forty standardized sets of computers and monitors line the walls, forming a panopticon around the desk reserved for the teacher in the middle."

    "I remember them being organized differently in elementary school, but for a few years now I've just been seeing this formation."

    "Sounds to me like {i}someone{/i} got caught one too many times working on{cps=5}...{/cps}{w=.4} more risque art pieces."

    show inco skeptical with eidissolve

    "The monitors are all turned on, but only one's logged in."

    "Weird, there's nobody here."

    "Damien and Ben said Liz would be here, though. Maybe she's in the bathroom?"

    show inco at easemovex(0.6)
    show inco neutral with eidissolve
    pause 0.5

    "I'm not one to pry and snoop around, but I'm really pressed for time here..."
    pause 0.5

    "Onscreen, I see pdfs and documents open. They look finance-related, and filled with abbreviation and jargon. Nothing I can even understand."

    "...Maybe I can figure out how to create my account on my own?"
    window auto hide
    pause 1.0

    show lizhead shocked:
        ypos -0.27 + LIZHEADY_NEUTRAL xpos 0.3
        easein_cubic 2 ypos LIZHEADY_NEUTRAL
    pause 1.5

    L "What are you doing?"

    show lizhead at nudgeup(LIZHEADY_NEUTRAL)
    show inco at hop()
    show inco falling left with eidissolve_qrt_nd

    I "AH-" with xpunch

    "HAUNTED HIGHSCHOO-"

    L "I uh-{w=.4} didn't mean to scare you."

    pause 1.0
    show inco verysad left with eidissolve

    play music mus_awkward fadein 3.0

    "Oh{cps=5}...{/cps}{w=.4} Oh, thank Christ. It's just a dino girl with an extremely long neck and {i}not{/i} a specter."

    show lizhead unimpressed with eidissolve

    L "No really, what were you doing to the fiscal report I was working on?"

    show inco neutral with eidissolve

    I "I didn't do anything!"

    show lizbody left behind lizhead, inco with eidissolve:
        parallel:
            moveinleft(0.8, t=0.75)
        parallel:
            pause 0.5
            easeout_cubic 0.4 xpos 0.7
            easein_cubic 0.4 xpos 0.75
    pause 0.3
    show inco at backmovex(0.3, 1.5)
    show inco right with eidissolve

    show lizhead:
        parallel:
            ease_cubic 1.5 ypos 0.05
        parallel:
            movex(0.79, 2.0)
    show lizbody:
        movex(0.6, 0.75)
        parallel:
            ease_back 0.75 ypos 0.1
        parallel:
            pause 0.375
            "lizbody furious"
            pause 0.375
            block:
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                pause 0.5
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                pause 0.25
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                pause 1.0
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                linear 0.05      ypos 0.105
                easein_cubic 0.2 ypos 0.1
                pause 0.5
                repeat
    with None

    show lizhead angry
    show lizbody right
    with eidissolve_nd

    L "I've been WORKING on that all day- why did you touch it?"

    show inco concerned with eidissolve_nd

    I "I didn't, I only minimized it, I swear."

    "Right, I'm here for a reason."

    show inco neutral with eidissolve

    I "Uh,{w=.4} are you Liz?"

    "The brachiosaurus furiously re-opens all her windows and for a while types out some information before acknowledging me again"

    # hack
    hide lizbody
    show lizbody furious at setxy(0.6, 0.1) behind lizhead
    show lizbody:
        movexy(0.7, 0.0)
    show lizhead at movexy(0.7 - LIZHEADX_NEUTRAL, LIZHEADY_NEUTRAL, 1.25)
    with None

    show lizbody neutral left
    show lizhead unimpressed left
    with eidissolve


    L "Excuse me?"
    window auto hide
    pause 0.5

    menu:
        "Ben sent me.":
            pause 0.5
            jump Ben_Sent_Me
 
        "Damien told me about you.":
            pause 0.5
            jump Damien_Told_Me_About_You

    label Ben_Sent_Me:

    I "I wanted to submit something for that art contest going on, but I don't have my school login info yet. Ben told me you'd be able to help."

    show lizhead considering left with eidissolve

    L "Ben, huh{cps=5}...{/cps}"

    I "Well, Ben {i}and{/i} Damien."

    L "Hm."
    pause 0.5

    "She mumbles something beneath her breath and turns her head back to me."

    jump liz_conv_ch2



    label Damien_Told_Me_About_You:

    I "I met Damien, we hit it off pretty alright. He mentioned you when I heard I'd have to wait a while to get my login stuff."

    show lizhead happy with eidissolve

    L "Damien mentioned me?"

    L "Oh, you're the guy that got smeared into the ground in gym class yesterday."

    I "{cps=5}...{/cps}"

    jump liz_conv_ch2



    label liz_conv_ch2:
    L "Yeah, I'm Liz."
    window auto hide

    show lizhead:
        parallel:
            ease_cubic 1.5 xpos 0.1
        parallel:
            ease_cubic 1 ypos 0.05 + LIZHEADY_NEUTRAL
    show lizhead neutral with eidissolve

    show lizhead right
    show inco left
    with eidissolve
    pause 0.5

    show lizhead behind inco:
        parallel:
            ease_cubic 1.5 xpos 0.7 - LIZHEADX_NEUTRAL
        parallel:
            pause 0.25
            ease_cubic 1 ypos LIZHEADY_NEUTRAL
    pause 0.5

    show lizhead left
    show inco surprised right
    with eidissolve

    "Whoa."
    pause 0.5

    I "Inco."

    I "But yeah, I'm new here, so I need an account."

    show lizhead explaining left with eidissolve

    L "Oh, well that's no trouble at all."

    show lizbody behind lizhead
    $ liz_movex_cs(0.6, "neutral right", "neutral right")

    "Liz sits down and cracks her knuckles as she starts typing away at the keyboard."


    show lizhead at movexy(0.79, 0.05)
    show lizbody:
        backmovey(0.1)
        block:
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.5
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.25
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 1.0
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.5
            repeat
    show lizbody furious with eidissolve

    L "Alright, I'll see if I can get that done for you..."

    "In a flourishing display of spreadsheet software experience, Liz navigates and organizes several documents in seconds."

    "I've always had the general idea that there were a lot of shortcuts and commands, but yeesh."
    pause 0.5

    L "So, you're an artist too?"

    show inco skeptical with eidissolve

    I "Hm?"

    L "Since you want to enter the contest so bad."

    show inco neutral with eidissolve

    I "Oh, yeah, I'm a{cps=5}...{/cps}{w=.3} Photographer."

    L "Yeah? How're you liking it here so far?"

    I "It's pretty good, although I feel bad about missing most of the first day."

    show lizhead considering with eidissolve_nd

    L "Eh, it's not your fault."

    I "Guess not."
    pause 0.5

    I "{cps=5}...{/cps}Although truth be told, I see those paintings framed in the hall by the principal's office and it does put a bit of rain on my parade."

    show lizhead thinking with eidissolve

    L "Oh. Those. Yeah, I get what you mean."

    L "I think it's like that by design, honestly." 

    L "Something about 'breaking the students' egos'."

    L "Then you end up wanting to improve like crazy so you can reach your goals."

    L "At least, that's what happened to me."

    I "Your goals?"

    show lizhead at movexy(0.6 - LIZHEADX_NEUTRAL, LIZHEADY_NEUTRAL, 1.25)
    show lizhead explaining left with eidissolve

    L "Yeah, I'm planning on going to University and getting degrees in Design and Business."

    L "Then I'll open up my own advertisement company."

    I "Ambitious."

    show lizhead neutral with eidissolve

    L "Don't see how anyone can afford not to be. You?"
    window auto hide
    pause 0.5

    menu:
        "I'm going to be an influencer-blogger and be crazy popular.":
            pause 0.5
            pass
        "I'm going to publish a photography magazine.":
            pause 0.5
            pass 
        "I don't know, but it's going to be big.":
            pause 0.5
            pass
        
    L "Mhm."

    L "Well, it's something."

    L "More than a lot of people here."

    show inco skeptical with eidissolve

    I "What's that mean?"

    show lizhead unimpressed left with eidissolve

    L "Like half the school may as well just be in a daycare."

    L "Sorry if that sounds rude."

    I "Like they aren't taking advantage of the programs here?"

    L "Yeah, some don't, like a friend of mine."

    I "You mean Damien?"

    show lizhead at setx(0.6 - LIZHEADX_NEUTRAL), nudgeup(LIZHEADY_NEUTRAL)
    show lizhead shocked with eidissolve
    pause 0.5
    show lizhead at movex(0.65 - LIZHEADX_NEUTRAL)
    show lizhead unimpressed right with eidissolve_nd

    L "Yeah, I shouldn't have mentioned it."

    show lizhead at movex(0.6 - LIZHEADX_NEUTRAL) with None
    show inco neutral
    show lizhead neutral left
    with eidissolve_nd

    L "Ah, well I hope he hasn't been causing you any trouble. He can be a bit of silly-billy sometimes."

    "'Trouble' is a bit of an understatement."
    pause 0.5

    I "He's definitely the friendly type. He even partnered with me in gym and dragged me along to sit with him at lunch."

    show lizbody at movey(0.1)
    show lizhead thinking left with eidissolve

    L "{cps=5}...{/cps}Is that so?"

    I "Yeah. He was really excited about it, too."

    I "He's really welcoming me into this lunch friend group thing."

    show lizhead at setx(0.6 - LIZHEADX_NEUTRAL), movey(LIZHEADY_NEUTRAL + 0.05)
    show lizhead unimpressed with eidissolve

    "Liz sighs."
    pause 0.5

    L "Not this again..."

    show inco surprised with eidissolve_nd

    I "What?"

    show lizhead at movey(LIZHEADY_NEUTRAL)

    L "I'm guessing he introduced you to Olivia as well?"

    show inco neutral with eidissolve_nd

    I "Well, we share a class but I didn't get a proper introduction until lunch."

    show lizhead sad with eidissolve_nd

    L "Oh, boy. I'm sorry about that, Inco."

    I "What, is Damien messing with me?"

    show lizhead shocked at nudgeup(LIZHEADY_NEUTRAL)

    L "Nono, Damien is great."

    show lizhead thinking with eidissolve_nd

    L "He's just, maybe a little too eager. If he considers you a friend to him, he'll want you to be our friend, too."

    L "Specifically, he'll want you to be Olivia's friend."

    I "What's wrong with that?"

    show lizhead unimpressed with eidissolve

    L "Nothing, nothing at all."

    L "But you've seen Olivia, you can probably tell she's a bit{cps=5}...{/cps}"

    L "Unresponsive? Doesn't really like to talk to anyone, not even Damien."

    L "So you can definitely try to be her friend, but just know that she'll most likely ignore you."

    show lizhead at movey(LIZHEADY_NEUTRAL)
    show inco surprised with eidissolve

    I "You don't like Olivia?"

    show lizhead neutral with eidissolve

    L "What? No, I do. She's fine, I guess. I sit with her during lunch, after all."

    L "And I'm sure you'll get along with us just fine."

    L "And hey, I'd love to see Olivia make a friend."

    show lizhead considering with eidissolve

    L "Just... don't get too invested trying to get her to warm up to you."

    show lizhead at easemovey(LIZHEADY_NEUTRAL + 0.05)
    pause 0.5

    "There's history to that warning."

    show inco skeptical with eidissolve

    I "Why does she stick around then, if she doesn't want to be friends?"

    show lizhead neutral with eidissolve_nd

    L "Oh, Damien didn't mention? They live together."

    I "They're{cps=5}...{/cps}{w=.3} siblings?"

    L "Not exactly. You'll have to ask him about it."

    I "Huh."

    show inco neutral with eidissolve

    L "Damien's also just incredibly patient and outgoing."

    show lizhead at easemovey(LIZHEADY_NEUTRAL)
    show lizhead happy with eidissolve
    #Have's Liz's eyes show a bit of 'dreaminess' 

    L "{cps=20}I envy him...{/cps}"
    pause 0.5

    show lizhead:
        ease_cubic 0.2 ypos LIZHEADY_NEUTRAL + 0.02
        ease_cubic 0.3 ypos LIZHEADY_NEUTRAL

    show lizhead neutral with eidissolve

    L "But yeah, he would like nothing more than everyone getting along like best buddies..."

    L "Unless you're like Damien and you can be pleasant to a brick wall forever, your time is probably better spent elsewhere."

    show lizhead thinking with eidissolve

    L "{cps=10}So...{/cps}{w=.4} how serious are you about your ambitions?"

    I "{cps=5}...{/cps}Pretty serious, I think."

    show lizhead at nudgeup(LIZHEADY_NEUTRAL)
    pause 0.5

    "Liz nods."

    L "Something to keep in mind, then."

    L "It's a struggle, but like Damien says, we gotta keep trying, right?"

    show lizhead happy with eidissolve

    "Liz gives me a half-hearted smile, but she still seems sad about something..."

    show lizhead explaining with eidissolve

    L "Anyways, sorry for talking your ear off about private matters. You still wanna get that submission turned in?"

    show lizhead at movexy(0.79, 0.05)
    show lizhead neutral right with eidissolve

    "She stops for a second on one tab to scan for something."
    pause 0.5

    L "{cps=20}Aaaaaaannnnnddd...{/cps}{w=.3} Got it!"

    show lizhead at movexy(0.6 - LIZHEADX_NEUTRAL, LIZHEADY_NEUTRAL, 1.25)
    show lizhead left with eidissolve

    "She motions her head to the back of the room at the printer as it hums to life."

    show inco at moveoutleft_cs(0.3)
    show inco left with eidissolve
    hide inco

    "I get up and get the paper. Both my username and password here are strings of numbers."

    "I take a snapshot of the username and password so I won't have to remember it."

    show inco at moveinright(0.3) with eidissolve

    I "Thanks."
    pause 0.5

    L "Anyways, you should hurry, lunch is ending soon."
    window auto hide

    show lizhead:
        parallel:
            ease_cubic 1.5 ypos 0.05
        parallel:
            movex(0.79, 2.0)

    show inco at moveoutleft_cs(0.3) with None

    show inco left
    show lizhead unimpressed right
    with eidissolve

    hide inco
    pause 0.5

    scene bg_computerroom with dissolve:
        xzoom -1.0
    pause 0.5

    show inco neutral left at moveinleft(0.7) with eidissolve

    "Right, according to the time display on the monitor I've only got ten minutes left."
    pause 0.5

    "I followed the instructions on the printout, finally getting to the student hub of the site."

    "And thankfully the art contest is displayed prominently across it."

    "Clicking through a couple of links I finally find the submission instructions."

    "It's simply a matter of putting my entry details as the name of the file and dragging it into the school's shared drive."
    pause 0.5

    "Plugging in my portable portfolio hard drive, I create a copy of my magnum opus."

    "Then a quick rename, draaag it here and{cps=5}...{/cps}"

    play sound snd_school_bell fadein 0.5

    pause 1.0
    stop sound fadeout 5

    "Just in time."

    show inco happy with eidissolve

    "I take the extra minute to safely undock my hard drive and then log off the computer."
    window auto hide
    pause 0.25

    scene bg_computerroom
    show lizhead unimpressed at setxy(0.79, 0.05)
    show lizbody furious:
        setxy(0.6, 0.1)
        block:
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.5
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.25
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 1.0
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            linear 0.05      ypos 0.105
            easein_cubic 0.2 ypos 0.1
            pause 0.5
            repeat
    with dissolve
    pause 0.25

    show inco neutral at moveinright(0.3) with eidissolve

    "Looking back to Liz, she's completely wrapped up in her work."

    "Don't think interrupting her is a good idea."

    "Especially after what she said about Olivia and our own time."
    pause 0.5

    "I opt to simply leave her be, heading out of the room and the library for class."

    "After all, it's time for the class I'd been looking forward to most!"

    show inco at moveoutleft_cs(0.3)
    show inco happy left with eidissolve
    hide inco
    pause 0.5

    "This day is certainly turning out better than yesterday."
    pause 0.5

    "{cps=5}...{/cps}"
    window auto hide
    stop music fadeout 3
    pause 0.5

    scene black with dissolve
    pause 0.5

    "Hope I didn't just jinx it for myself."
    pause 0.5

    "{cps=5}...{/cps}"
    window auto hide
    pause 1.0

    return
