
init -1 python:

#idk non-functional dummies for uisounds hackery
#coming soon

    def onclick_audio(flag, _audioflag=False):
        audio_filename=["audio/ui/snd_ui_option_on.wav", "audio/ui/snd_ui_option_off.wav"]
        if _audioflag:
            audio_filename=["audio/ui/snd_ui_option_off.wav", "audio/ui/snd_ui_option_on.wav"]
        renpy.play(audio_filename[int(bool(flag))])

#  def ToggleMuteAll():
#    if preferences.all_mute == True:
#      renpy.play("audio/ui/snd_ui_option_off.wav")
#    else:
#      renpy.play("audio/ui/snd_ui_option_on.wav")
#    preferences.all_mute = not preferences.all_mute


################################################################################
## Initialization
################################################################################

init offset = -1

################################################################################
## Styles
################################################################################

style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)



################################################################################
## In-game screens
################################################################################


## Say screen ##################################################################
##
## The say screen is used to display dialogue to the player. It takes two
## parameters, who and what, which are the name of the speaking character and
## the text to be displayed, respectively. (The who parameter can be None if no
## name is given.)
##
## This screen must create a text displayable with id "what", as Ren'Py uses
## this to manage text display. It can also create displayables with id "who"
## and id "window" to apply style properties.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):
    style_prefix "say"

    window:
        id "window"

        if who is not None:
            background Image("gui/textbox_long.png", xalign=0.5, yalign=1.0)
            window:
                id "namebox"
                style "namebox"
                text who id "who"
        else:
            background Image("gui/textbox_no_hitch.png", xalign=0.5, yalign=1.0)

        text what id "what"

    ## If there's a side image, display it above the text. Do not display on the
    ## phone variant - there's no room.
    if not renpy.variant("small"):
        add SideImage() xalign 0.0 yalign 1.0


## Make the namebox available for styling through the Character object.
init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height
    xoffset 0
    yoffset gui.window_yoffset
    xcenter 0.5

style namebox:
    xalign 0.5
    xpos gui.name_xpos
    ypos gui.name_ypos

style say_label:
    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5
    xanchor gui.name_xalign

style say_dialogue:
    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos


## Input screen ################################################################
##
## This screen is used to display renpy.input. The prompt parameter is used to
## pass a text prompt in.
##
## This screen must create an input displayable with id "input" to accept the
## various input parameters.
##
## https://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"

    window:
        add Image("gui/textbox_no_hitch.png", xalign=0.5, yalign=1.0, yoffset=gui.input_yoffset) #for mobile OSK
        vbox:
            xalign gui.dialogue_text_xalign
            xpos gui.dialogue_xpos
            xsize gui.dialogue_width
            ypos gui.dialogue_ypos
            yoffset gui.input_yoffset #for mobile OSK

            text prompt style "input_prompt"
            input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")

style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width


## Choice screen ###############################################################
##
## This screen is used to display the in-game choices presented by the menu
## statement. The one parameter, items, is a list of objects, each with caption
## and action fields.
##
## https://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action


## When this is true, menu captions will be spoken by the narrator. When false,
## menu captions will be displayed as empty buttons.
define config.narrator_menu = True


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    ypos 405
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")
    activate_sound "audio/ui/snd_ui_click.wav"

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")


## Quick Menu screen ###########################################################
##
## The quick menu is displayed in-game to provide easy access to the out-of-game
## menus.

screen quick_button(filename, label, function):
    button:
        xsize 71
        ysize 71
        action function
        if 'Return' in label or 'Back' in label or 'Menu' in label:
            activate_sound "audio/ui/snd_ui_back.wav"
        else:
            activate_sound "audio/ui/snd_ui_click.wav"
        fixed:
            add filename xalign 0.5 yalign 0.5 zoom 1
            text label xalign 0.5 yalign 0.5 xanchor 0.5 size 22 style "quick_button_text"

# label_functions is [ [ "label", function() ], [ "foobar", foobar() ], .. ]
# Reuse the same image string and keep things 'neat'.
screen quick_buttons(filename, label_functions):
    for l_f in label_functions:
        use quick_button(filename, l_f[0], l_f[1])

screen quick_menu():

    ## Ensure this appears on top of other screens.
    zorder 100
    if quick_menu:
        window:
            xpos 1.45
            ypos 0.977
            vbox:
                style_prefix "quick"
                spacing 1

                use quick_buttons("gui/button/uioptionbuttons/template_idle.png",
                    [
                        [ "Skip", Skip() ],
                        [ "Save", ShowMenu('save') ],
                        [ "Auto", Preference("auto-forward", "toggle") ],
                        [ "Load", ShowMenu('load') ]
                    ] )

screen debug_menu():
    zorder 100
    window:
        background "gui/debug.webp"
        xalign -1.0
        yalign 0.0
        grid 1 3:
            style_prefix "score"
            xalign 0.0
            yalign 0.0
            text "incos: " + str(score_inco)
            text "olivias: " + str(score_olivia)
            text "DEBUG SCORE CARD"


## This code ensures that the quick_menu screen is displayed in-game, whenever
## the player has not explicitly hidden the interface.
init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    #properties gui.button_text_properties("quick_button")
    color "#FFFFFF"
    hover_color gui.hover_color
    selected_color "#3affb3"


################################################################################
## Main and Game Menu Screens
################################################################################

## Navigation screen ##########################################################
##
## This screen is included in the main and game menus, and provides navigation
## to other menus, and to start the game.


transform tf_navigation_hover:
    zoom 1.1
transform tf_navigation_idle:
    zoom 1.1

screen navigation():

    vbox:
        style_prefix "navigation"
        xpos gui.notMM_navigation_xpos
        yalign 0.5

        spacing gui.navigation_spacing


        textbutton _("History") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("history") hovered 
        textbutton _("Save") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("save")
        textbutton _("Load") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("load")
        textbutton _("Delete") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("delete")
        textbutton _("Options") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("preferences")
        #textbutton _("Extras") action ShowMenu("extras")
        textbutton _("Return") activate_sound "audio/ui/snd_ui_back.wav" action Return()

        if _in_replay:

            textbutton _("End Replay") activate_sound "audio/ui/snd_ui_back.wav" action EndReplay(confirm=True)

        elif not main_menu:

            textbutton _("Main Menu") activate_sound "audio/ui/snd_ui_back.wav" action MainMenu()

        if config.developer:
            textbutton _("Debug Menu") activate_sound "audio/ui/snd_ui_click.wav" action ShowMenu("debug_menu")

        #if renpy.variant("pc"):

            ## The quit button is banned on iOS and unnecessary on Android and
            ## Web.
            #textbutton _("Quit") action Quit()


style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")


## Main Menu screen ############################################################
##
## Used to display the main menu when Ren'Py starts.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

#similar to quick_button funcs
screen main_menu_button(filename, label, function):
    button:
        xmaximum 300
        ymaximum 129
        action function
        if 'Back' in label or 'Return' in label or 'Quit' in label or 'Main Menu' in label:
            activate_sound "audio/ui/snd_ui_back.wav"
        else:
            activate_sound "audio/ui/snd_ui_click.wav"
        fixed:
            add filename xalign 0.5 yalign 0.5 zoom 1 xanchor 0 xcenter 0.5 ycenter 0.5
            text label xalign 0.5 yalign 0.4 size 50 outlines [ (absolute(3), "#342F6C") ]

#image bonus_flash:
#    "gui/button/menubuttons/title_button.png"
#    matrixcolor TintMatrix(Color((5*255, 5*255, 5*255)))
#    easeout_cubic 0.30 matrixcolor TintMatrix(Color((255, 255, 255)))
#    pause 0.133
#    repeat 4


image template_black_m = Composite(
    (511, 129),
    (6, 5), Crop((0, 0, 511-12, 129-12), Solid("#000000", width=2, height=2)),
    (0, 0), "gui/button/menubuttons/title_button.png",
    (0, 0), "gui/button/menubuttons/title_button.png"
)

image template_black:
    "template_black_m"
    matrixcolor TintMatrix(Color((0, 0, 0)))
    alpha 0.8

# screen bonus_chapter_button(f="gui/button/menubuttons/template_idle.png"):
# #("gui/button/menubuttons/template_idle.png", "Bonus Chapters", ShowMenu("ex_ch_menu"))
#     button:
#         xmaximum 500
#         ymaximum 129
#         xysize (500, 129)
#         action ShowMenu("ex_ch_menu")
#         activate_sound "audio/ui/snd_ui_click.wav"
#         fixed:
#             if persistent.old_endings != persistent.endings:
#                 add "bonus_flash" xalign 0.5 yalign 0.5 zoom 1 xanchor 0 xcenter 0.5 ycenter 0.5
#                 $ persistent.old_endings = persistent.endings
#             else:
#                 add f xalign 0.5 yalign 0.5 zoom 1 xanchor 0 xcenter 0.5 ycenter 0.5
#             text "Crash the game" xalign 0.5 yalign 0.5 xanchor 0.5

# label_functions is [ [ "label", function() ], [ "foobar", foobar() ], .. ]
# Reuse the same image string and keep things 'neat'.

screen main_menu_buttons(filename, label_functions):
    for l_f in label_functions:
        use main_menu_button(filename, l_f[0], l_f[1])

#transform bonus_notif:
#    pause 6.00
#    easeout_cubic 0.65 alpha 0

screen main_menu():

    ## This ensures that any other menu screen is replaced.
    tag menu

    style_prefix "main_menu"
    add gui.main_menu_background

    ## This empty frame darkens the main menu.
    frame:
        pass

    #if renpy.seen_image("big ending"):
    #    style_prefix "main_menu_ex"
    #    add "big ending"
    #else:
    #    style_prefix "main_menu"
    #    add gui.main_menu_background
    #
    #    ## This empty frame darkens the main menu.
    #    frame:
    #        pass

    #if persistent.old_endings != persistent.endings:
    #    fixed:
    #        xalign 0.125
    #        yalign 0.5
    #        xsize int(1920/2)
    #        ysize int(1080/4) 
    #        at bonus_notif
    #        fixed:
    #            add Solid("#000")
    #            add Solid(gui.accent_color) xysize ( int(1920/2)-20, int(1080/4)-12 ):
    #                xalign 0.5
    #                yalign 0.5
    #        if persistent.endings == 0b1111:
    #            text "You have unlocked all bonus chapters!" style "main_menu_text" yalign 0.5
    #        else:
    #            text "You have unlocked new bonus chapters, complete unseen endings to see more!" style "main_menu_text" yalign 0.5

    ## The use statement includes another screen inside this one. The actual
    ## contents of the main menu are in the navigation screen.
    add "gui/title_overlay.png"

    hbox:
        xalign 0.5
        spacing 1
        ypos 30
        #if renpy.seen_image('big ending'):
        #    use main_menu_button("template_black", "Start", Start())
        #    # use bonus_chapter_button("template_black")
        #    use main_menu_buttons("template_black",
        #        [
        #            [ "Load", ShowMenu("load") ],
        #            [ "Options", ShowMenu("preferences") ],
        #            [ "Extras", ShowMenu("extras") ], \
        #            [ "Quit", Quit(confirm=not main_menu) ]
        #        ] )
        #else:
        use main_menu_button("gui/button/menubuttons/title_button.png", "Start", Start())
        # use bonus_chapter_button()
        use main_menu_buttons("gui/button/menubuttons/title_button.png",
            [
                [ "Load", ShowMenu("load") ],
                [ "Options", ShowMenu("preferences") ],
                [ "Extras", ShowMenu("extras") ], \
                [ "Quit", Quit(confirm=not main_menu) ]
            ] )
        #on "show" action renpy.start_predict_screen("cg_gallery")
    vbox:
        xpos 1885
        yalign 0.4
        add "spr_ui_logo" zoom 0.5
    #vbox:
    #    xpos 2005
    #    yalign 0.05
    #    if persistent.splashtype == 1:
    #       add "gui/sneedgame.png"
    #    else:
    #       add "gui/snootgame.png"

style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    ysize 120
    xfill True
    #background "gui/title_overlay.png"
    

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -60

style main_menu_text:
    properties gui.text_properties("main_menu") #, accent=True)
    color gui.main_menu_color
    hover_color gui.hover_color
    size gui.main_menu_text_size

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_ex is main_menu
style main_menu_ex_vbox is main_menu_vbox
style main_menu_ex_text is main_menu_text
style main_menu_ex_frame is main_menu_frame

#style main_menu_ex_button:
#color "#222"
#background "gui/button/menubuttons/template_idle.png"
#xalign 0.5 yalign 0.5 zoom 1 xanchor 0 xcenter 0.5 ycenter 0.5

#style main_menu_ex_button:
#color "#222"



#style main_menu_version:
#    properties gui.text_properties("version")

# style

## Game Menu screen ############################################################
##
## This lays out the basic common structure of a game menu screen. It's called
## with the screen title, and displays the background, title, and navigation.
##
## The scroll parameter can be None, or one of "viewport" or "vpgrid". When
## this screen is intended to be used with one or more children, which are
## transcluded (placed) inside it.

screen game_menu(title, scroll=None, yinitial=0.0):

    style_prefix "game_menu"

    if main_menu:
        add gui.main_menu_background
        add "gui/backdrop.png"
        add "gui/seperator.png"
    else:
        add gui.game_menu_background
        add "gui/backdrop.png"
        add "gui/seperator.png"

    frame:
        style "game_menu_outer_frame"

        hbox:

            ## Reserve space for the navigation section.
            frame:
                style "game_menu_navigation_frame"

            frame:
                style "game_menu_content_frame"

                if scroll == "viewport":

                    viewport:
                        yinitial yinitial
                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        vbox:
                            transclude

                elif scroll == "vpgrid":

                    vpgrid:
                        cols 1
                        yinitial yinitial

                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        transclude

                else:

                    transclude

    use navigation

    add "gui/banner.png"
    label title

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style game_menu_label_text:
    xpos 40

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 45
    top_padding 180

    # background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 420
    yfill True

style game_menu_content_frame:
    left_margin 60
    right_margin 30
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45


## About screen ################################################################
##
## This screen gives credit and copyright information about the game and Ren'Py.
##
## There's nothing special about this screen, and hence it also serves as an
## example of how to make a custom screen.

screen about():

    tag menu
    style_prefix "main_menu"

    add gui.main_menu_background
    add "gui/backdrop.png"

    ## This empty frame darkens the main menu.
    frame:
        pass

    ## The use statement includes another screen inside this one. The actual
    ## contents of the main menu are in the navigation screen.

    vbox:
        yalign 0.00
        yoffset 200
        xoffset 80
        xmaximum 1800
        label "[config.name!t]"
        text _("Version [config.version!t]\n")

        ## gui.about is usually set in options.rpy.
        if gui.about:
            text "[gui.about!t]\n"

        style_prefix "quick"
        text _("{size=30}Made with {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only].\n\n[renpy.license!t]\n\nTo find more information about the game (and its source code) please visit {a=https://www.hugthegator.xyz/}our website{/a}.{/size}") text_align 0
    use extrasnavigation

## Load and Save screens #######################################################
##
## These screens are responsible for letting the player save the game and load
## it again. Since they share nearly everything in common, both are implemented
## in terms of a third screen, file_slots.
##
## https://www.renpy.org/doc/html/screen_special.html#save https://
## www.renpy.org/doc/html/screen_special.html#load

screen save():

    tag menu

    use file_slots(_("Save"))


screen load():

    tag menu

    use file_slots(_("Load"))

screen delete():

    tag menu

    use file_slots(_("Delete"), True)

screen file_slots(title, flag=False):

    default page_name_value = FilePageNameInputValue(pattern=_("Page {}"), auto=_("Automatic saves"), quick=_("Quick saves"))

    use game_menu(title):

        fixed:

            ## This ensures the input will get the enter event before any of the
            ## buttons do.
            order_reverse True

            ## The page name
            button:
                style "page_label"

                key_events True
                xalign 0.5
                #action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value

            ## The grid of file slots.
            grid gui.file_slot_cols gui.file_slot_rows:
                style_prefix "slot"

                xalign 0.5
                yalign 0.5

                spacing gui.slot_spacing

                for i in range(gui.file_slot_cols * gui.file_slot_rows):

                    $ slot = i + 1

                    button:
                        if flag:
                            action FileDelete(slot)
                        else:
                            action FileAction(slot)

                        has vbox

                        add FileScreenshot(slot) xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%A, %B %d %Y, %H:%M"), empty=_("Empty Slot")):
                            style "slot_time_text"

                        text FileSaveName(slot):
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)

            ## Buttons to access other pages.
            hbox:
                style_prefix "page"

                xalign 0.5
                yalign 1.0

                spacing gui.page_spacing

                textbutton _("<") activate_sound "audio/ui/snd_ui_click.wav" action FilePagePrevious()

                if config.has_autosave:
                    textbutton _("{#auto_page}A") activate_sound "audio/ui/snd_ui_click.wav" action FilePage("auto")

                if config.has_quicksave:
                    textbutton _("{#quick_page}Q") activate_sound "audio/ui/snd_ui_click.wav" action FilePage("quick")

                ## range(1, 10) gives the numbers from 1 to 9.
                for page in range(1, 10):
                    textbutton "[page]" activate_sound "audio/ui/snd_ui_click.wav" action FilePage(page)

                textbutton _(">") activate_sound "audio/ui/snd_ui_click.wav" action FilePageNext(max=9)


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75
    ypadding 5

style page_label_text:
    text_align 0.5
    layout "subtitle"
    hover_color gui.hover_color

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.button_text_properties("page_button")

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.button_text_properties("slot_button")


## Preferences screen ##########################################################
##
## The preferences screen allows the player to configure the game to better suit
## themselves.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences

screen preferences():

    tag menu

    use game_menu(_("Options"), scroll="viewport"):

        vbox:

            hbox:
                box_wrap True

                if renpy.variant("pc") or renpy.variant("web"):

                    vbox:
                        style_prefix "radio"
                        label _("Display")
                        textbutton _("Window") activate_sound "audio/ui/snd_ui_option_on.wav" action Preference("display", "any window")
                        textbutton _("Fullscreen") activate_sound "audio/ui/snd_ui_option_on.wav" action Preference("display", "fullscreen")

                vbox:
                    style_prefix "radio"
                    label _("Rollback Side")
                    textbutton _("Disable") activate_sound "audio/ui/snd_ui_option_on.wav" action Preference("rollback side", "disable")
                    textbutton _("Left") activate_sound "audio/ui/snd_ui_option_on.wav" action Preference("rollback side", "left")
                    textbutton _("Right") activate_sound "audio/ui/snd_ui_option_on.wav" action Preference("rollback side", "right")
                vbox:
                    style_prefix "check"
                    label _("Naughty Stuff")
                    textbutton _("Enable Saucy Images") action [Function(onclick_audio, persistent.lewd), ToggleVariable("persistent.lewd", True, False)]

                #vbox:
                #    style_prefix "check"
                #    label _("Language")
                #    vpgrid:
                #        rows len(languages)
                #        cols 1
                #        mousewheel True
                #        draggable True
                #        xsize 300
                #        ysize 250
                #        if len(languages)>4:
                #            scrollbars "vertical"
                #        for lang in languages:
                #            fixed:
                #                xsize 300
                #                ysize 60
                #                use lang_button(lang)

                vbox:
                    style_prefix "check"
                    label _("Requires Restart")
                    textbutton _("Enable Forward-Scroll Movement") action [Function(onclick_audio, persistent.scroll), ToggleVariable("persistent.scroll", True, False)]

                vbox:
                    style_prefix "check"
                    label _("Skip")
                    textbutton _("Unseen Text") action [Function(onclick_audio, preferences.skip_unseen), ToggleVariable("preferences.skip_unseen", True, False)]
                    textbutton _("After Choices") action [Function(onclick_audio, preferences.skip_after_choices), ToggleVariable("preferences.skip_after_choices", True, False)]
                    textbutton _("Transitions") action [Function(onclick_audio, preferences.transitions, True), ToggleVariable("preferences.transitions", 0, 2)]

                ## Additional vboxes of type "radio_pref" or "check_pref" can be
                ## added here, to add additional creator-defined preferences.

            null height (4 * gui.pref_spacing)

            hbox:
                style_prefix "slider"
                box_wrap True

                vbox:

                    label _("Text Speed")

                    bar value Preference("text speed")

                    label _("Auto-Forward Time")

                    bar value Preference("auto-forward time")

                vbox:

                    if config.has_music:
                        label _("Music Volume")
                        hbox:
                            bar value Preference("music volume") yalign 0.5
                            textbutton _("Reset"):
                                action Function(preferences.set_volume, 'music', config.default_music_volume)

                    if config.has_sound:

                        label _("Sound Volume")
                        hbox:
                            bar value Preference("sfx volume") yalign 0.5
                            textbutton _("Reset"):
                                action Function(preferences.set_volume, 'sfx', config.default_sfx_volume)
                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound)

                        label _("UI Sounds Volume")
                        hbox:
                            bar value Preference("ui volume") yalign 0.5
                            textbutton _("Reset"):
                                yalign 0.5
                                action Function(preferences.set_volume, 'ui', config.default_sfx_volume)

                    if config.has_voice:
                        label _("Voice Volume")
                        hbox:
                            bar value Preference("voice volume") yalign 0.5
                            textbutton _("Reset"):
                                yalign 0.5
                                action Function(preferences.set_volume, 'voice', config.default_sfx_volume)
                            if config.sample_voice:
                                textbutton _("Test") action Play("voice", config.sample_voice)

                    if config.has_music or config.has_sound or config.has_voice:
                        null height gui.pref_spacing
                        textbutton _("Mute All"):
                            action Preference("all mute", "toggle")
                            style "mute_all_button"


style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/radio_[prefix_]foreground.png"

style radio_button_text:
    properties gui.button_text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.button_text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.button_text_properties("slider_button")

style slider_vbox:
    xsize 675


## History screen ##############################################################
##
## This is a screen that displays the dialogue history to the player. While
## there isn't anything special about this screen, it does have to access the
## dialogue history stored in _history_list.
##
## https://www.renpy.org/doc/html/history.html

screen history():

    tag menu

    ## Avoid predicting this screen, as it can be very large.
    predict False

    use game_menu(_("History"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0):

        style_prefix "history"

        for h in _history_list:

            window:

                ## This lays things out properly if history_height is None.
                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"
                        substitute False

                        ## Take the color of the who text from the Character, if
                        ## set.
                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what:
                    substitute False

        if not _history_list:
            label _("The dialogue history is empty.")


## This determines what tags are allowed to be displayed on the history screen.

define gui.history_allow_tags = set()


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    text_align gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    text_align gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5

## Extras screen########################################################
## A screen that combines help, about, updates, gallery,
screen extras():
    tag menu

    style_prefix "main_menu"
    add gui.main_menu_background

    add "gui/title_overlay.png"

    ## This empty frame darkens the main menu.
    frame:
        pass

    vbox:
        xpos 1885
        yalign 0.4
        add "spr_ui_logo" zoom 0.5

    use extrasnavigation

##Extras Navigation Screen #####################################################
##
##This screen is to be reused in
screen extrasnavigation():
    #vbox:
    #    xpos 1940
    #    yalign 0.03
    #
    #    if persistent.splashtype == 1:
    #        add "gui/sneedgame.png"
    #    else:
    #        add "gui/snootgame.png"
    hbox:
        xalign 0.5
        spacing 1
        ypos 30

        use main_menu_buttons("gui/button/menubuttons/title_button.png",
            [
                [ "Help", ShowMenu("help") ],
                [ "About", ShowMenu("about") ],
                # [ "Gallery", ShowMenu("cg_gallery") ],
                [ "Mods", ShowMenu("mod_menu") ],
                [ "Return", ShowMenu("main_menu") ]
            ] )
        #add Null(0, 129)


## Help screen #################################################################
##
## A screen that gives information about key and mouse bindings. It uses other
## screens (keyboard_help, mouse_help, and gamepad_help) to display the actual
## help.

screen help():

    tag menu

    style_prefix "main_menu"

    add gui.main_menu_background
    add "gui/backdrop.png"

    ## This empty frame darkens the main menu.
    frame:
        pass

    default device = "keyboard"

    # vbox:
    #     xpos 1100
    #     ## ypos 1000
    #     yalign 0.4
    #     spacing 23

    fixed:
        vbox:
            xalign 0.8
            yalign 0.5
            spacing 23
            style_prefix "help"
            textbutton _("Keyboard") action SetScreenVariable("device", "keyboard")
            textbutton _("Mouse") action SetScreenVariable("device", "mouse")
            if GamepadExists():
                textbutton _("Gamepad") action SetScreenVariable("device", "gamepad")

        vbox:
            yalign 0.5
            xpos 1100
            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "gamepad":
                use gamepad_help
        text _("") ## again in here to keep vbox in check

    use extrasnavigation



screen keyboard_help():
    style_prefix "help"
    hbox:
        label _("Enter")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Space")
        text _("Advances dialogue without selecting choices.")

    hbox:
        label _("Arrow Keys")
        text _("Navigate the interface.")

    hbox:
        label _("Escape")
        text _("Accesses the game menu. Also escapes the Gallery.")

    hbox:
        label _("Ctrl")
        text _("Skips dialogue while held down.")

    hbox:
        label _("Tab")
        text _("Toggles dialogue skipping.")

    hbox:
        label _("Page Up")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Page Down")
        text _("Rolls forward to later dialogue.")

    hbox:
        label "H"
        text _("Hides the user interface.")

    hbox:
        label "S"
        text _("Takes a screenshot.")

    hbox:
        label "V"
        text _("Toggles assistive {a=https://www.renpy.org/l/voicing}self-voicing{/a}.")


screen mouse_help():
    style_prefix "help"
    hbox:
        label _("Left Click")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Middle Click")
        text _("Hides the user interface.")

    hbox:
        label _("Right Click")
        text _("Accesses the game menu. Also escapes the Gallery.")

    hbox:
        label _("Mouse Wheel Up\nClick Rollback Side")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Mouse Wheel Down")
        text _("Rolls forward to later dialogue.")


screen gamepad_help():
    style_prefix "help"
    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Left Trigger\nLeft Shoulder")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Right Shoulder")
        text _("Rolls forward to later dialogue.")


    hbox:
        label _("D-Pad, Sticks")
        text _("Navigate the interface.")

    hbox:
        label _("Start, Guide")
        text _("Accesses the game menu.")

    hbox:
        label _("Y/Top Button")
        text _("Hides the user interface.")

    textbutton _("Calibrate") action GamepadCalibrate() xalign 0.3 ypos 50

#this bit is might need trimming or rework
style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.button_text_properties("help_button")
    size 40

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    text_align 1.0

################################################################################
## Additional screens
################################################################################


## Confirm screen ##############################################################
##
## The confirm screen is called when Ren'Py wants to ask the player a yes or no
## question.
##
## https://www.renpy.org/doc/html/screen_special.html#confirm

screen confirm(message, yes_action, no_action):

    ## Ensure other screens do not get input while this screen is displayed.
    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"

    frame:

        vbox:
            xalign .5
            yalign .5
            spacing 45

            label _(message):
                style "confirm_prompt"
                xalign 0.5

            hbox:
                xalign 0.5
                spacing 150

                textbutton _("Yes") activate_sound "audio/ui/snd_ui_click.wav" action yes_action
                textbutton _("No") activate_sound "audio/ui/snd_ui_back.wav" action no_action

    ## Right-click and escape answer "no".
    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    text_align 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.button_text_properties("confirm_button")


## Skip indicator screen #######################################################
##
## The skip_indicator screen is displayed to indicate that skipping is in
## progress.
##
## https://www.renpy.org/doc/html/screen_special.html#skip-indicator

screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        hbox:
            spacing 9

            text _("Skipping")

            text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.2, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.4, 1.0) style "skip_triangle"


## This transform is used to blink the arrows one after another.
transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:
    ## We have to use a font that has the BLACK RIGHT-POINTING SMALL TRIANGLE
    ## glyph in it.
    font "DejaVuSans.ttf"


## Notify screen ###############################################################
##
## The notify screen is used to show the player a message. (For example, when
## the game is quicksaved or a screenshot has been taken.)
##
## https://www.renpy.org/doc/html/screen_special.html#notify-screen

screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text "[message!tq]"

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    properties gui.text_properties("notify")


## NVL screen ##################################################################
##
## This screen is used for NVL-mode dialogue and menus.
##
## https://www.renpy.org/doc/html/screen_special.html#nvl


screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing

        ## Displays dialogue in either a vpgrid or the vbox.
        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)

        ## Displays the menu, if given. The menu may be displayed incorrectly if
        ## config.narrator_menu is set to True, as it is above.
        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            fixed:
                yfit gui.nvl_height is None

                if d.who is not None:

                    text d.who:
                        id d.who_id

                text d.what:
                    id d.what_id


## This controls the maximum number of NVL-mode entries that can be displayed at
## once.
define config.nvl_list_length = gui.nvl_list_length

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")



################################################################################
## Mobile Variants
################################################################################

style pref_vbox:
    variant "medium"
    xsize 675

## Since a mouse may not be present, we replace the quick menu with a version
## that uses fewer and bigger buttons that are easier to touch.

#redefine function
screen quick_button(filename, label, function):
    variant "mobile"
    button:
        xmaximum 124
        ymaximum 124
        action function
        fixed:
            add filename xalign 0.5 yalign 0.5 zoom 1.75
            text label xalign 0.5 yalign 0.5 size 42 style "quick_button_text"

screen quick_menu():
    variant "mobile"
    zorder 100
    if quick_menu:
        hbox:
            spacing 28
            style_prefix "quick"
            xalign 0.5
            yalign 0.975
            use quick_buttons("gui/button/uioptionbuttons/template_idle.png", \
                [ \
                    [ "Back", Rollback() ], \
                    [ "Skip", Skip() ], \
                    [ "Auto", Preference("auto-forward", "toggle") ], \
                    [ "Menu", ShowMenu() ] \
                ] )

screen extrasnavigation(): #Updates are removed (not even supported by Ren'Py)
    variant "mobile"
    vbox:
        xpos 1940
        yalign 0.03

        if persistent.splashtype == 1:
            add "gui/sneedgame.png"
        else:
            add "gui/snootgame.png"
    vbox:
        spacing 25
        xpos 1885
        yalign 0.9
        use main_menu_buttons("gui/button/menubuttons/template_idle.png",
            [
                [ "Help", ShowMenu("help") ],
                [ "About", ShowMenu("about") ],
                #[ "Gallery", ShowMenu("cg_gallery") ],
                [ "Mods", ShowMenu("mod_menu") ],
                [ "Return", ShowMenu("main_menu") ]
            ] )

style radio_button:
    variant "mobile"
    foreground "gui/phone/button/radio_[prefix_]foreground.png"

style check_button:
    variant "mobile"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "mobile"
    background "gui/phone/nvl.png"

style game_menu_outer_frame:
    variant "mobile"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "mobile"
    xsize 510

style game_menu_content_frame:
    variant "mobile"
    top_margin 0

style pref_vbox:
    variant "mobile"
    xsize 600

style bar:
    variant "mobile"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "mobile"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "mobile"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "mobile"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "mobile"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "mobile"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_pref_vbox:
    variant "mobile"
    xsize None

style slider_pref_slider:
    variant "mobile"
    xsize 900
