var gameLoadWeight = 0.2; // Weight assigned to the initial game loading on the progress bar
var networkTimeoutDelay = 2000; // If no update occurs during this time, the connection is reset
var networkTimeoutMaxProgress = 0.9; // Progress above which the connection is never reset
var networkTimeout; // The timeout used to reset the connection
var downloadProgress = 0; // The total download progress
var game = {};
var gameInstanceUrl = "";

function Initialize(url)
{
  gameInstanceUrl = url;
  return LoadInstance();
}
function LoadInstance()
{
  return gameInstance = UnityLoader.instantiate("gameContainer", gameInstanceUrl, {onProgress: UnityProgress});
}

function UnityProgress(gameInstance, progress) {
  if (!gameInstance.Module)
    return;
  // Initialize
  if (progress == 0)
  {
    game.logo = $("#logo");
    game.progress = $("#progress");
    game.empty = $("#progress .empty");
    game.full = $("#progress .full");
    game.progressText = $("#progress_text");
    game.errorText = $("#error_text");
    game.container = $("#gameContainer");
    game.canvas = $("#gameContainer canvas");
    game.container[0].style.backgroundImage = "";
    downloadProgress = 0;
    UpdateGameContainerSize();
  }
  
  // Hide the logo
  if (progress == 1)
    game.logo.fadeOut(3000, function() { });
  UpdateProgress(progress * gameLoadWeight, "");
  // Network timeout
  if (progress < networkTimeoutMaxProgress && progress > 0)
    networkTimeout = setTimeout(function(){ console.log("Network timeout!"); LoadInstance(); }, networkTimeoutDelay);
}

function UpdateProgress(progress, progressText)
{
  // Reset the network timeout
  if (networkTimeout)
    clearTimeout(networkTimeout);
  networkTimeout = null;
  // Update the progress bars
  if (progress > downloadProgress)
    downloadProgress = progress;
  game.full[0].style.width = (100 * downloadProgress) + "%";
  game.empty[0].style.width = (100 * (1 - downloadProgress)) + "%";
  game.progressText.text(progressText);
  // End
  if (progress == 1)
  {
    game.progress.fadeOut(1000, function() { });
    game.progressText.fadeOut(500, function() { });
  }
}

// Display a network error
function NetworkError(error)
{
  game.errorText.text("");
}

// Update the size of the game to fit the size of the window
var fullWindow = false; // If the canvas takes all the window
function UpdateGameContainerSize()
{
  // Initialize
  if (!game.sizeInitialized)
  {
    game.sizeInitialized = {};
    game.sizeInitialized.baseWidth = parseInt(game.container.width());
    game.sizeInitialized.baseHeight = parseInt(game.container.height());
    setInterval(function(){ UpdateGameContainerSize(); }, 100);
  }
  // Update the size
  var wantedWidth = window.innerWidth;
  var wantedHeight = window.innerHeight;
  if (!fullWindow)
  {
    // Do nothing on fullscreen
    if(window.innerHeight == screen.height)
      return;
    wantedWidth = Math.min(game.sizeInitialized.baseWidth, wantedWidth);
    wantedHeight = Math.min(game.sizeInitialized.baseHeight, wantedHeight);
  }
  //var wantedWidth = Math.min(window.innerWidth, window.innerHeight * 2); // The game can't handle more 2:1 aspect ratio
  if (parseInt(game.canvas.attr("width")) != wantedWidth || parseInt(game.canvas.attr("height")) != wantedHeight || parseInt(game.container.width()) != wantedWidth || parseInt(game.container.height()) != wantedHeight)
  {
    game.container.css("width", wantedWidth + "px");
    game.container.css("height", wantedHeight + "px");
    game.canvas.attr("width", wantedWidth);
    game.canvas.attr("height", wantedHeight);
  }
}