/* solid color wireframe.
 */


// color for wireframe lines
uniform vec3 uRGB;


// barycentric coordinates given by the geometry shader
in vec3 baryCoords;

out vec4 fsOut0;


void main(void)
{
	// default to filling polys to white
	vec3 outCol = vec3(0.0f, 0.0f, 0.0f);

	// if close to edge, use wireframe line color
	float minDist = min( min(baryCoords[0], baryCoords[1]), baryCoords[2] );
	// if ( minDist < 0.05f )
	{
		float t = smoothstep(0.0f, 0.05f, minDist);
		// t = exp2(-1.0*minDist);
		outCol = (1.0f - t) * uRGB + t * outCol;
	}

	fsOut0.rgb = outCol;
}