/* basic shader with vertex colors and skinning.
 */


#pragma include skinning.glsl


uniform mat4 uModelViewProjMat;


in vec3 vsInPos;
in vec4 vsInColor;

out vec4 fsInColor;


void main(void)
{
	vec4 skinned = skin( vec4(vsInPos, 1.0) );
	gl_Position = uModelViewProjMat * skinned;
	
	fsInColor = vsInColor;
}